"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupVault = exports.BackupVaultEvents = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const backup_generated_1 = require("./backup.generated");
/**
 * (experimental) Backup vault events.
 *
 * @experimental
 */
var BackupVaultEvents;
(function (BackupVaultEvents) {
    BackupVaultEvents["BACKUP_JOB_STARTED"] = "BACKUP_JOB_STARTED";
    BackupVaultEvents["BACKUP_JOB_COMPLETED"] = "BACKUP_JOB_COMPLETED";
    BackupVaultEvents["BACKUP_JOB_SUCCESSFUL"] = "BACKUP_JOB_SUCCESSFUL";
    BackupVaultEvents["BACKUP_JOB_FAILED"] = "BACKUP_JOB_FAILED";
    BackupVaultEvents["BACKUP_JOB_EXPIRED"] = "BACKUP_JOB_EXPIRED";
    BackupVaultEvents["RESTORE_JOB_STARTED"] = "RESTORE_JOB_STARTED";
    BackupVaultEvents["RESTORE_JOB_COMPLETED"] = "RESTORE_JOB_COMPLETED";
    BackupVaultEvents["RESTORE_JOB_SUCCESSFUL"] = "RESTORE_JOB_SUCCESSFUL";
    BackupVaultEvents["RESTORE_JOB_FAILED"] = "RESTORE_JOB_FAILED";
    BackupVaultEvents["COPY_JOB_STARTED"] = "COPY_JOB_STARTED";
    BackupVaultEvents["COPY_JOB_SUCCESSFUL"] = "COPY_JOB_SUCCESSFUL";
    BackupVaultEvents["COPY_JOB_FAILED"] = "COPY_JOB_FAILED";
    BackupVaultEvents["RECOVERY_POINT_MODIFIED"] = "RECOVERY_POINT_MODIFIED";
    BackupVaultEvents["BACKUP_PLAN_CREATED"] = "BACKUP_PLAN_CREATED";
    BackupVaultEvents["BACKUP_PLAN_MODIFIED"] = "BACKUP_PLAN_MODIFIED";
})(BackupVaultEvents = exports.BackupVaultEvents || (exports.BackupVaultEvents = {}));
/**
 * (experimental) A backup vault.
 *
 * @experimental
 */
class BackupVault extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        if (props.backupVaultName && !/^[a-zA-Z0-9\-_]{2,50}$/.test(props.backupVaultName)) {
            throw new Error('Expected vault name to match pattern `^[a-zA-Z0-9\-_]{2,50}$`');
        }
        let notifications;
        if (props.notificationTopic) {
            notifications = {
                backupVaultEvents: props.notificationEvents || Object.values(BackupVaultEvents),
                snsTopicArn: props.notificationTopic.topicArn,
            };
            props.notificationTopic.grantPublish(new iam.ServicePrincipal('backup.amazonaws.com'));
        }
        const vault = new backup_generated_1.CfnBackupVault(this, 'Resource', {
            backupVaultName: props.backupVaultName || this.uniqueVaultName(),
            accessPolicy: props.accessPolicy && props.accessPolicy.toJSON(),
            encryptionKeyArn: props.encryptionKey && props.encryptionKey.keyArn,
            notifications,
        });
        vault.applyRemovalPolicy(props.removalPolicy);
        this.backupVaultName = vault.attrBackupVaultName;
        this.backupVaultArn = vault.attrBackupVaultArn;
    }
    /**
     * (experimental) Import an existing backup vault.
     *
     * @experimental
     */
    static fromBackupVaultName(scope, id, backupVaultName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.backupVaultName = backupVaultName;
            }
        }
        return new Import(scope, id);
    }
    uniqueVaultName() {
        // Max length of 50 chars, get the last 50 chars
        const id = this.node.uniqueId;
        return id.substring(Math.max(id.length - 50, 0), id.length);
    }
}
exports.BackupVault = BackupVault;
//# sourceMappingURL=data:application/json;base64,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