import * as iam from "../../aws-iam";
import * as kms from "../../aws-kms";
import * as sns from "../../aws-sns";
import { IResource, RemovalPolicy, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) A backup vault.
 *
 * @experimental
 */
export interface IBackupVault extends IResource {
    /**
     * (experimental) The name of a logical container where backups are stored.
     *
     * @experimental
     * @attribute true
     */
    readonly backupVaultName: string;
}
/**
 * (experimental) Properties for a BackupVault.
 *
 * @experimental
 */
export interface BackupVaultProps {
    /**
     * (experimental) The name of a logical container where backups are stored.
     *
     * Backup vaults
     * are identified by names that are unique to the account used to create
     * them and the AWS Region where they are created.
     *
     * @default - A CDK generated name
     * @experimental
     */
    readonly backupVaultName?: string;
    /**
     * (experimental) A resource-based policy that is used to manage access permissions on the backup vault.
     *
     * @default - access is not restricted
     * @experimental
     */
    readonly accessPolicy?: iam.PolicyDocument;
    /**
     * (experimental) The server-side encryption key to use to protect your backups.
     *
     * @default - an Amazon managed KMS key
     * @experimental
     */
    readonly encryptionKey?: kms.IKey;
    /**
     * (experimental) A SNS topic to send vault events to.
     *
     * @default - no notifications
     * @see https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html
     * @experimental
     */
    readonly notificationTopic?: sns.ITopic;
    /**
     * (experimental) The vault events to send.
     *
     * @default - all vault events if `notificationTopic` is defined
     * @see https://docs.aws.amazon.com/aws-backup/latest/devguide/sns-notifications.html
     * @experimental
     */
    readonly notificationEvents?: BackupVaultEvents[];
    /**
     * (experimental) The removal policy to apply to the vault.
     *
     * Note that removing a vault
     * that contains recovery points will fail.
     *
     * @default RemovalPolicy.RETAIN
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
}
/**
 * (experimental) Backup vault events.
 *
 * @experimental
 */
export declare enum BackupVaultEvents {
    /**
     * (experimental) BACKUP_JOB_STARTED.
     *
     * @experimental
     */
    BACKUP_JOB_STARTED = "BACKUP_JOB_STARTED",
    /**
     * (experimental) BACKUP_JOB_COMPLETED.
     *
     * @experimental
     */
    BACKUP_JOB_COMPLETED = "BACKUP_JOB_COMPLETED",
    /**
     * (experimental) BACKUP_JOB_SUCCESSFUL.
     *
     * @experimental
     */
    BACKUP_JOB_SUCCESSFUL = "BACKUP_JOB_SUCCESSFUL",
    /**
     * (experimental) BACKUP_JOB_FAILED.
     *
     * @experimental
     */
    BACKUP_JOB_FAILED = "BACKUP_JOB_FAILED",
    /**
     * (experimental) BACKUP_JOB_EXPIRED.
     *
     * @experimental
     */
    BACKUP_JOB_EXPIRED = "BACKUP_JOB_EXPIRED",
    /**
     * (experimental) RESTORE_JOB_STARTED.
     *
     * @experimental
     */
    RESTORE_JOB_STARTED = "RESTORE_JOB_STARTED",
    /**
     * (experimental) RESTORE_JOB_COMPLETED.
     *
     * @experimental
     */
    RESTORE_JOB_COMPLETED = "RESTORE_JOB_COMPLETED",
    /**
     * (experimental) RESTORE_JOB_SUCCESSFUL.
     *
     * @experimental
     */
    RESTORE_JOB_SUCCESSFUL = "RESTORE_JOB_SUCCESSFUL",
    /**
     * (experimental) RESTORE_JOB_FAILED.
     *
     * @experimental
     */
    RESTORE_JOB_FAILED = "RESTORE_JOB_FAILED",
    /**
     * (experimental) COPY_JOB_STARTED.
     *
     * @experimental
     */
    COPY_JOB_STARTED = "COPY_JOB_STARTED",
    /**
     * (experimental) COPY_JOB_SUCCESSFUL.
     *
     * @experimental
     */
    COPY_JOB_SUCCESSFUL = "COPY_JOB_SUCCESSFUL",
    /**
     * (experimental) COPY_JOB_FAILED.
     *
     * @experimental
     */
    COPY_JOB_FAILED = "COPY_JOB_FAILED",
    /**
     * (experimental) RECOVERY_POINT_MODIFIED.
     *
     * @experimental
     */
    RECOVERY_POINT_MODIFIED = "RECOVERY_POINT_MODIFIED",
    /**
     * (experimental) BACKUP_PLAN_CREATED.
     *
     * @experimental
     */
    BACKUP_PLAN_CREATED = "BACKUP_PLAN_CREATED",
    /**
     * (experimental) BACKUP_PLAN_MODIFIED.
     *
     * @experimental
     */
    BACKUP_PLAN_MODIFIED = "BACKUP_PLAN_MODIFIED"
}
/**
 * (experimental) A backup vault.
 *
 * @experimental
 */
export declare class BackupVault extends Resource implements IBackupVault {
    /**
     * (experimental) Import an existing backup vault.
     *
     * @experimental
     */
    static fromBackupVaultName(scope: Construct, id: string, backupVaultName: string): IBackupVault;
    /**
     * (experimental) The name of a logical container where backups are stored.
     *
     * @experimental
     */
    readonly backupVaultName: string;
    /**
     * (experimental) The ARN of the backup vault.
     *
     * @experimental
     * @attribute true
     */
    readonly backupVaultArn: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: BackupVaultProps);
    private uniqueVaultName;
}
