"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupSelection = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const backup_generated_1 = require("./backup.generated");
const backupable_resources_collector_1 = require("./backupable-resources-collector");
const resource_1 = require("./resource");
/**
 * (experimental) A backup selection.
 *
 * @experimental
 */
class BackupSelection extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        this.listOfTags = [];
        this.resources = [];
        this.backupableResourcesCollector = new backupable_resources_collector_1.BackupableResourcesCollector();
        const role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('backup.amazonaws.com'),
        });
        role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSBackupServiceRolePolicyForBackup'));
        if (props.allowRestores) {
            role.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSBackupServiceRolePolicyForRestores'));
        }
        this.grantPrincipal = role;
        const selection = new backup_generated_1.CfnBackupSelection(this, 'Resource', {
            backupPlanId: props.backupPlan.backupPlanId,
            backupSelection: {
                iamRoleArn: role.roleArn,
                selectionName: props.backupSelectionName || this.node.id,
                listOfTags: core_1.Lazy.anyValue({
                    produce: () => this.listOfTags,
                }, { omitEmptyArray: true }),
                resources: core_1.Lazy.listValue({
                    produce: () => [...this.resources, ...this.backupableResourcesCollector.resources],
                }, { omitEmpty: true }),
            },
        });
        this.backupPlanId = selection.attrBackupPlanId;
        this.selectionId = selection.attrSelectionId;
        for (const resource of props.resources) {
            this.addResource(resource);
        }
    }
    addResource(resource) {
        if (resource.tagCondition) {
            this.listOfTags.push({
                conditionKey: resource.tagCondition.key,
                conditionType: resource.tagCondition.operation || resource_1.TagOperation.STRING_EQUALS,
                conditionValue: resource.tagCondition.value,
            });
        }
        if (resource.resource) {
            this.resources.push(resource.resource);
        }
        if (resource.construct) {
            core_1.Aspects.of(resource.construct).add(this.backupableResourcesCollector);
            // Cannot push `this.backupableResourcesCollector.resources` to
            // `this.resources` here because it has not been evaluated yet.
            // Will be concatenated to `this.resources` in a `Lazy.listValue`
            // in the constructor instead.
        }
    }
}
exports.BackupSelection = BackupSelection;
//# sourceMappingURL=data:application/json;base64,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