import * as dynamodb from "../../aws-dynamodb";
import * as ec2 from "../../aws-ec2";
import * as efs from "../../aws-efs";
import * as rds from "../../aws-rds";
import { Construct } from 'constructs';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) An operation that is applied to a key-value pair.
 *
 * @experimental
 */
export declare enum TagOperation {
    /**
     * (experimental) StringEquals.
     *
     * @experimental
     */
    STRING_EQUALS = "STRINGEQUALS",
    /**
     * (experimental) Dummy member.
     *
     * @experimental
     */
    DUMMY = "dummy"
}
/**
 * (experimental) A tag condition.
 *
 * @experimental
 */
export interface TagCondition {
    /**
     * (experimental) The key in a key-value pair.
     *
     * For example, in `"ec2:ResourceTag/Department": "accounting"`,
     * `ec2:ResourceTag/Department` is the key.
     *
     * @experimental
     */
    readonly key: string;
    /**
     * (experimental) An operation that is applied to a key-value pair used to filter resources in a selection.
     *
     * @default STRING_EQUALS
     * @experimental
     */
    readonly operation?: TagOperation;
    /**
     * (experimental) The value in a key-value pair.
     *
     * For example, in `"ec2:ResourceTag/Department": "accounting"`,
     * `accounting` is the value.
     *
     * @experimental
     */
    readonly value: string;
}
/**
 * (experimental) A resource to backup.
 *
 * @experimental
 */
export declare class BackupResource {
    /**
     * (experimental) Adds all supported resources in a construct.
     *
     * @param construct The construct containing resources to backup.
     * @experimental
     */
    static fromConstruct(construct: Construct): BackupResource;
    /**
     * (experimental) A DynamoDB table.
     *
     * @experimental
     */
    static fromDynamoDbTable(table: dynamodb.ITable): BackupResource;
    /**
     * (experimental) An EC2 instance.
     *
     * @experimental
     */
    static fromEc2Instance(instance: ec2.IInstance): BackupResource;
    /**
     * (experimental) An EFS file system.
     *
     * @experimental
     */
    static fromEfsFileSystem(fileSystem: efs.IFileSystem): BackupResource;
    /**
     * (experimental) A RDS database instance.
     *
     * @experimental
     */
    static fromRdsDatabaseInstance(instance: rds.IDatabaseInstance): BackupResource;
    /**
     * (experimental) A list of ARNs or match patterns such as `arn:aws:ec2:us-east-1:123456789012:volume/*`.
     *
     * @experimental
     */
    static fromArn(arn: string): BackupResource;
    /**
     * (experimental) A tag condition.
     *
     * @experimental
     */
    static fromTag(key: string, value: string, operation?: TagOperation): BackupResource;
    /**
     * (experimental) A resource.
     *
     * @experimental
     */
    readonly resource?: string;
    /**
     * (experimental) A condition on a tag.
     *
     * @experimental
     */
    readonly tagCondition?: TagCondition;
    /**
     * (experimental) A construct.
     *
     * @experimental
     */
    readonly construct?: CoreConstruct;
    /**
     * @experimental
     */
    constructor(resource?: string, tagCondition?: TagCondition, construct?: Construct);
}
