"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.BackupPlan = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const backup_generated_1 = require("./backup.generated");
const rule_1 = require("./rule");
const selection_1 = require("./selection");
const vault_1 = require("./vault");
/**
 * (experimental) A backup plan.
 *
 * @experimental
 */
class BackupPlan extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props = {}) {
        super(scope, id);
        this.rules = [];
        const plan = new backup_generated_1.CfnBackupPlan(this, 'Resource', {
            backupPlan: {
                backupPlanName: props.backupPlanName || id,
                backupPlanRule: core_1.Lazy.anyValue({ produce: () => this.rules }, { omitEmptyArray: true }),
            },
        });
        this.backupPlanId = plan.attrBackupPlanId;
        this.backupPlanArn = plan.attrBackupPlanArn;
        this.versionId = plan.attrVersionId;
        this._backupVault = props.backupVault;
        for (const rule of props.backupPlanRules || []) {
            this.addRule(rule);
        }
    }
    /**
     * (experimental) Import an existing backup plan.
     *
     * @experimental
     */
    static fromBackupPlanId(scope, id, backupPlanId) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.backupPlanId = backupPlanId;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) Daily with 35 day retention.
     *
     * @experimental
     */
    static daily35DayRetention(scope, id, backupVault) {
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        return plan;
    }
    /**
     * (experimental) Daily and monthly with 1 year retention.
     *
     * @experimental
     */
    static dailyMonthly1YearRetention(scope, id, backupVault) {
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.monthly1Year());
        return plan;
    }
    /**
     * (experimental) Daily, weekly and monthly with 5 year retention.
     *
     * @experimental
     */
    static dailyWeeklyMonthly5YearRetention(scope, id, backupVault) {
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.weekly());
        plan.addRule(rule_1.BackupPlanRule.monthly5Year());
        return plan;
    }
    /**
     * (experimental) Daily, weekly and monthly with 7 year retention.
     *
     * @experimental
     */
    static dailyWeeklyMonthly7YearRetention(scope, id, backupVault) {
        const plan = new BackupPlan(scope, id, { backupVault });
        plan.addRule(rule_1.BackupPlanRule.daily());
        plan.addRule(rule_1.BackupPlanRule.weekly());
        plan.addRule(rule_1.BackupPlanRule.monthly7Year());
        return plan;
    }
    /**
     * (experimental) Adds a rule to a plan.
     *
     * @param rule the rule to add.
     * @experimental
     */
    addRule(rule) {
        var _a, _b, _c, _d, _e, _f;
        let vault;
        if (rule.props.backupVault) {
            vault = rule.props.backupVault;
        }
        else if (this._backupVault) {
            vault = this._backupVault;
        }
        else {
            this._backupVault = new vault_1.BackupVault(this, 'Vault');
            vault = this._backupVault;
        }
        this.rules.push({
            completionWindowMinutes: (_a = rule.props.completionWindow) === null || _a === void 0 ? void 0 : _a.toMinutes(),
            lifecycle: (rule.props.deleteAfter || rule.props.moveToColdStorageAfter) && {
                deleteAfterDays: (_b = rule.props.deleteAfter) === null || _b === void 0 ? void 0 : _b.toDays(),
                moveToColdStorageAfterDays: (_c = rule.props.moveToColdStorageAfter) === null || _c === void 0 ? void 0 : _c.toDays(),
            },
            ruleName: (_d = rule.props.ruleName) !== null && _d !== void 0 ? _d : `${this.node.id}Rule${this.rules.length}`,
            scheduleExpression: (_e = rule.props.scheduleExpression) === null || _e === void 0 ? void 0 : _e.expressionString,
            startWindowMinutes: (_f = rule.props.startWindow) === null || _f === void 0 ? void 0 : _f.toMinutes(),
            targetBackupVault: vault.backupVaultName,
        });
    }
    /**
     * (experimental) The backup vault where backups are stored if not defined at the rule level.
     *
     * @experimental
     */
    get backupVault() {
        if (!this._backupVault) {
            // This cannot happen but is here to make TypeScript happy
            throw new Error('No backup vault!');
        }
        return this._backupVault;
    }
    /**
     * (experimental) Adds a selection to this plan.
     *
     * @experimental
     */
    addSelection(id, options) {
        return new selection_1.BackupSelection(this, id, {
            backupPlan: this,
            ...options,
        });
    }
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    validate() {
        if (this.rules.length === 0) {
            return ['A backup plan must have at least 1 rule.'];
        }
        return [];
    }
}
exports.BackupPlan = BackupPlan;
//# sourceMappingURL=data:application/json;base64,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