import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { BackupPlanRule } from './rule';
import { BackupSelection, BackupSelectionOptions } from './selection';
import { IBackupVault } from './vault';
/**
 * (experimental) A backup plan.
 *
 * @experimental
 */
export interface IBackupPlan extends IResource {
    /**
     * (experimental) The identifier of the backup plan.
     *
     * @experimental
     * @attribute true
     */
    readonly backupPlanId: string;
}
/**
 * (experimental) Properties for a BackupPlan.
 *
 * @experimental
 */
export interface BackupPlanProps {
    /**
     * (experimental) The display name of the backup plan.
     *
     * @default - A CDK generated name
     * @experimental
     */
    readonly backupPlanName?: string;
    /**
     * (experimental) The backup vault where backups are stored.
     *
     * @default - use the vault defined at the rule level. If not defined a new
     * common vault for the plan will be created
     * @experimental
     */
    readonly backupVault?: IBackupVault;
    /**
     * (experimental) Rules for the backup plan.
     *
     * Use `addRule()` to add rules after
     * instantiation.
     *
     * @default - use `addRule()` to add rules
     * @experimental
     */
    readonly backupPlanRules?: BackupPlanRule[];
}
/**
 * (experimental) A backup plan.
 *
 * @experimental
 */
export declare class BackupPlan extends Resource implements IBackupPlan {
    /**
     * (experimental) Import an existing backup plan.
     *
     * @experimental
     */
    static fromBackupPlanId(scope: Construct, id: string, backupPlanId: string): IBackupPlan;
    /**
     * (experimental) Daily with 35 day retention.
     *
     * @experimental
     */
    static daily35DayRetention(scope: Construct, id: string, backupVault?: IBackupVault): BackupPlan;
    /**
     * (experimental) Daily and monthly with 1 year retention.
     *
     * @experimental
     */
    static dailyMonthly1YearRetention(scope: Construct, id: string, backupVault?: IBackupVault): BackupPlan;
    /**
     * (experimental) Daily, weekly and monthly with 5 year retention.
     *
     * @experimental
     */
    static dailyWeeklyMonthly5YearRetention(scope: Construct, id: string, backupVault?: IBackupVault): BackupPlan;
    /**
     * (experimental) Daily, weekly and monthly with 7 year retention.
     *
     * @experimental
     */
    static dailyWeeklyMonthly7YearRetention(scope: Construct, id: string, backupVault?: IBackupVault): BackupPlan;
    /**
     * (experimental) The identifier of the backup plan.
     *
     * @experimental
     */
    readonly backupPlanId: string;
    /**
     * (experimental) The ARN of the backup plan.
     *
     * @experimental
     * @attribute true
     */
    readonly backupPlanArn: string;
    /**
     * (experimental) Version Id.
     *
     * @experimental
     * @attribute true
     */
    readonly versionId: string;
    private readonly rules;
    private _backupVault?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: BackupPlanProps);
    /**
     * (experimental) Adds a rule to a plan.
     *
     * @param rule the rule to add.
     * @experimental
     */
    addRule(rule: BackupPlanRule): void;
    /**
     * (experimental) The backup vault where backups are stored if not defined at the rule level.
     *
     * @experimental
     */
    get backupVault(): IBackupVault;
    /**
     * (experimental) Adds a selection to this plan.
     *
     * @experimental
     */
    addSelection(id: string, options: BackupSelectionOptions): BackupSelection;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
}
