"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LifecycleTransition = exports.DefaultResult = exports.LifecycleHook = void 0;
const iam = require("../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const autoscaling_generated_1 = require("./autoscaling.generated");
/**
 * (experimental) Define a life cycle hook.
 *
 * @experimental
 */
class LifecycleHook extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.lifecycleHookName,
        });
        this.role = props.role || new iam.Role(this, 'Role', {
            assumedBy: new iam.ServicePrincipal('autoscaling.amazonaws.com'),
        });
        const targetProps = props.notificationTarget.bind(this, this);
        const resource = new autoscaling_generated_1.CfnLifecycleHook(this, 'Resource', {
            autoScalingGroupName: props.autoScalingGroup.autoScalingGroupName,
            defaultResult: props.defaultResult,
            heartbeatTimeout: props.heartbeatTimeout && props.heartbeatTimeout.toSeconds(),
            lifecycleHookName: this.physicalName,
            lifecycleTransition: props.lifecycleTransition,
            notificationMetadata: props.notificationMetadata,
            notificationTargetArn: targetProps.notificationTargetArn,
            roleArn: this.role.roleArn,
        });
        // A LifecycleHook resource is going to do a permissions test upon creation,
        // so we have to make sure the role has full permissions before creating the
        // lifecycle hook.
        resource.node.addDependency(this.role);
        this.lifecycleHookName = resource.ref;
    }
}
exports.LifecycleHook = LifecycleHook;
/**
 * @experimental
 */
var DefaultResult;
(function (DefaultResult) {
    DefaultResult["CONTINUE"] = "CONTINUE";
    DefaultResult["ABANDON"] = "ABANDON";
})(DefaultResult = exports.DefaultResult || (exports.DefaultResult = {}));
/**
 * (experimental) What instance transition to attach the hook to.
 *
 * @experimental
 */
var LifecycleTransition;
(function (LifecycleTransition) {
    LifecycleTransition["INSTANCE_LAUNCHING"] = "autoscaling:EC2_INSTANCE_LAUNCHING";
    LifecycleTransition["INSTANCE_TERMINATING"] = "autoscaling:EC2_INSTANCE_TERMINATING";
})(LifecycleTransition = exports.LifecycleTransition || (exports.LifecycleTransition = {}));
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibGlmZWN5Y2xlLWhvb2suanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJsaWZlY3ljbGUtaG9vay50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7QUFBQSxxQ0FBcUMsQ0FBQyxtREFBbUQ7QUFDekYscUNBQTJELENBQUMsZ0RBQWdEO0FBRzVHLG1FQUEyRDs7Ozs7O0FBb0UzRCxNQUFhLGFBQWMsU0FBUSxlQUFROzs7O0lBVXZDLFlBQVksS0FBZ0IsRUFBRSxFQUFVLEVBQUUsS0FBeUI7UUFDL0QsS0FBSyxDQUFDLEtBQUssRUFBRSxFQUFFLEVBQUU7WUFDYixZQUFZLEVBQUUsS0FBSyxDQUFDLGlCQUFpQjtTQUN4QyxDQUFDLENBQUM7UUFDSCxJQUFJLENBQUMsSUFBSSxHQUFHLEtBQUssQ0FBQyxJQUFJLElBQUksSUFBSSxHQUFHLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxNQUFNLEVBQUU7WUFDakQsU0FBUyxFQUFFLElBQUksR0FBRyxDQUFDLGdCQUFnQixDQUFDLDJCQUEyQixDQUFDO1NBQ25FLENBQUMsQ0FBQztRQUNILE1BQU0sV0FBVyxHQUFHLEtBQUssQ0FBQyxrQkFBa0IsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDO1FBQzlELE1BQU0sUUFBUSxHQUFHLElBQUksd0NBQWdCLENBQUMsSUFBSSxFQUFFLFVBQVUsRUFBRTtZQUNwRCxvQkFBb0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLENBQUMsb0JBQW9CO1lBQ2pFLGFBQWEsRUFBRSxLQUFLLENBQUMsYUFBYTtZQUNsQyxnQkFBZ0IsRUFBRSxLQUFLLENBQUMsZ0JBQWdCLElBQUksS0FBSyxDQUFDLGdCQUFnQixDQUFDLFNBQVMsRUFBRTtZQUM5RSxpQkFBaUIsRUFBRSxJQUFJLENBQUMsWUFBWTtZQUNwQyxtQkFBbUIsRUFBRSxLQUFLLENBQUMsbUJBQW1CO1lBQzlDLG9CQUFvQixFQUFFLEtBQUssQ0FBQyxvQkFBb0I7WUFDaEQscUJBQXFCLEVBQUUsV0FBVyxDQUFDLHFCQUFxQjtZQUN4RCxPQUFPLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPO1NBQzdCLENBQUMsQ0FBQztRQUNILDRFQUE0RTtRQUM1RSw0RUFBNEU7UUFDNUUsa0JBQWtCO1FBQ2xCLFFBQVEsQ0FBQyxJQUFJLENBQUMsYUFBYSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsQ0FBQztRQUN2QyxJQUFJLENBQUMsaUJBQWlCLEdBQUcsUUFBUSxDQUFDLEdBQUcsQ0FBQztJQUMxQyxDQUFDO0NBQ0o7QUFsQ0Qsc0NBa0NDOzs7O0FBQ0QsSUFBWSxhQUdYO0FBSEQsV0FBWSxhQUFhO0lBQ3JCLHNDQUFxQixDQUFBO0lBQ3JCLG9DQUFtQixDQUFBO0FBQ3ZCLENBQUMsRUFIVyxhQUFhLEdBQWIscUJBQWEsS0FBYixxQkFBYSxRQUd4Qjs7Ozs7O0FBSUQsSUFBWSxtQkFTWDtBQVRELFdBQVksbUJBQW1CO0lBSTNCLGdGQUF5RCxDQUFBO0lBSXpELG9GQUE2RCxDQUFBO0FBQ2pFLENBQUMsRUFUVyxtQkFBbUIsR0FBbkIsMkJBQW1CLEtBQW5CLDJCQUFtQixRQVM5QiIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCAqIGFzIGlhbSBmcm9tIFwiLi4vLi4vYXdzLWlhbVwiOyAvLyBBdXRvbWF0aWNhbGx5IHJlLXdyaXR0ZW4gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSdcbmltcG9ydCB7IER1cmF0aW9uLCBJUmVzb3VyY2UsIFJlc291cmNlIH0gZnJvbSBcIi4uLy4uL2NvcmVcIjsgLy8gQXV0b21hdGljYWxseSByZS13cml0dGVuIGZyb20gJ0Bhd3MtY2RrL2NvcmUnXG5pbXBvcnQgeyBDb25zdHJ1Y3QgfSBmcm9tICdjb25zdHJ1Y3RzJztcbmltcG9ydCB7IElBdXRvU2NhbGluZ0dyb3VwIH0gZnJvbSAnLi9hdXRvLXNjYWxpbmctZ3JvdXAnO1xuaW1wb3J0IHsgQ2ZuTGlmZWN5Y2xlSG9vayB9IGZyb20gJy4vYXV0b3NjYWxpbmcuZ2VuZXJhdGVkJztcbmltcG9ydCB7IElMaWZlY3ljbGVIb29rVGFyZ2V0IH0gZnJvbSAnLi9saWZlY3ljbGUtaG9vay10YXJnZXQnO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgaW50ZXJmYWNlIEJhc2ljTGlmZWN5Y2xlSG9va1Byb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgbGlmZWN5Y2xlSG9va05hbWU/OiBzdHJpbmc7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGRlZmF1bHRSZXN1bHQ/OiBEZWZhdWx0UmVzdWx0O1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBoZWFydGJlYXRUaW1lb3V0PzogRHVyYXRpb247XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IGxpZmVjeWNsZVRyYW5zaXRpb246IExpZmVjeWNsZVRyYW5zaXRpb247XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IG5vdGlmaWNhdGlvbk1ldGFkYXRhPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHJlYWRvbmx5IG5vdGlmaWNhdGlvblRhcmdldDogSUxpZmVjeWNsZUhvb2tUYXJnZXQ7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcmVhZG9ubHkgcm9sZT86IGlhbS5JUm9sZTtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBMaWZlY3ljbGVIb29rUHJvcHMgZXh0ZW5kcyBCYXNpY0xpZmVjeWNsZUhvb2tQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSBhdXRvU2NhbGluZ0dyb3VwOiBJQXV0b1NjYWxpbmdHcm91cDtcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgSUxpZmVjeWNsZUhvb2sgZXh0ZW5kcyBJUmVzb3VyY2Uge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICByZWFkb25seSByb2xlOiBpYW0uSVJvbGU7XG59XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIExpZmVjeWNsZUhvb2sgZXh0ZW5kcyBSZXNvdXJjZSBpbXBsZW1lbnRzIElMaWZlY3ljbGVIb29rIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gICAgcHVibGljIHJlYWRvbmx5IHJvbGU6IGlhbS5JUm9sZTtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIHB1YmxpYyByZWFkb25seSBsaWZlY3ljbGVIb29rTmFtZTogc3RyaW5nO1xuICAgIGNvbnN0cnVjdG9yKHNjb3BlOiBDb25zdHJ1Y3QsIGlkOiBzdHJpbmcsIHByb3BzOiBMaWZlY3ljbGVIb29rUHJvcHMpIHtcbiAgICAgICAgc3VwZXIoc2NvcGUsIGlkLCB7XG4gICAgICAgICAgICBwaHlzaWNhbE5hbWU6IHByb3BzLmxpZmVjeWNsZUhvb2tOYW1lLFxuICAgICAgICB9KTtcbiAgICAgICAgdGhpcy5yb2xlID0gcHJvcHMucm9sZSB8fCBuZXcgaWFtLlJvbGUodGhpcywgJ1JvbGUnLCB7XG4gICAgICAgICAgICBhc3N1bWVkQnk6IG5ldyBpYW0uU2VydmljZVByaW5jaXBhbCgnYXV0b3NjYWxpbmcuYW1hem9uYXdzLmNvbScpLFxuICAgICAgICB9KTtcbiAgICAgICAgY29uc3QgdGFyZ2V0UHJvcHMgPSBwcm9wcy5ub3RpZmljYXRpb25UYXJnZXQuYmluZCh0aGlzLCB0aGlzKTtcbiAgICAgICAgY29uc3QgcmVzb3VyY2UgPSBuZXcgQ2ZuTGlmZWN5Y2xlSG9vayh0aGlzLCAnUmVzb3VyY2UnLCB7XG4gICAgICAgICAgICBhdXRvU2NhbGluZ0dyb3VwTmFtZTogcHJvcHMuYXV0b1NjYWxpbmdHcm91cC5hdXRvU2NhbGluZ0dyb3VwTmFtZSxcbiAgICAgICAgICAgIGRlZmF1bHRSZXN1bHQ6IHByb3BzLmRlZmF1bHRSZXN1bHQsXG4gICAgICAgICAgICBoZWFydGJlYXRUaW1lb3V0OiBwcm9wcy5oZWFydGJlYXRUaW1lb3V0ICYmIHByb3BzLmhlYXJ0YmVhdFRpbWVvdXQudG9TZWNvbmRzKCksXG4gICAgICAgICAgICBsaWZlY3ljbGVIb29rTmFtZTogdGhpcy5waHlzaWNhbE5hbWUsXG4gICAgICAgICAgICBsaWZlY3ljbGVUcmFuc2l0aW9uOiBwcm9wcy5saWZlY3ljbGVUcmFuc2l0aW9uLFxuICAgICAgICAgICAgbm90aWZpY2F0aW9uTWV0YWRhdGE6IHByb3BzLm5vdGlmaWNhdGlvbk1ldGFkYXRhLFxuICAgICAgICAgICAgbm90aWZpY2F0aW9uVGFyZ2V0QXJuOiB0YXJnZXRQcm9wcy5ub3RpZmljYXRpb25UYXJnZXRBcm4sXG4gICAgICAgICAgICByb2xlQXJuOiB0aGlzLnJvbGUucm9sZUFybixcbiAgICAgICAgfSk7XG4gICAgICAgIC8vIEEgTGlmZWN5Y2xlSG9vayByZXNvdXJjZSBpcyBnb2luZyB0byBkbyBhIHBlcm1pc3Npb25zIHRlc3QgdXBvbiBjcmVhdGlvbixcbiAgICAgICAgLy8gc28gd2UgaGF2ZSB0byBtYWtlIHN1cmUgdGhlIHJvbGUgaGFzIGZ1bGwgcGVybWlzc2lvbnMgYmVmb3JlIGNyZWF0aW5nIHRoZVxuICAgICAgICAvLyBsaWZlY3ljbGUgaG9vay5cbiAgICAgICAgcmVzb3VyY2Uubm9kZS5hZGREZXBlbmRlbmN5KHRoaXMucm9sZSk7XG4gICAgICAgIHRoaXMubGlmZWN5Y2xlSG9va05hbWUgPSByZXNvdXJjZS5yZWY7XG4gICAgfVxufVxuZXhwb3J0IGVudW0gRGVmYXVsdFJlc3VsdCB7XG4gICAgQ09OVElOVUUgPSAnQ09OVElOVUUnLFxuICAgIEFCQU5ET04gPSAnQUJBTkRPTidcbn1cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gTGlmZWN5Y2xlVHJhbnNpdGlvbiB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICAgIElOU1RBTkNFX0xBVU5DSElORyA9ICdhdXRvc2NhbGluZzpFQzJfSU5TVEFOQ0VfTEFVTkNISU5HJyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgICBJTlNUQU5DRV9URVJNSU5BVElORyA9ICdhdXRvc2NhbGluZzpFQzJfSU5TVEFOQ0VfVEVSTUlOQVRJTkcnXG59XG4iXX0=