"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.FunctionHook = void 0;
const sns = require("../../aws-sns"); // Automatically re-written from '@aws-cdk/aws-sns'
const subs = require("../../aws-sns-subscriptions"); // Automatically re-written from '@aws-cdk/aws-sns-subscriptions'
const topic_hook_1 = require("./topic-hook");
/**
 * (experimental) Use a Lambda Function as a hook target.
 *
 * Internally creates a Topic to make the connection.
 *
 * @experimental
 */
class FunctionHook {
    /**
     * @param fn Function to invoke in response to a lifecycle event.
     * @param encryptionKey If provided, this key is used to encrypt the contents of the SNS topic.
     * @experimental
     */
    constructor(fn, encryptionKey) {
        this.fn = fn;
        this.encryptionKey = encryptionKey;
    }
    /**
     * (experimental) Called when this object is used as the target of a lifecycle hook.
     *
     * @experimental
     */
    bind(scope, lifecycleHook) {
        var _a;
        const topic = new sns.Topic(scope, 'Topic', {
            masterKey: this.encryptionKey,
        });
        // Per: https://docs.aws.amazon.com/sns/latest/dg/sns-key-management.html#sns-what-permissions-for-sse
        // Topic's grantPublish() is in a base class that does not know there is a kms key, and so does not
        // grant appropriate permissions to the kms key. We do that here to ensure the correct permissions
        // are in place.
        (_a = this.encryptionKey) === null || _a === void 0 ? void 0 : _a.grant(lifecycleHook.role, 'kms:Decrypt', 'kms:GenerateDataKey');
        topic.addSubscription(new subs.LambdaSubscription(this.fn));
        return new topic_hook_1.TopicHook(topic).bind(scope, lifecycleHook);
    }
}
exports.FunctionHook = FunctionHook;
//# sourceMappingURL=data:application/json;base64,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