import { AuthorizationType } from './graphqlapi';
import { Resolver } from './resolver';
import { Directive, IField, IIntermediateType, AddFieldOptions } from './schema-base';
import { BaseTypeOptions, GraphqlType, ResolvableFieldOptions } from './schema-field';
/**
 * (experimental) Properties for configuring an Intermediate Type.
 *
 * @experimental
 */
export interface IntermediateTypeOptions {
    /**
     * (experimental) the attributes of this type.
     *
     * @experimental
     */
    readonly definition: {
        [key: string]: IField;
    };
    /**
     * (experimental) the directives for this object type.
     *
     * @default - no directives
     * @experimental
     */
    readonly directives?: Directive[];
}
/**
 * (experimental) Interface Types are abstract types that includes a certain set of fields that other types must include if they implement the interface.
 *
 * @experimental
 */
export declare class InterfaceType implements IIntermediateType {
    /**
     * (experimental) the name of this type.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) the attributes of this type.
     *
     * @experimental
     */
    readonly definition: {
        [key: string]: IField;
    };
    /**
     * (experimental) the directives for this object type.
     *
     * @default - no directives
     * @experimental
     */
    readonly directives?: Directive[];
    /**
     * (experimental) the authorization modes for this intermediate type.
     *
     * @experimental
     */
    protected modes?: AuthorizationType[];
    /**
     * @experimental
     */
    constructor(name: string, props: IntermediateTypeOptions);
    /**
     * (experimental) Create a GraphQL Type representing this Intermediate Type.
     *
     * @param options the options to configure this attribute.
     * @experimental
     */
    attribute(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) Generate the string of this object type.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Add a field to this Interface Type.
     *
     * Interface Types must have both fieldName and field options.
     *
     * @param options the options to add a field.
     * @experimental
     */
    addField(options: AddFieldOptions): void;
}
/**
 * (experimental) Properties for configuring an Object Type.
 *
 * @experimental
 */
export interface ObjectTypeOptions extends IntermediateTypeOptions {
    /**
     * (experimental) The Interface Types this Object Type implements.
     *
     * @default - no interface types
     * @experimental
     */
    readonly interfaceTypes?: InterfaceType[];
}
/**
 * (experimental) Object Types are types declared by you.
 *
 * @experimental
 */
export declare class ObjectType extends InterfaceType implements IIntermediateType {
    /**
     * (experimental) The Interface Types this Object Type implements.
     *
     * @default - no interface types
     * @experimental
     */
    readonly interfaceTypes?: InterfaceType[];
    /**
     * (experimental) The resolvers linked to this data source.
     *
     * @experimental
     */
    resolvers?: Resolver[];
    /**
     * @experimental
     */
    constructor(name: string, props: ObjectTypeOptions);
    /**
     * (experimental) Add a field to this Object Type.
     *
     * Object Types must have both fieldName and field options.
     *
     * @param options the options to add a field.
     * @experimental
     */
    addField(options: AddFieldOptions): void;
    /**
     * (experimental) Generate the string of this object type.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Generate the resolvers linked to this Object Type.
     *
     * @experimental
     */
    protected generateResolver(fieldName: string, options?: ResolvableFieldOptions): void;
}
/**
 * (experimental) Input Types are abstract types that define complex objects.
 *
 * They are used in arguments to represent
 *
 * @experimental
 */
export declare class InputType implements IIntermediateType {
    /**
     * (experimental) the name of this type.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) the attributes of this type.
     *
     * @experimental
     */
    readonly definition: {
        [key: string]: IField;
    };
    /**
     * (experimental) the authorization modes for this intermediate type.
     *
     * @experimental
     */
    protected modes?: AuthorizationType[];
    /**
     * @experimental
     */
    constructor(name: string, props: IntermediateTypeOptions);
    /**
     * (experimental) Create a GraphQL Type representing this Input Type.
     *
     * @param options the options to configure this attribute.
     * @experimental
     */
    attribute(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) Generate the string of this input type.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Add a field to this Input Type.
     *
     * Input Types must have both fieldName and field options.
     *
     * @param options the options to add a field.
     * @experimental
     */
    addField(options: AddFieldOptions): void;
}
/**
 * (experimental) Properties for configuring an Union Type.
 *
 * @experimental
 */
export interface UnionTypeOptions {
    /**
     * (experimental) the object types for this union type.
     *
     * @experimental
     */
    readonly definition: IIntermediateType[];
}
/**
 * (experimental) Union Types are abstract types that are similar to Interface Types, but they cannot to specify any common fields between types.
 *
 * Note that fields of a union type need to be object types. In other words,
 * you can't create a union type out of interfaces, other unions, or inputs.
 *
 * @experimental
 */
export declare class UnionType implements IIntermediateType {
    /**
     * (experimental) the name of this type.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) the attributes of this type.
     *
     * @experimental
     */
    readonly definition: {
        [key: string]: IField;
    };
    /**
     * (experimental) the authorization modes supported by this intermediate type.
     *
     * @experimental
     */
    protected modes?: AuthorizationType[];
    /**
     * @experimental
     */
    constructor(name: string, options: UnionTypeOptions);
    /**
     * (experimental) Create a GraphQL Type representing this Union Type.
     *
     * @param options the options to configure this attribute.
     * @experimental
     */
    attribute(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) Generate the string of this Union type.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Add a field to this Union Type.
     *
     * Input Types must have field options and the IField must be an Object Type.
     *
     * @param options the options to add a field.
     * @experimental
     */
    addField(options: AddFieldOptions): void;
}
/**
 * (experimental) Properties for configuring an Enum Type.
 *
 * @experimental
 */
export interface EnumTypeOptions {
    /**
     * (experimental) the attributes of this type.
     *
     * @experimental
     */
    readonly definition: string[];
}
/**
 * (experimental) Enum Types are abstract types that includes a set of fields that represent the strings this type can create.
 *
 * @experimental
 */
export declare class EnumType implements IIntermediateType {
    /**
     * (experimental) the name of this type.
     *
     * @experimental
     */
    readonly name: string;
    /**
     * (experimental) the attributes of this type.
     *
     * @experimental
     */
    readonly definition: {
        [key: string]: IField;
    };
    /**
     * (experimental) the authorization modes for this intermediate type.
     *
     * @experimental
     */
    protected modes?: AuthorizationType[];
    /**
     * @experimental
     */
    constructor(name: string, options: EnumTypeOptions);
    /**
     * (experimental) Create an GraphQL Type representing this Enum Type.
     *
     * @experimental
     */
    attribute(options?: BaseTypeOptions): GraphqlType;
    /**
     * (experimental) Generate the string of this enum type.
     *
     * @experimental
     */
    toString(): string;
    /**
     * (experimental) Add a field to this Enum Type.
     *
     * To add a field to this Enum Type, you must only configure
     * addField with the fieldName options.
     *
     * @param options the options to add a field.
     * @experimental
     */
    addField(options: AddFieldOptions): void;
}
