import { Construct } from 'constructs';
import { BaseDataSource } from './data-source';
import { IGraphqlApi } from './graphqlapi-base';
import { MappingTemplate } from './mapping-template';
import { Construct as CoreConstruct } from "../../core";
/**
 * (experimental) Basic properties for an AppSync resolver.
 *
 * @experimental
 */
export interface BaseResolverProps {
    /**
     * (experimental) name of the GraphQL type this resolver is attached to.
     *
     * @experimental
     */
    readonly typeName: string;
    /**
     * (experimental) name of the GraphQL fiel din the given type this resolver is attached to.
     *
     * @experimental
     */
    readonly fieldName: string;
    /**
     * (experimental) configuration of the pipeline resolver.
     *
     * @default - no pipeline resolver configuration
     * An empty array | undefined sets resolver to be of kind, unit
     * @experimental
     */
    readonly pipelineConfig?: string[];
    /**
     * (experimental) The request mapping template for this resolver.
     *
     * @default - No mapping template
     * @experimental
     */
    readonly requestMappingTemplate?: MappingTemplate;
    /**
     * (experimental) The response mapping template for this resolver.
     *
     * @default - No mapping template
     * @experimental
     */
    readonly responseMappingTemplate?: MappingTemplate;
}
/**
 * (experimental) Additional properties for an AppSync resolver like GraphQL API reference and datasource.
 *
 * @experimental
 */
export interface ResolverProps extends BaseResolverProps {
    /**
     * (experimental) The API this resolver is attached to.
     *
     * @experimental
     */
    readonly api: IGraphqlApi;
    /**
     * (experimental) The data source this resolver is using.
     *
     * @default - No datasource
     * @experimental
     */
    readonly dataSource?: BaseDataSource;
}
/**
 * (experimental) An AppSync resolver.
 *
 * @experimental
 */
export declare class Resolver extends CoreConstruct {
    /**
     * (experimental) the ARN of the resolver.
     *
     * @experimental
     */
    readonly arn: string;
    private resolver;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ResolverProps);
}
