"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MappingTemplate = void 0;
const fs_1 = require("fs");
/**
 * (experimental) MappingTemplates for AppSync resolvers.
 *
 * @experimental
 */
class MappingTemplate {
    /**
     * (experimental) Create a mapping template from the given string.
     *
     * @experimental
     */
    static fromString(template) {
        return new StringMappingTemplate(template);
    }
    /**
     * (experimental) Create a mapping template from the given file.
     *
     * @experimental
     */
    static fromFile(fileName) {
        return new StringMappingTemplate(fs_1.readFileSync(fileName).toString('utf-8'));
    }
    /**
     * (experimental) Mapping template for a result list from DynamoDB.
     *
     * @experimental
     */
    static dynamoDbResultList() {
        return this.fromString('$util.toJson($ctx.result.items)');
    }
    /**
     * (experimental) Mapping template for a single result item from DynamoDB.
     *
     * @experimental
     */
    static dynamoDbResultItem() {
        return this.fromString('$util.toJson($ctx.result)');
    }
    /**
     * (experimental) Mapping template to scan a DynamoDB table to fetch all entries.
     *
     * @experimental
     */
    static dynamoDbScanTable() {
        return this.fromString('{"version" : "2017-02-28", "operation" : "Scan"}');
    }
    /**
     * (experimental) Mapping template to query a set of items from a DynamoDB table.
     *
     * @param cond the key condition for the query.
     * @experimental
     */
    static dynamoDbQuery(cond) {
        return this.fromString(`{"version" : "2017-02-28", "operation" : "Query", ${cond.renderTemplate()}}`);
    }
    /**
     * (experimental) Mapping template to get a single item from a DynamoDB table.
     *
     * @param keyName the name of the hash key field.
     * @param idArg the name of the Query argument.
     * @experimental
     */
    static dynamoDbGetItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "GetItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * (experimental) Mapping template to delete a single item from a DynamoDB table.
     *
     * @param keyName the name of the hash key field.
     * @param idArg the name of the Mutation argument.
     * @experimental
     */
    static dynamoDbDeleteItem(keyName, idArg) {
        return this.fromString(`{"version": "2017-02-28", "operation": "DeleteItem", "key": {"${keyName}": $util.dynamodb.toDynamoDBJson($ctx.args.${idArg})}}`);
    }
    /**
     * (experimental) Mapping template to save a single item to a DynamoDB table.
     *
     * @param key the assigment of Mutation values to the primary key.
     * @param values the assignment of Mutation values to the table attributes.
     * @experimental
     */
    static dynamoDbPutItem(key, values) {
        return this.fromString(`
      ${values.renderVariables()}
      {
        "version": "2017-02-28",
        "operation": "PutItem",
        ${key.renderTemplate()},
        ${values.renderTemplate()}
      }`);
    }
    /**
     * (experimental) Mapping template to invoke a Lambda function.
     *
     * @param payload the VTL template snippet of the payload to send to the lambda.
     * @experimental
     */
    static lambdaRequest(payload = '$util.toJson($ctx)') {
        return this.fromString(`{"version": "2017-02-28", "operation": "Invoke", "payload": ${payload}}`);
    }
    /**
     * (experimental) Mapping template to return the Lambda result to the caller.
     *
     * @experimental
     */
    static lambdaResult() {
        return this.fromString('$util.toJson($ctx.result)');
    }
}
exports.MappingTemplate = MappingTemplate;
class StringMappingTemplate extends MappingTemplate {
    constructor(template) {
        super();
        this.template = template;
    }
    renderTemplate() {
        return this.template;
    }
}
//# sourceMappingURL=data:application/json;base64,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