import { AttributeValues, KeyCondition, PrimaryKey } from './key';
/**
 * (experimental) MappingTemplates for AppSync resolvers.
 *
 * @experimental
 */
export declare abstract class MappingTemplate {
    /**
     * (experimental) Create a mapping template from the given string.
     *
     * @experimental
     */
    static fromString(template: string): MappingTemplate;
    /**
     * (experimental) Create a mapping template from the given file.
     *
     * @experimental
     */
    static fromFile(fileName: string): MappingTemplate;
    /**
     * (experimental) Mapping template for a result list from DynamoDB.
     *
     * @experimental
     */
    static dynamoDbResultList(): MappingTemplate;
    /**
     * (experimental) Mapping template for a single result item from DynamoDB.
     *
     * @experimental
     */
    static dynamoDbResultItem(): MappingTemplate;
    /**
     * (experimental) Mapping template to scan a DynamoDB table to fetch all entries.
     *
     * @experimental
     */
    static dynamoDbScanTable(): MappingTemplate;
    /**
     * (experimental) Mapping template to query a set of items from a DynamoDB table.
     *
     * @param cond the key condition for the query.
     * @experimental
     */
    static dynamoDbQuery(cond: KeyCondition): MappingTemplate;
    /**
     * (experimental) Mapping template to get a single item from a DynamoDB table.
     *
     * @param keyName the name of the hash key field.
     * @param idArg the name of the Query argument.
     * @experimental
     */
    static dynamoDbGetItem(keyName: string, idArg: string): MappingTemplate;
    /**
     * (experimental) Mapping template to delete a single item from a DynamoDB table.
     *
     * @param keyName the name of the hash key field.
     * @param idArg the name of the Mutation argument.
     * @experimental
     */
    static dynamoDbDeleteItem(keyName: string, idArg: string): MappingTemplate;
    /**
     * (experimental) Mapping template to save a single item to a DynamoDB table.
     *
     * @param key the assigment of Mutation values to the primary key.
     * @param values the assignment of Mutation values to the table attributes.
     * @experimental
     */
    static dynamoDbPutItem(key: PrimaryKey, values: AttributeValues): MappingTemplate;
    /**
     * (experimental) Mapping template to invoke a Lambda function.
     *
     * @param payload the VTL template snippet of the payload to send to the lambda.
     * @experimental
     */
    static lambdaRequest(payload?: string): MappingTemplate;
    /**
     * (experimental) Mapping template to return the Lambda result to the caller.
     *
     * @experimental
     */
    static lambdaResult(): MappingTemplate;
    /**
     * (experimental) this is called to render the mapping template to a VTL string.
     *
     * @experimental
     */
    abstract renderTemplate(): string;
}
