"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.GraphqlApiBase = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const data_source_1 = require("./data-source");
/**
 * (experimental) Base Class for GraphQL API.
 *
 * @experimental
 */
class GraphqlApiBase extends core_1.Resource {
    /**
     * (experimental) add a new dummy data source to this API.
     *
     * Useful for pipeline resolvers
     * and for backend changes that don't require a data source.
     *
     * @param id The data source's id.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addNoneDataSource(id, options) {
        return new data_source_1.NoneDataSource(this, id, {
            api: this,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * (experimental) add a new DynamoDB data source to this API.
     *
     * @param id The data source's id.
     * @param table The DynamoDB table backing this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addDynamoDbDataSource(id, table, options) {
        return new data_source_1.DynamoDbDataSource(this, id, {
            api: this,
            table,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * (experimental) add a new http data source to this API.
     *
     * @param id The data source's id.
     * @param endpoint The http endpoint.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addHttpDataSource(id, endpoint, options) {
        return new data_source_1.HttpDataSource(this, id, {
            api: this,
            endpoint,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
            authorizationConfig: options === null || options === void 0 ? void 0 : options.authorizationConfig,
        });
    }
    /**
     * (experimental) add a new Lambda data source to this API.
     *
     * @param id The data source's id.
     * @param lambdaFunction The Lambda function to call to interact with this data source.
     * @param options The optional configuration for this data source.
     * @experimental
     */
    addLambdaDataSource(id, lambdaFunction, options) {
        return new data_source_1.LambdaDataSource(this, id, {
            api: this,
            lambdaFunction,
            name: options === null || options === void 0 ? void 0 : options.name,
            description: options === null || options === void 0 ? void 0 : options.description,
        });
    }
    /**
     * (experimental) Add schema dependency if not imported.
     *
     * @param construct the dependee.
     * @experimental
     */
    addSchemaDependency(construct) {
        construct;
        return false;
    }
}
exports.GraphqlApiBase = GraphqlApiBase;
//# sourceMappingURL=data:application/json;base64,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