import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::AppStream::DirectoryConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html
 * @external
 */
export interface CfnDirectoryConfigProps {
    /**
     * `AWS::AppStream::DirectoryConfig.DirectoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-directoryname
     * @external
     */
    readonly directoryName: string;
    /**
     * `AWS::AppStream::DirectoryConfig.OrganizationalUnitDistinguishedNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-organizationalunitdistinguishednames
     * @external
     */
    readonly organizationalUnitDistinguishedNames: string[];
    /**
     * `AWS::AppStream::DirectoryConfig.ServiceAccountCredentials`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-serviceaccountcredentials
     * @external
     */
    readonly serviceAccountCredentials: CfnDirectoryConfig.ServiceAccountCredentialsProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::DirectoryConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html
 * @external
 * @cloudformationResource AWS::AppStream::DirectoryConfig
 */
export declare class CfnDirectoryConfig extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::DirectoryConfig";
    /**
     * `AWS::AppStream::DirectoryConfig.DirectoryName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-directoryname
     * @external
     */
    directoryName: string;
    /**
     * `AWS::AppStream::DirectoryConfig.OrganizationalUnitDistinguishedNames`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-organizationalunitdistinguishednames
     * @external
     */
    organizationalUnitDistinguishedNames: string[];
    /**
     * `AWS::AppStream::DirectoryConfig.ServiceAccountCredentials`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html#cfn-appstream-directoryconfig-serviceaccountcredentials
     * @external
     */
    serviceAccountCredentials: CfnDirectoryConfig.ServiceAccountCredentialsProperty | cdk.IResolvable;
    /**
     * Create a new `AWS::AppStream::DirectoryConfig`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDirectoryConfigProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppStream::DirectoryConfig`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-directoryconfig.html
 * @external
 * @cloudformationResource AWS::AppStream::DirectoryConfig
 */
export declare namespace CfnDirectoryConfig {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-directoryconfig-serviceaccountcredentials.html
     * @external
     */
    interface ServiceAccountCredentialsProperty {
        /**
         * `CfnDirectoryConfig.ServiceAccountCredentialsProperty.AccountName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-directoryconfig-serviceaccountcredentials.html#cfn-appstream-directoryconfig-serviceaccountcredentials-accountname
         * @external
         */
        readonly accountName: string;
        /**
         * `CfnDirectoryConfig.ServiceAccountCredentialsProperty.AccountPassword`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-directoryconfig-serviceaccountcredentials.html#cfn-appstream-directoryconfig-serviceaccountcredentials-accountpassword
         * @external
         */
        readonly accountPassword: string;
    }
}
/**
 * Properties for defining a `AWS::AppStream::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html
 * @external
 */
export interface CfnFleetProps {
    /**
     * `AWS::AppStream::Fleet.ComputeCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-computecapacity
     * @external
     */
    readonly computeCapacity: CfnFleet.ComputeCapacityProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::Fleet.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::AppStream::Fleet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppStream::Fleet.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppStream::Fleet.DisconnectTimeoutInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-disconnecttimeoutinseconds
     * @external
     */
    readonly disconnectTimeoutInSeconds?: number;
    /**
     * `AWS::AppStream::Fleet.DisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-displayname
     * @external
     */
    readonly displayName?: string;
    /**
     * `AWS::AppStream::Fleet.DomainJoinInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-domainjoininfo
     * @external
     */
    readonly domainJoinInfo?: CfnFleet.DomainJoinInfoProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::Fleet.EnableDefaultInternetAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-enabledefaultinternetaccess
     * @external
     */
    readonly enableDefaultInternetAccess?: boolean | cdk.IResolvable;
    /**
     * `AWS::AppStream::Fleet.FleetType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-fleettype
     * @external
     */
    readonly fleetType?: string;
    /**
     * `AWS::AppStream::Fleet.IamRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-iamrolearn
     * @external
     */
    readonly iamRoleArn?: string;
    /**
     * `AWS::AppStream::Fleet.IdleDisconnectTimeoutInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-idledisconnecttimeoutinseconds
     * @external
     */
    readonly idleDisconnectTimeoutInSeconds?: number;
    /**
     * `AWS::AppStream::Fleet.ImageArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagearn
     * @external
     */
    readonly imageArn?: string;
    /**
     * `AWS::AppStream::Fleet.ImageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagename
     * @external
     */
    readonly imageName?: string;
    /**
     * `AWS::AppStream::Fleet.MaxUserDurationInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxuserdurationinseconds
     * @external
     */
    readonly maxUserDurationInSeconds?: number;
    /**
     * `AWS::AppStream::Fleet.StreamView`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-streamview
     * @external
     */
    readonly streamView?: string;
    /**
     * `AWS::AppStream::Fleet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppStream::Fleet.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-vpcconfig
     * @external
     */
    readonly vpcConfig?: CfnFleet.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html
 * @external
 * @cloudformationResource AWS::AppStream::Fleet
 */
export declare class CfnFleet extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::Fleet";
    /**
     * `AWS::AppStream::Fleet.ComputeCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-computecapacity
     * @external
     */
    computeCapacity: CfnFleet.ComputeCapacityProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::Fleet.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::AppStream::Fleet.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppStream::Fleet.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppStream::Fleet.DisconnectTimeoutInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-disconnecttimeoutinseconds
     * @external
     */
    disconnectTimeoutInSeconds: number | undefined;
    /**
     * `AWS::AppStream::Fleet.DisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-displayname
     * @external
     */
    displayName: string | undefined;
    /**
     * `AWS::AppStream::Fleet.DomainJoinInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-domainjoininfo
     * @external
     */
    domainJoinInfo: CfnFleet.DomainJoinInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Fleet.EnableDefaultInternetAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-enabledefaultinternetaccess
     * @external
     */
    enableDefaultInternetAccess: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Fleet.FleetType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-fleettype
     * @external
     */
    fleetType: string | undefined;
    /**
     * `AWS::AppStream::Fleet.IamRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-iamrolearn
     * @external
     */
    iamRoleArn: string | undefined;
    /**
     * `AWS::AppStream::Fleet.IdleDisconnectTimeoutInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-idledisconnecttimeoutinseconds
     * @external
     */
    idleDisconnectTimeoutInSeconds: number | undefined;
    /**
     * `AWS::AppStream::Fleet.ImageArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagearn
     * @external
     */
    imageArn: string | undefined;
    /**
     * `AWS::AppStream::Fleet.ImageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-imagename
     * @external
     */
    imageName: string | undefined;
    /**
     * `AWS::AppStream::Fleet.MaxUserDurationInSeconds`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-maxuserdurationinseconds
     * @external
     */
    maxUserDurationInSeconds: number | undefined;
    /**
     * `AWS::AppStream::Fleet.StreamView`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-streamview
     * @external
     */
    streamView: string | undefined;
    /**
     * `AWS::AppStream::Fleet.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppStream::Fleet.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html#cfn-appstream-fleet-vpcconfig
     * @external
     */
    vpcConfig: CfnFleet.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppStream::Fleet`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnFleetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppStream::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html
 * @external
 * @cloudformationResource AWS::AppStream::Fleet
 */
export declare namespace CfnFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-computecapacity.html
     * @external
     */
    interface ComputeCapacityProperty {
        /**
         * `CfnFleet.ComputeCapacityProperty.DesiredInstances`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-computecapacity.html#cfn-appstream-fleet-computecapacity-desiredinstances
         * @external
         */
        readonly desiredInstances: number;
    }
}
/**
 * A CloudFormation `AWS::AppStream::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html
 * @external
 * @cloudformationResource AWS::AppStream::Fleet
 */
export declare namespace CfnFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-domainjoininfo.html
     * @external
     */
    interface DomainJoinInfoProperty {
        /**
         * `CfnFleet.DomainJoinInfoProperty.DirectoryName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-domainjoininfo.html#cfn-appstream-fleet-domainjoininfo-directoryname
         * @external
         */
        readonly directoryName?: string;
        /**
         * `CfnFleet.DomainJoinInfoProperty.OrganizationalUnitDistinguishedName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-domainjoininfo.html#cfn-appstream-fleet-domainjoininfo-organizationalunitdistinguishedname
         * @external
         */
        readonly organizationalUnitDistinguishedName?: string;
    }
}
/**
 * A CloudFormation `AWS::AppStream::Fleet`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-fleet.html
 * @external
 * @cloudformationResource AWS::AppStream::Fleet
 */
export declare namespace CfnFleet {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnFleet.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-vpcconfig.html#cfn-appstream-fleet-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnFleet.VpcConfigProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-fleet-vpcconfig.html#cfn-appstream-fleet-vpcconfig-subnetids
         * @external
         */
        readonly subnetIds?: string[];
    }
}
/**
 * Properties for defining a `AWS::AppStream::ImageBuilder`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html
 * @external
 */
export interface CfnImageBuilderProps {
    /**
     * `AWS::AppStream::ImageBuilder.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-instancetype
     * @external
     */
    readonly instanceType: string;
    /**
     * `AWS::AppStream::ImageBuilder.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppStream::ImageBuilder.AccessEndpoints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-accessendpoints
     * @external
     */
    readonly accessEndpoints?: Array<CfnImageBuilder.AccessEndpointProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppStream::ImageBuilder.AppstreamAgentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-appstreamagentversion
     * @external
     */
    readonly appstreamAgentVersion?: string;
    /**
     * `AWS::AppStream::ImageBuilder.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppStream::ImageBuilder.DisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-displayname
     * @external
     */
    readonly displayName?: string;
    /**
     * `AWS::AppStream::ImageBuilder.DomainJoinInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-domainjoininfo
     * @external
     */
    readonly domainJoinInfo?: CfnImageBuilder.DomainJoinInfoProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::ImageBuilder.EnableDefaultInternetAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-enabledefaultinternetaccess
     * @external
     */
    readonly enableDefaultInternetAccess?: boolean | cdk.IResolvable;
    /**
     * `AWS::AppStream::ImageBuilder.IamRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-iamrolearn
     * @external
     */
    readonly iamRoleArn?: string;
    /**
     * `AWS::AppStream::ImageBuilder.ImageArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-imagearn
     * @external
     */
    readonly imageArn?: string;
    /**
     * `AWS::AppStream::ImageBuilder.ImageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-imagename
     * @external
     */
    readonly imageName?: string;
    /**
     * `AWS::AppStream::ImageBuilder.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppStream::ImageBuilder.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-vpcconfig
     * @external
     */
    readonly vpcConfig?: CfnImageBuilder.VpcConfigProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::ImageBuilder`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html
 * @external
 * @cloudformationResource AWS::AppStream::ImageBuilder
 */
export declare class CfnImageBuilder extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::ImageBuilder";
    /**
     * @external
     * @cloudformationAttribute StreamingUrl
     */
    readonly attrStreamingUrl: string;
    /**
     * `AWS::AppStream::ImageBuilder.InstanceType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-instancetype
     * @external
     */
    instanceType: string;
    /**
     * `AWS::AppStream::ImageBuilder.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppStream::ImageBuilder.AccessEndpoints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-accessendpoints
     * @external
     */
    accessEndpoints: Array<CfnImageBuilder.AccessEndpointProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.AppstreamAgentVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-appstreamagentversion
     * @external
     */
    appstreamAgentVersion: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.DisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-displayname
     * @external
     */
    displayName: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.DomainJoinInfo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-domainjoininfo
     * @external
     */
    domainJoinInfo: CfnImageBuilder.DomainJoinInfoProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.EnableDefaultInternetAccess`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-enabledefaultinternetaccess
     * @external
     */
    enableDefaultInternetAccess: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.IamRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-iamrolearn
     * @external
     */
    iamRoleArn: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.ImageArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-imagearn
     * @external
     */
    imageArn: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.ImageName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-imagename
     * @external
     */
    imageName: string | undefined;
    /**
     * `AWS::AppStream::ImageBuilder.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppStream::ImageBuilder.VpcConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html#cfn-appstream-imagebuilder-vpcconfig
     * @external
     */
    vpcConfig: CfnImageBuilder.VpcConfigProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppStream::ImageBuilder`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnImageBuilderProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppStream::ImageBuilder`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html
 * @external
 * @cloudformationResource AWS::AppStream::ImageBuilder
 */
export declare namespace CfnImageBuilder {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-accessendpoint.html
     * @external
     */
    interface AccessEndpointProperty {
        /**
         * `CfnImageBuilder.AccessEndpointProperty.EndpointType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-accessendpoint.html#cfn-appstream-imagebuilder-accessendpoint-endpointtype
         * @external
         */
        readonly endpointType: string;
        /**
         * `CfnImageBuilder.AccessEndpointProperty.VpceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-accessendpoint.html#cfn-appstream-imagebuilder-accessendpoint-vpceid
         * @external
         */
        readonly vpceId: string;
    }
}
/**
 * A CloudFormation `AWS::AppStream::ImageBuilder`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html
 * @external
 * @cloudformationResource AWS::AppStream::ImageBuilder
 */
export declare namespace CfnImageBuilder {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-domainjoininfo.html
     * @external
     */
    interface DomainJoinInfoProperty {
        /**
         * `CfnImageBuilder.DomainJoinInfoProperty.DirectoryName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-domainjoininfo.html#cfn-appstream-imagebuilder-domainjoininfo-directoryname
         * @external
         */
        readonly directoryName?: string;
        /**
         * `CfnImageBuilder.DomainJoinInfoProperty.OrganizationalUnitDistinguishedName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-domainjoininfo.html#cfn-appstream-imagebuilder-domainjoininfo-organizationalunitdistinguishedname
         * @external
         */
        readonly organizationalUnitDistinguishedName?: string;
    }
}
/**
 * A CloudFormation `AWS::AppStream::ImageBuilder`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-imagebuilder.html
 * @external
 * @cloudformationResource AWS::AppStream::ImageBuilder
 */
export declare namespace CfnImageBuilder {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-vpcconfig.html
     * @external
     */
    interface VpcConfigProperty {
        /**
         * `CfnImageBuilder.VpcConfigProperty.SecurityGroupIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-vpcconfig.html#cfn-appstream-imagebuilder-vpcconfig-securitygroupids
         * @external
         */
        readonly securityGroupIds?: string[];
        /**
         * `CfnImageBuilder.VpcConfigProperty.SubnetIds`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-imagebuilder-vpcconfig.html#cfn-appstream-imagebuilder-vpcconfig-subnetids
         * @external
         */
        readonly subnetIds?: string[];
    }
}
/**
 * Properties for defining a `AWS::AppStream::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html
 * @external
 */
export interface CfnStackProps {
    /**
     * `AWS::AppStream::Stack.AccessEndpoints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-accessendpoints
     * @external
     */
    readonly accessEndpoints?: Array<CfnStack.AccessEndpointProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppStream::Stack.ApplicationSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-applicationsettings
     * @external
     */
    readonly applicationSettings?: CfnStack.ApplicationSettingsProperty | cdk.IResolvable;
    /**
     * `AWS::AppStream::Stack.AttributesToDelete`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-attributestodelete
     * @external
     */
    readonly attributesToDelete?: string[];
    /**
     * `AWS::AppStream::Stack.DeleteStorageConnectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-deletestorageconnectors
     * @external
     */
    readonly deleteStorageConnectors?: boolean | cdk.IResolvable;
    /**
     * `AWS::AppStream::Stack.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppStream::Stack.DisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-displayname
     * @external
     */
    readonly displayName?: string;
    /**
     * `AWS::AppStream::Stack.EmbedHostDomains`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-embedhostdomains
     * @external
     */
    readonly embedHostDomains?: string[];
    /**
     * `AWS::AppStream::Stack.FeedbackURL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-feedbackurl
     * @external
     */
    readonly feedbackUrl?: string;
    /**
     * `AWS::AppStream::Stack.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-name
     * @external
     */
    readonly name?: string;
    /**
     * `AWS::AppStream::Stack.RedirectURL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-redirecturl
     * @external
     */
    readonly redirectUrl?: string;
    /**
     * `AWS::AppStream::Stack.StorageConnectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-storageconnectors
     * @external
     */
    readonly storageConnectors?: Array<CfnStack.StorageConnectorProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppStream::Stack.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
    /**
     * `AWS::AppStream::Stack.UserSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-usersettings
     * @external
     */
    readonly userSettings?: Array<CfnStack.UserSettingProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html
 * @external
 * @cloudformationResource AWS::AppStream::Stack
 */
export declare class CfnStack extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::Stack";
    /**
     * `AWS::AppStream::Stack.AccessEndpoints`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-accessendpoints
     * @external
     */
    accessEndpoints: Array<CfnStack.AccessEndpointProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Stack.ApplicationSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-applicationsettings
     * @external
     */
    applicationSettings: CfnStack.ApplicationSettingsProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Stack.AttributesToDelete`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-attributestodelete
     * @external
     */
    attributesToDelete: string[] | undefined;
    /**
     * `AWS::AppStream::Stack.DeleteStorageConnectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-deletestorageconnectors
     * @external
     */
    deleteStorageConnectors: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Stack.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppStream::Stack.DisplayName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-displayname
     * @external
     */
    displayName: string | undefined;
    /**
     * `AWS::AppStream::Stack.EmbedHostDomains`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-embedhostdomains
     * @external
     */
    embedHostDomains: string[] | undefined;
    /**
     * `AWS::AppStream::Stack.FeedbackURL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-feedbackurl
     * @external
     */
    feedbackUrl: string | undefined;
    /**
     * `AWS::AppStream::Stack.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-name
     * @external
     */
    name: string | undefined;
    /**
     * `AWS::AppStream::Stack.RedirectURL`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-redirecturl
     * @external
     */
    redirectUrl: string | undefined;
    /**
     * `AWS::AppStream::Stack.StorageConnectors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-storageconnectors
     * @external
     */
    storageConnectors: Array<CfnStack.StorageConnectorProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AppStream::Stack.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * `AWS::AppStream::Stack.UserSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html#cfn-appstream-stack-usersettings
     * @external
     */
    userSettings: Array<CfnStack.UserSettingProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppStream::Stack`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props?: CfnStackProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppStream::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html
 * @external
 * @cloudformationResource AWS::AppStream::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-accessendpoint.html
     * @external
     */
    interface AccessEndpointProperty {
        /**
         * `CfnStack.AccessEndpointProperty.EndpointType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-accessendpoint.html#cfn-appstream-stack-accessendpoint-endpointtype
         * @external
         */
        readonly endpointType: string;
        /**
         * `CfnStack.AccessEndpointProperty.VpceId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-accessendpoint.html#cfn-appstream-stack-accessendpoint-vpceid
         * @external
         */
        readonly vpceId: string;
    }
}
/**
 * A CloudFormation `AWS::AppStream::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html
 * @external
 * @cloudformationResource AWS::AppStream::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-applicationsettings.html
     * @external
     */
    interface ApplicationSettingsProperty {
        /**
         * `CfnStack.ApplicationSettingsProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-applicationsettings.html#cfn-appstream-stack-applicationsettings-enabled
         * @external
         */
        readonly enabled: boolean | cdk.IResolvable;
        /**
         * `CfnStack.ApplicationSettingsProperty.SettingsGroup`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-applicationsettings.html#cfn-appstream-stack-applicationsettings-settingsgroup
         * @external
         */
        readonly settingsGroup?: string;
    }
}
/**
 * A CloudFormation `AWS::AppStream::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html
 * @external
 * @cloudformationResource AWS::AppStream::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-storageconnector.html
     * @external
     */
    interface StorageConnectorProperty {
        /**
         * `CfnStack.StorageConnectorProperty.ConnectorType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-storageconnector.html#cfn-appstream-stack-storageconnector-connectortype
         * @external
         */
        readonly connectorType: string;
        /**
         * `CfnStack.StorageConnectorProperty.Domains`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-storageconnector.html#cfn-appstream-stack-storageconnector-domains
         * @external
         */
        readonly domains?: string[];
        /**
         * `CfnStack.StorageConnectorProperty.ResourceIdentifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-storageconnector.html#cfn-appstream-stack-storageconnector-resourceidentifier
         * @external
         */
        readonly resourceIdentifier?: string;
    }
}
/**
 * A CloudFormation `AWS::AppStream::Stack`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stack.html
 * @external
 * @cloudformationResource AWS::AppStream::Stack
 */
export declare namespace CfnStack {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-usersetting.html
     * @external
     */
    interface UserSettingProperty {
        /**
         * `CfnStack.UserSettingProperty.Action`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-usersetting.html#cfn-appstream-stack-usersetting-action
         * @external
         */
        readonly action: string;
        /**
         * `CfnStack.UserSettingProperty.Permission`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appstream-stack-usersetting.html#cfn-appstream-stack-usersetting-permission
         * @external
         */
        readonly permission: string;
    }
}
/**
 * Properties for defining a `AWS::AppStream::StackFleetAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html
 * @external
 */
export interface CfnStackFleetAssociationProps {
    /**
     * `AWS::AppStream::StackFleetAssociation.FleetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html#cfn-appstream-stackfleetassociation-fleetname
     * @external
     */
    readonly fleetName: string;
    /**
     * `AWS::AppStream::StackFleetAssociation.StackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html#cfn-appstream-stackfleetassociation-stackname
     * @external
     */
    readonly stackName: string;
}
/**
 * A CloudFormation `AWS::AppStream::StackFleetAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html
 * @external
 * @cloudformationResource AWS::AppStream::StackFleetAssociation
 */
export declare class CfnStackFleetAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::StackFleetAssociation";
    /**
     * `AWS::AppStream::StackFleetAssociation.FleetName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html#cfn-appstream-stackfleetassociation-fleetname
     * @external
     */
    fleetName: string;
    /**
     * `AWS::AppStream::StackFleetAssociation.StackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackfleetassociation.html#cfn-appstream-stackfleetassociation-stackname
     * @external
     */
    stackName: string;
    /**
     * Create a new `AWS::AppStream::StackFleetAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackFleetAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AppStream::StackUserAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html
 * @external
 */
export interface CfnStackUserAssociationProps {
    /**
     * `AWS::AppStream::StackUserAssociation.AuthenticationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-authenticationtype
     * @external
     */
    readonly authenticationType: string;
    /**
     * `AWS::AppStream::StackUserAssociation.StackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-stackname
     * @external
     */
    readonly stackName: string;
    /**
     * `AWS::AppStream::StackUserAssociation.UserName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-username
     * @external
     */
    readonly userName: string;
    /**
     * `AWS::AppStream::StackUserAssociation.SendEmailNotification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-sendemailnotification
     * @external
     */
    readonly sendEmailNotification?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppStream::StackUserAssociation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html
 * @external
 * @cloudformationResource AWS::AppStream::StackUserAssociation
 */
export declare class CfnStackUserAssociation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::StackUserAssociation";
    /**
     * `AWS::AppStream::StackUserAssociation.AuthenticationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-authenticationtype
     * @external
     */
    authenticationType: string;
    /**
     * `AWS::AppStream::StackUserAssociation.StackName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-stackname
     * @external
     */
    stackName: string;
    /**
     * `AWS::AppStream::StackUserAssociation.UserName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-username
     * @external
     */
    userName: string;
    /**
     * `AWS::AppStream::StackUserAssociation.SendEmailNotification`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-stackuserassociation.html#cfn-appstream-stackuserassociation-sendemailnotification
     * @external
     */
    sendEmailNotification: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppStream::StackUserAssociation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnStackUserAssociationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * Properties for defining a `AWS::AppStream::User`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html
 * @external
 */
export interface CfnUserProps {
    /**
     * `AWS::AppStream::User.AuthenticationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-authenticationtype
     * @external
     */
    readonly authenticationType: string;
    /**
     * `AWS::AppStream::User.UserName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-username
     * @external
     */
    readonly userName: string;
    /**
     * `AWS::AppStream::User.FirstName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-firstname
     * @external
     */
    readonly firstName?: string;
    /**
     * `AWS::AppStream::User.LastName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-lastname
     * @external
     */
    readonly lastName?: string;
    /**
     * `AWS::AppStream::User.MessageAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-messageaction
     * @external
     */
    readonly messageAction?: string;
}
/**
 * A CloudFormation `AWS::AppStream::User`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html
 * @external
 * @cloudformationResource AWS::AppStream::User
 */
export declare class CfnUser extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppStream::User";
    /**
     * `AWS::AppStream::User.AuthenticationType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-authenticationtype
     * @external
     */
    authenticationType: string;
    /**
     * `AWS::AppStream::User.UserName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-username
     * @external
     */
    userName: string;
    /**
     * `AWS::AppStream::User.FirstName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-firstname
     * @external
     */
    firstName: string | undefined;
    /**
     * `AWS::AppStream::User.LastName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-lastname
     * @external
     */
    lastName: string | undefined;
    /**
     * `AWS::AppStream::User.MessageAction`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appstream-user.html#cfn-appstream-user-messageaction
     * @external
     */
    messageAction: string | undefined;
    /**
     * Create a new `AWS::AppStream::User`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnUserProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
