import * as cloudmap from "../../aws-servicediscovery";
import * as cdk from "../../core";
import { Construct } from 'constructs';
import { CfnVirtualNode } from './appmesh.generated';
import { IMesh } from './mesh';
import { AccessLog, VirtualNodeListener } from './shared-interfaces';
import { IVirtualService } from './virtual-service';
/**
 * (experimental) Interface which all VirtualNode based classes must implement.
 *
 * @experimental
 */
export interface IVirtualNode extends cdk.IResource {
    /**
     * (experimental) The name of the VirtualNode.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualNodeName: string;
    /**
     * (experimental) The Amazon Resource Name belonging to the VirtualNdoe.
     *
     * Set this value as the APPMESH_VIRTUAL_NODE_NAME environment variable for
     * your task group's Envoy proxy container in your task definition or pod
     * spec.
     *
     * @experimental
     * @attribute true
     */
    readonly virtualNodeArn: string;
    /**
     * (experimental) Utility method to add backends for existing or new VirtualNodes.
     *
     * @experimental
     */
    addBackends(...props: IVirtualService[]): void;
    /**
     * (experimental) Utility method to add Node Listeners for new or existing VirtualNodes.
     *
     * @experimental
     */
    addListeners(...listeners: VirtualNodeListener[]): void;
}
/**
 * (experimental) Basic configuration properties for a VirtualNode.
 *
 * @experimental
 */
export interface VirtualNodeBaseProps {
    /**
     * (experimental) The name of the VirtualNode.
     *
     * @default - A name is automatically determined
     * @experimental
     */
    readonly virtualNodeName?: string;
    /**
     * (experimental) Host name of DNS record used to discover Virtual Node members.
     *
     * The IP addresses returned by querying this DNS record will be considered
     * part of the Virtual Node.
     *
     * @default - Don't use DNS-based service discovery
     * @experimental
     */
    readonly dnsHostName?: string;
    /**
     * (experimental) CloudMap service where Virtual Node members register themselves.
     *
     * Instances registering themselves into this CloudMap will
     * be considered part of the Virtual Node.
     *
     * @default - Don't use CloudMap-based service discovery
     * @experimental
     */
    readonly cloudMapService?: cloudmap.IService;
    /**
     * (experimental) Filter down the list of CloudMap service instance.
     *
     * @default - No CloudMap instance filter
     * @experimental
     */
    readonly cloudMapServiceInstanceAttributes?: {
        [key: string]: string;
    };
    /**
     * (experimental) Virtual Services that this is node expected to send outbound traffic to.
     *
     * @default - No backends
     * @experimental
     */
    readonly backends?: IVirtualService[];
    /**
     * (experimental) Initial listener for the virtual node.
     *
     * @default - No listeners
     * @experimental
     */
    readonly listener?: VirtualNodeListener;
    /**
     * (experimental) Access Logging Configuration for the virtual node.
     *
     * @default - No access logging
     * @experimental
     */
    readonly accessLog?: AccessLog;
}
/**
 * (experimental) The properties used when creating a new VirtualNode.
 *
 * @experimental
 */
export interface VirtualNodeProps extends VirtualNodeBaseProps {
    /**
     * (experimental) The name of the AppMesh which the virtual node belongs to.
     *
     * @experimental
     */
    readonly mesh: IMesh;
}
declare abstract class VirtualNodeBase extends cdk.Resource implements IVirtualNode {
    /**
     * The name of the VirtualNode
     */
    abstract readonly virtualNodeName: string;
    /**
     * The Amazon Resource Name belonging to the VirtualNdoe
     */
    abstract readonly virtualNodeArn: string;
    /**
     * @experimental
     */
    protected readonly backends: CfnVirtualNode.BackendProperty[];
    /**
     * @experimental
     */
    protected readonly listeners: CfnVirtualNode.ListenerProperty[];
    /**
     * (experimental) Add a Virtual Services that this node is expected to send outbound traffic to.
     *
     * @experimental
     */
    addBackends(...props: IVirtualService[]): void;
    /**
     * (experimental) Utility method to add an inbound listener for this virtual node.
     *
     * @experimental
     */
    addListeners(...listeners: VirtualNodeListener[]): void;
}
/**
 * (experimental) VirtualNode represents a newly defined AppMesh VirtualNode.
 *
 * Any inbound traffic that your virtual node expects should be specified as a
 * listener. Any outbound traffic that your virtual node expects to reach
 * should be specified as a backend.
 *
 * @see https://docs.aws.amazon.com/app-mesh/latest/userguide/virtual_nodes.html
 * @experimental
 */
export declare class VirtualNode extends VirtualNodeBase {
    /**
     * (experimental) Import an existing VirtualNode given an ARN.
     *
     * @experimental
     */
    static fromVirtualNodeArn(scope: Construct, id: string, virtualNodeArn: string): IVirtualNode;
    /**
     * (experimental) Import an existing VirtualNode given its name.
     *
     * @experimental
     */
    static fromVirtualNodeName(scope: Construct, id: string, meshName: string, virtualNodeName: string): IVirtualNode;
    /**
     * (experimental) The name of the VirtualNode.
     *
     * @experimental
     */
    readonly virtualNodeName: string;
    /**
     * (experimental) The Amazon Resource Name belonging to the VirtualNdoe.
     *
     * @experimental
     */
    readonly virtualNodeArn: string;
    /**
     * (experimental) The service mesh that the virtual node resides in.
     *
     * @experimental
     */
    readonly mesh: IMesh;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: VirtualNodeProps);
}
export {};
