import * as iam from "../../aws-iam";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { Schedule } from './schedule';
import { BasicStepScalingPolicyProps, StepScalingPolicy } from './step-scaling-policy';
import { BasicTargetTrackingScalingPolicyProps, TargetTrackingScalingPolicy } from './target-tracking-scaling-policy';
/**
 * @experimental
 */
export interface IScalableTarget extends IResource {
    /**
     * @experimental
     * @attribute true
     */
    readonly scalableTargetId: string;
}
/**
 * (experimental) Properties for a scalable target.
 *
 * @experimental
 */
export interface ScalableTargetProps {
    /**
     * (experimental) The minimum value that Application Auto Scaling can use to scale a target during a scaling activity.
     *
     * @experimental
     */
    readonly minCapacity: number;
    /**
     * (experimental) The maximum value that Application Auto Scaling can use to scale a target during a scaling activity.
     *
     * @experimental
     */
    readonly maxCapacity: number;
    /**
     * (experimental) Role that allows Application Auto Scaling to modify your scalable target.
     *
     * @default A role is automatically created
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) The resource identifier to associate with this scalable target.
     *
     * This string consists of the resource type and unique identifier.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html
     * @experimental
     * @example
     *
     * service/ecsStack-MyECSCluster-AB12CDE3F4GH/ecsStack-MyECSService-AB12CDE3F4GH
     */
    readonly resourceId: string;
    /**
     * (experimental) The scalable dimension that's associated with the scalable target.
     *
     * Specify the service namespace, resource type, and scaling property.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_ScalingPolicy.html
     * @experimental
     * @example
     *
     * ecs:service:DesiredCount
     */
    readonly scalableDimension: string;
    /**
     * (experimental) The namespace of the AWS service that provides the resource or custom-resource for a resource provided by your own application or service.
     *
     * For valid AWS service namespace values, see the RegisterScalableTarget
     * action in the Application Auto Scaling API Reference.
     *
     * @see https://docs.aws.amazon.com/autoscaling/application/APIReference/API_RegisterScalableTarget.html
     * @experimental
     */
    readonly serviceNamespace: ServiceNamespace;
}
/**
 * (experimental) Define a scalable target.
 *
 * @experimental
 */
export declare class ScalableTarget extends Resource implements IScalableTarget {
    /**
     * @experimental
     */
    static fromScalableTargetId(scope: Construct, id: string, scalableTargetId: string): IScalableTarget;
    /**
     * (experimental) ID of the Scalable Target.
     *
     * @experimental
     * @example
     *
     * service/ecsStack-MyECSCluster-AB12CDE3F4GH/ecsStack-MyECSService-AB12CDE3F4GH|ecs:service:DesiredCount|ecs@attributeundefined
     */
    readonly scalableTargetId: string;
    /**
     * (experimental) The role used to give AutoScaling permissions to your resource.
     *
     * @experimental
     */
    readonly role: iam.IRole;
    private readonly actions;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ScalableTargetProps);
    /**
     * (experimental) Add a policy statement to the role's policy.
     *
     * @experimental
     */
    addToRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * (experimental) Scale out or in based on time.
     *
     * @experimental
     */
    scaleOnSchedule(id: string, action: ScalingSchedule): void;
    /**
     * (experimental) Scale out or in, in response to a metric.
     *
     * @experimental
     */
    scaleOnMetric(id: string, props: BasicStepScalingPolicyProps): StepScalingPolicy;
    /**
     * (experimental) Scale out or in in order to keep a metric around a target value.
     *
     * @experimental
     */
    scaleToTrackMetric(id: string, props: BasicTargetTrackingScalingPolicyProps): TargetTrackingScalingPolicy;
}
/**
 * (experimental) A scheduled scaling action.
 *
 * @experimental
 */
export interface ScalingSchedule {
    /**
     * (experimental) When to perform this action.
     *
     * @experimental
     */
    readonly schedule: Schedule;
    /**
     * (experimental) When this scheduled action becomes active.
     *
     * @default The rule is activate immediately
     * @experimental
     */
    readonly startTime?: Date;
    /**
     * (experimental) When this scheduled action expires.
     *
     * @default The rule never expires.
     * @experimental
     */
    readonly endTime?: Date;
    /**
     * (experimental) The new minimum capacity.
     *
     * During the scheduled time, if the current capacity is below the minimum
     * capacity, Application Auto Scaling scales out to the minimum capacity.
     *
     * At least one of maxCapacity and minCapacity must be supplied.
     *
     * @default No new minimum capacity
     * @experimental
     */
    readonly minCapacity?: number;
    /**
     * (experimental) The new maximum capacity.
     *
     * During the scheduled time, the current capacity is above the maximum
     * capacity, Application Auto Scaling scales in to the maximum capacity.
     *
     * At least one of maxCapacity and minCapacity must be supplied.
     *
     * @default No new maximum capacity
     * @experimental
     */
    readonly maxCapacity?: number;
}
/**
 * (experimental) The service that supports Application AutoScaling.
 *
 * @experimental
 */
export declare enum ServiceNamespace {
    /**
     * (experimental) Elastic Container Service.
     *
     * @experimental
     */
    ECS = "ecs",
    /**
     * (experimental) Elastic Map Reduce.
     *
     * @experimental
     */
    ELASTIC_MAP_REDUCE = "elasticmapreduce",
    /**
     * (experimental) Elastic Compute Cloud.
     *
     * @experimental
     */
    EC2 = "ec2",
    /**
     * (experimental) App Stream.
     *
     * @experimental
     */
    APPSTREAM = "appstream",
    /**
     * (experimental) Dynamo DB.
     *
     * @experimental
     */
    DYNAMODB = "dynamodb",
    /**
     * (experimental) Relational Database Service.
     *
     * @experimental
     */
    RDS = "rds",
    /**
     * (experimental) SageMaker.
     *
     * @experimental
     */
    SAGEMAKER = "sagemaker",
    /**
     * (experimental) Custom Resource.
     *
     * @experimental
     */
    CUSTOM_RESOURCE = "custom-resource",
    /**
     * (experimental) Lambda.
     *
     * @experimental
     */
    LAMBDA = "lambda",
    /**
     * (experimental) Comprehend.
     *
     * @experimental
     */
    COMPREHEND = "comprehend"
}
