import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ApplicationAutoScaling::ScalableTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html
 * @external
 */
export interface CfnScalableTargetProps {
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MaxCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
     * @external
     */
    readonly maxCapacity: number;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MinCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
     * @external
     */
    readonly minCapacity: number;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid
     * @external
     */
    readonly resourceId: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.RoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn
     * @external
     */
    readonly roleArn: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScalableDimension`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension
     * @external
     */
    readonly scalableDimension: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ServiceNamespace`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace
     * @external
     */
    readonly serviceNamespace: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
     * @external
     */
    readonly scheduledActions?: Array<CfnScalableTarget.ScheduledActionProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate
     * @external
     */
    readonly suspendedState?: CfnScalableTarget.SuspendedStateProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalableTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalableTarget
 */
export declare class CfnScalableTarget extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApplicationAutoScaling::ScalableTarget";
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MaxCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-maxcapacity
     * @external
     */
    maxCapacity: number;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.MinCapacity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-mincapacity
     * @external
     */
    minCapacity: number;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-resourceid
     * @external
     */
    resourceId: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.RoleARN`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-rolearn
     * @external
     */
    roleArn: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScalableDimension`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scalabledimension
     * @external
     */
    scalableDimension: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ServiceNamespace`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-servicenamespace
     * @external
     */
    serviceNamespace: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.ScheduledActions`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-scheduledactions
     * @external
     */
    scheduledActions: Array<CfnScalableTarget.ScheduledActionProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalableTarget.SuspendedState`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html#cfn-applicationautoscaling-scalabletarget-suspendedstate
     * @external
     */
    suspendedState: CfnScalableTarget.SuspendedStateProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApplicationAutoScaling::ScalableTarget`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalableTargetProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalableTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalableTarget
 */
export declare namespace CfnScalableTarget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html
     * @external
     */
    interface ScalableTargetActionProperty {
        /**
         * `CfnScalableTarget.ScalableTargetActionProperty.MaxCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-maxcapacity
         * @external
         */
        readonly maxCapacity?: number;
        /**
         * `CfnScalableTarget.ScalableTargetActionProperty.MinCapacity`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scalabletargetaction.html#cfn-applicationautoscaling-scalabletarget-scalabletargetaction-mincapacity
         * @external
         */
        readonly minCapacity?: number;
    }
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalableTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalableTarget
 */
export declare namespace CfnScalableTarget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html
     * @external
     */
    interface ScheduledActionProperty {
        /**
         * `CfnScalableTarget.ScheduledActionProperty.EndTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-endtime
         * @external
         */
        readonly endTime?: Date | cdk.IResolvable;
        /**
         * `CfnScalableTarget.ScheduledActionProperty.ScalableTargetAction`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scalabletargetaction
         * @external
         */
        readonly scalableTargetAction?: CfnScalableTarget.ScalableTargetActionProperty | cdk.IResolvable;
        /**
         * `CfnScalableTarget.ScheduledActionProperty.Schedule`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-schedule
         * @external
         */
        readonly schedule: string;
        /**
         * `CfnScalableTarget.ScheduledActionProperty.ScheduledActionName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-scheduledactionname
         * @external
         */
        readonly scheduledActionName: string;
        /**
         * `CfnScalableTarget.ScheduledActionProperty.StartTime`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-scheduledaction.html#cfn-applicationautoscaling-scalabletarget-scheduledaction-starttime
         * @external
         */
        readonly startTime?: Date | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalableTarget`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalabletarget.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalableTarget
 */
export declare namespace CfnScalableTarget {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html
     * @external
     */
    interface SuspendedStateProperty {
        /**
         * `CfnScalableTarget.SuspendedStateProperty.DynamicScalingInSuspended`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-dynamicscalinginsuspended
         * @external
         */
        readonly dynamicScalingInSuspended?: boolean | cdk.IResolvable;
        /**
         * `CfnScalableTarget.SuspendedStateProperty.DynamicScalingOutSuspended`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-dynamicscalingoutsuspended
         * @external
         */
        readonly dynamicScalingOutSuspended?: boolean | cdk.IResolvable;
        /**
         * `CfnScalableTarget.SuspendedStateProperty.ScheduledScalingSuspended`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalabletarget-suspendedstate.html#cfn-applicationautoscaling-scalabletarget-suspendedstate-scheduledscalingsuspended
         * @external
         */
        readonly scheduledScalingSuspended?: boolean | cdk.IResolvable;
    }
}
/**
 * Properties for defining a `AWS::ApplicationAutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 * @external
 */
export interface CfnScalingPolicyProps {
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.PolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname
     * @external
     */
    readonly policyName: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.PolicyType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policytype
     * @external
     */
    readonly policyType: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-resourceid
     * @external
     */
    readonly resourceId?: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ScalableDimension`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalabledimension
     * @external
     */
    readonly scalableDimension?: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ScalingTargetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalingtargetid
     * @external
     */
    readonly scalingTargetId?: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ServiceNamespace`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-servicenamespace
     * @external
     */
    readonly serviceNamespace?: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.StepScalingPolicyConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration
     * @external
     */
    readonly stepScalingPolicyConfiguration?: CfnScalingPolicy.StepScalingPolicyConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.TargetTrackingScalingPolicyConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration
     * @external
     */
    readonly targetTrackingScalingPolicyConfiguration?: CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalingPolicy
 */
export declare class CfnScalingPolicy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ApplicationAutoScaling::ScalingPolicy";
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.PolicyName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policyname
     * @external
     */
    policyName: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.PolicyType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-policytype
     * @external
     */
    policyType: string;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ResourceId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-resourceid
     * @external
     */
    resourceId: string | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ScalableDimension`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalabledimension
     * @external
     */
    scalableDimension: string | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ScalingTargetId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-scalingtargetid
     * @external
     */
    scalingTargetId: string | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.ServiceNamespace`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-servicenamespace
     * @external
     */
    serviceNamespace: string | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.StepScalingPolicyConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration
     * @external
     */
    stepScalingPolicyConfiguration: CfnScalingPolicy.StepScalingPolicyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ApplicationAutoScaling::ScalingPolicy.TargetTrackingScalingPolicyConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration
     * @external
     */
    targetTrackingScalingPolicyConfiguration: CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::ApplicationAutoScaling::ScalingPolicy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnScalingPolicyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html
     * @external
     */
    interface CustomizedMetricSpecificationProperty {
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Dimensions`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-dimensions
         * @external
         */
        readonly dimensions?: Array<CfnScalingPolicy.MetricDimensionProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.MetricName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-metricname
         * @external
         */
        readonly metricName: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Namespace`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-namespace
         * @external
         */
        readonly namespace: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Statistic`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-statistic
         * @external
         */
        readonly statistic: string;
        /**
         * `CfnScalingPolicy.CustomizedMetricSpecificationProperty.Unit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-customizedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-customizedmetricspecification-unit
         * @external
         */
        readonly unit?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html
     * @external
     */
    interface MetricDimensionProperty {
        /**
         * `CfnScalingPolicy.MetricDimensionProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html#cfn-applicationautoscaling-scalingpolicy-metricdimension-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnScalingPolicy.MetricDimensionProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-metricdimension.html#cfn-applicationautoscaling-scalingpolicy-metricdimension-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html
     * @external
     */
    interface PredefinedMetricSpecificationProperty {
        /**
         * `CfnScalingPolicy.PredefinedMetricSpecificationProperty.PredefinedMetricType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predefinedmetricspecification-predefinedmetrictype
         * @external
         */
        readonly predefinedMetricType: string;
        /**
         * `CfnScalingPolicy.PredefinedMetricSpecificationProperty.ResourceLabel`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-predefinedmetricspecification.html#cfn-applicationautoscaling-scalingpolicy-predefinedmetricspecification-resourcelabel
         * @external
         */
        readonly resourceLabel?: string;
    }
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment.html
     * @external
     */
    interface StepAdjustmentProperty {
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.MetricIntervalLowerBound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment-metricintervallowerbound
         * @external
         */
        readonly metricIntervalLowerBound?: number;
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.MetricIntervalUpperBound`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment-metricintervalupperbound
         * @external
         */
        readonly metricIntervalUpperBound?: number;
        /**
         * `CfnScalingPolicy.StepAdjustmentProperty.ScalingAdjustment`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustment-scalingadjustment
         * @external
         */
        readonly scalingAdjustment: number;
    }
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html
     * @external
     */
    interface StepScalingPolicyConfigurationProperty {
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.AdjustmentType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-adjustmenttype
         * @external
         */
        readonly adjustmentType?: string;
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.Cooldown`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-cooldown
         * @external
         */
        readonly cooldown?: number;
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.MetricAggregationType`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-metricaggregationtype
         * @external
         */
        readonly metricAggregationType?: string;
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.MinAdjustmentMagnitude`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-minadjustmentmagnitude
         * @external
         */
        readonly minAdjustmentMagnitude?: number;
        /**
         * `CfnScalingPolicy.StepScalingPolicyConfigurationProperty.StepAdjustments`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-stepscalingpolicyconfiguration-stepadjustments
         * @external
         */
        readonly stepAdjustments?: Array<CfnScalingPolicy.StepAdjustmentProperty | cdk.IResolvable> | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ApplicationAutoScaling::ScalingPolicy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-applicationautoscaling-scalingpolicy.html
 * @external
 * @cloudformationResource AWS::ApplicationAutoScaling::ScalingPolicy
 */
export declare namespace CfnScalingPolicy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html
     * @external
     */
    interface TargetTrackingScalingPolicyConfigurationProperty {
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.CustomizedMetricSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-customizedmetricspecification
         * @external
         */
        readonly customizedMetricSpecification?: CfnScalingPolicy.CustomizedMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.DisableScaleIn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-disablescalein
         * @external
         */
        readonly disableScaleIn?: boolean | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.PredefinedMetricSpecification`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-predefinedmetricspecification
         * @external
         */
        readonly predefinedMetricSpecification?: CfnScalingPolicy.PredefinedMetricSpecificationProperty | cdk.IResolvable;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.ScaleInCooldown`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleincooldown
         * @external
         */
        readonly scaleInCooldown?: number;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.ScaleOutCooldown`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-scaleoutcooldown
         * @external
         */
        readonly scaleOutCooldown?: number;
        /**
         * `CfnScalingPolicy.TargetTrackingScalingPolicyConfigurationProperty.TargetValue`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration.html#cfn-applicationautoscaling-scalingpolicy-targettrackingscalingpolicyconfiguration-targetvalue
         * @external
         */
        readonly targetValue: number;
    }
}
