import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::AppConfig::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html
 * @external
 */
export interface CfnApplicationProps {
    /**
     * `AWS::AppConfig::Application.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html#cfn-appconfig-application-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppConfig::Application.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html#cfn-appconfig-application-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppConfig::Application.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html#cfn-appconfig-application-tags
     * @external
     */
    readonly tags?: CfnApplication.TagsProperty[];
}
/**
 * A CloudFormation `AWS::AppConfig::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html
 * @external
 * @cloudformationResource AWS::AppConfig::Application
 */
export declare class CfnApplication extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppConfig::Application";
    /**
     * `AWS::AppConfig::Application.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html#cfn-appconfig-application-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppConfig::Application.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html#cfn-appconfig-application-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppConfig::Application.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html#cfn-appconfig-application-tags
     * @external
     */
    tags: CfnApplication.TagsProperty[] | undefined;
    /**
     * Create a new `AWS::AppConfig::Application`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnApplicationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppConfig::Application`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-application.html
 * @external
 * @cloudformationResource AWS::AppConfig::Application
 */
export declare namespace CfnApplication {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-application-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnApplication.TagsProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-application-tags.html#cfn-appconfig-application-tags-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnApplication.TagsProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-application-tags.html#cfn-appconfig-application-tags-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::AppConfig::ConfigurationProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html
 * @external
 */
export interface CfnConfigurationProfileProps {
    /**
     * `AWS::AppConfig::ConfigurationProfile.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::AppConfig::ConfigurationProfile.LocationUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-locationuri
     * @external
     */
    readonly locationUri: string;
    /**
     * `AWS::AppConfig::ConfigurationProfile.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppConfig::ConfigurationProfile.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppConfig::ConfigurationProfile.RetrievalRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-retrievalrolearn
     * @external
     */
    readonly retrievalRoleArn?: string;
    /**
     * `AWS::AppConfig::ConfigurationProfile.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-tags
     * @external
     */
    readonly tags?: CfnConfigurationProfile.TagsProperty[];
    /**
     * `AWS::AppConfig::ConfigurationProfile.Validators`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-validators
     * @external
     */
    readonly validators?: Array<CfnConfigurationProfile.ValidatorsProperty | cdk.IResolvable> | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::AppConfig::ConfigurationProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html
 * @external
 * @cloudformationResource AWS::AppConfig::ConfigurationProfile
 */
export declare class CfnConfigurationProfile extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppConfig::ConfigurationProfile";
    /**
     * `AWS::AppConfig::ConfigurationProfile.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::AppConfig::ConfigurationProfile.LocationUri`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-locationuri
     * @external
     */
    locationUri: string;
    /**
     * `AWS::AppConfig::ConfigurationProfile.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppConfig::ConfigurationProfile.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppConfig::ConfigurationProfile.RetrievalRoleArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-retrievalrolearn
     * @external
     */
    retrievalRoleArn: string | undefined;
    /**
     * `AWS::AppConfig::ConfigurationProfile.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-tags
     * @external
     */
    tags: CfnConfigurationProfile.TagsProperty[] | undefined;
    /**
     * `AWS::AppConfig::ConfigurationProfile.Validators`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html#cfn-appconfig-configurationprofile-validators
     * @external
     */
    validators: Array<CfnConfigurationProfile.ValidatorsProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::AppConfig::ConfigurationProfile`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnConfigurationProfileProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppConfig::ConfigurationProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html
 * @external
 * @cloudformationResource AWS::AppConfig::ConfigurationProfile
 */
export declare namespace CfnConfigurationProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-configurationprofile-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnConfigurationProfile.TagsProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-configurationprofile-tags.html#cfn-appconfig-configurationprofile-tags-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnConfigurationProfile.TagsProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-configurationprofile-tags.html#cfn-appconfig-configurationprofile-tags-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * A CloudFormation `AWS::AppConfig::ConfigurationProfile`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-configurationprofile.html
 * @external
 * @cloudformationResource AWS::AppConfig::ConfigurationProfile
 */
export declare namespace CfnConfigurationProfile {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-configurationprofile-validators.html
     * @external
     */
    interface ValidatorsProperty {
        /**
         * `CfnConfigurationProfile.ValidatorsProperty.Content`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-configurationprofile-validators.html#cfn-appconfig-configurationprofile-validators-content
         * @external
         */
        readonly content?: string;
        /**
         * `CfnConfigurationProfile.ValidatorsProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-configurationprofile-validators.html#cfn-appconfig-configurationprofile-validators-type
         * @external
         */
        readonly type?: string;
    }
}
/**
 * Properties for defining a `AWS::AppConfig::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html
 * @external
 */
export interface CfnDeploymentProps {
    /**
     * `AWS::AppConfig::Deployment.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::AppConfig::Deployment.ConfigurationProfileId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-configurationprofileid
     * @external
     */
    readonly configurationProfileId: string;
    /**
     * `AWS::AppConfig::Deployment.ConfigurationVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-configurationversion
     * @external
     */
    readonly configurationVersion: string;
    /**
     * `AWS::AppConfig::Deployment.DeploymentStrategyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-deploymentstrategyid
     * @external
     */
    readonly deploymentStrategyId: string;
    /**
     * `AWS::AppConfig::Deployment.EnvironmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-environmentid
     * @external
     */
    readonly environmentId: string;
    /**
     * `AWS::AppConfig::Deployment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppConfig::Deployment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-tags
     * @external
     */
    readonly tags?: CfnDeployment.TagsProperty[];
}
/**
 * A CloudFormation `AWS::AppConfig::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html
 * @external
 * @cloudformationResource AWS::AppConfig::Deployment
 */
export declare class CfnDeployment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppConfig::Deployment";
    /**
     * `AWS::AppConfig::Deployment.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::AppConfig::Deployment.ConfigurationProfileId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-configurationprofileid
     * @external
     */
    configurationProfileId: string;
    /**
     * `AWS::AppConfig::Deployment.ConfigurationVersion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-configurationversion
     * @external
     */
    configurationVersion: string;
    /**
     * `AWS::AppConfig::Deployment.DeploymentStrategyId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-deploymentstrategyid
     * @external
     */
    deploymentStrategyId: string;
    /**
     * `AWS::AppConfig::Deployment.EnvironmentId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-environmentid
     * @external
     */
    environmentId: string;
    /**
     * `AWS::AppConfig::Deployment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppConfig::Deployment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html#cfn-appconfig-deployment-tags
     * @external
     */
    tags: CfnDeployment.TagsProperty[] | undefined;
    /**
     * Create a new `AWS::AppConfig::Deployment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeploymentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppConfig::Deployment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deployment.html
 * @external
 * @cloudformationResource AWS::AppConfig::Deployment
 */
export declare namespace CfnDeployment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-deployment-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnDeployment.TagsProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-deployment-tags.html#cfn-appconfig-deployment-tags-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnDeployment.TagsProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-deployment-tags.html#cfn-appconfig-deployment-tags-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::AppConfig::DeploymentStrategy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html
 * @external
 */
export interface CfnDeploymentStrategyProps {
    /**
     * `AWS::AppConfig::DeploymentStrategy.DeploymentDurationInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-deploymentdurationinminutes
     * @external
     */
    readonly deploymentDurationInMinutes: number;
    /**
     * `AWS::AppConfig::DeploymentStrategy.GrowthFactor`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-growthfactor
     * @external
     */
    readonly growthFactor: number;
    /**
     * `AWS::AppConfig::DeploymentStrategy.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppConfig::DeploymentStrategy.ReplicateTo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-replicateto
     * @external
     */
    readonly replicateTo: string;
    /**
     * `AWS::AppConfig::DeploymentStrategy.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppConfig::DeploymentStrategy.FinalBakeTimeInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-finalbaketimeinminutes
     * @external
     */
    readonly finalBakeTimeInMinutes?: number;
    /**
     * `AWS::AppConfig::DeploymentStrategy.GrowthType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-growthtype
     * @external
     */
    readonly growthType?: string;
    /**
     * `AWS::AppConfig::DeploymentStrategy.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-tags
     * @external
     */
    readonly tags?: CfnDeploymentStrategy.TagsProperty[];
}
/**
 * A CloudFormation `AWS::AppConfig::DeploymentStrategy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html
 * @external
 * @cloudformationResource AWS::AppConfig::DeploymentStrategy
 */
export declare class CfnDeploymentStrategy extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppConfig::DeploymentStrategy";
    /**
     * `AWS::AppConfig::DeploymentStrategy.DeploymentDurationInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-deploymentdurationinminutes
     * @external
     */
    deploymentDurationInMinutes: number;
    /**
     * `AWS::AppConfig::DeploymentStrategy.GrowthFactor`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-growthfactor
     * @external
     */
    growthFactor: number;
    /**
     * `AWS::AppConfig::DeploymentStrategy.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppConfig::DeploymentStrategy.ReplicateTo`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-replicateto
     * @external
     */
    replicateTo: string;
    /**
     * `AWS::AppConfig::DeploymentStrategy.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppConfig::DeploymentStrategy.FinalBakeTimeInMinutes`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-finalbaketimeinminutes
     * @external
     */
    finalBakeTimeInMinutes: number | undefined;
    /**
     * `AWS::AppConfig::DeploymentStrategy.GrowthType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-growthtype
     * @external
     */
    growthType: string | undefined;
    /**
     * `AWS::AppConfig::DeploymentStrategy.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html#cfn-appconfig-deploymentstrategy-tags
     * @external
     */
    tags: CfnDeploymentStrategy.TagsProperty[] | undefined;
    /**
     * Create a new `AWS::AppConfig::DeploymentStrategy`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDeploymentStrategyProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppConfig::DeploymentStrategy`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-deploymentstrategy.html
 * @external
 * @cloudformationResource AWS::AppConfig::DeploymentStrategy
 */
export declare namespace CfnDeploymentStrategy {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-deploymentstrategy-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnDeploymentStrategy.TagsProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-deploymentstrategy-tags.html#cfn-appconfig-deploymentstrategy-tags-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnDeploymentStrategy.TagsProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-deploymentstrategy-tags.html#cfn-appconfig-deploymentstrategy-tags-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::AppConfig::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html
 * @external
 */
export interface CfnEnvironmentProps {
    /**
     * `AWS::AppConfig::Environment.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::AppConfig::Environment.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::AppConfig::Environment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppConfig::Environment.Monitors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-monitors
     * @external
     */
    readonly monitors?: Array<CfnEnvironment.MonitorsProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::AppConfig::Environment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-tags
     * @external
     */
    readonly tags?: CfnEnvironment.TagsProperty[];
}
/**
 * A CloudFormation `AWS::AppConfig::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html
 * @external
 * @cloudformationResource AWS::AppConfig::Environment
 */
export declare class CfnEnvironment extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppConfig::Environment";
    /**
     * `AWS::AppConfig::Environment.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::AppConfig::Environment.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-name
     * @external
     */
    name: string;
    /**
     * `AWS::AppConfig::Environment.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppConfig::Environment.Monitors`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-monitors
     * @external
     */
    monitors: Array<CfnEnvironment.MonitorsProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::AppConfig::Environment.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html#cfn-appconfig-environment-tags
     * @external
     */
    tags: CfnEnvironment.TagsProperty[] | undefined;
    /**
     * Create a new `AWS::AppConfig::Environment`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnEnvironmentProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::AppConfig::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html
 * @external
 * @cloudformationResource AWS::AppConfig::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-environment-monitors.html
     * @external
     */
    interface MonitorsProperty {
        /**
         * `CfnEnvironment.MonitorsProperty.AlarmArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-environment-monitors.html#cfn-appconfig-environment-monitors-alarmarn
         * @external
         */
        readonly alarmArn?: string;
        /**
         * `CfnEnvironment.MonitorsProperty.AlarmRoleArn`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-environment-monitors.html#cfn-appconfig-environment-monitors-alarmrolearn
         * @external
         */
        readonly alarmRoleArn?: string;
    }
}
/**
 * A CloudFormation `AWS::AppConfig::Environment`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-environment.html
 * @external
 * @cloudformationResource AWS::AppConfig::Environment
 */
export declare namespace CfnEnvironment {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-environment-tags.html
     * @external
     */
    interface TagsProperty {
        /**
         * `CfnEnvironment.TagsProperty.Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-environment-tags.html#cfn-appconfig-environment-tags-key
         * @external
         */
        readonly key?: string;
        /**
         * `CfnEnvironment.TagsProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-appconfig-environment-tags.html#cfn-appconfig-environment-tags-value
         * @external
         */
        readonly value?: string;
    }
}
/**
 * Properties for defining a `AWS::AppConfig::HostedConfigurationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html
 * @external
 */
export interface CfnHostedConfigurationVersionProps {
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-applicationid
     * @external
     */
    readonly applicationId: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.ConfigurationProfileId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-configurationprofileid
     * @external
     */
    readonly configurationProfileId: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.Content`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-content
     * @external
     */
    readonly content: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.ContentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-contenttype
     * @external
     */
    readonly contentType: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.LatestVersionNumber`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-latestversionnumber
     * @external
     */
    readonly latestVersionNumber?: number;
}
/**
 * A CloudFormation `AWS::AppConfig::HostedConfigurationVersion`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html
 * @external
 * @cloudformationResource AWS::AppConfig::HostedConfigurationVersion
 */
export declare class CfnHostedConfigurationVersion extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::AppConfig::HostedConfigurationVersion";
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.ApplicationId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-applicationid
     * @external
     */
    applicationId: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.ConfigurationProfileId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-configurationprofileid
     * @external
     */
    configurationProfileId: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.Content`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-content
     * @external
     */
    content: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.ContentType`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-contenttype
     * @external
     */
    contentType: string;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::AppConfig::HostedConfigurationVersion.LatestVersionNumber`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-appconfig-hostedconfigurationversion.html#cfn-appconfig-hostedconfigurationversion-latestversionnumber
     * @external
     */
    latestVersionNumber: number | undefined;
    /**
     * Create a new `AWS::AppConfig::HostedConfigurationVersion`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnHostedConfigurationVersionProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
