"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpStage = void 0;
const core_1 = require("../../../core"); // Automatically re-written from '@aws-cdk/core'
const apigatewayv2_generated_1 = require("../apigatewayv2.generated");
const api_mapping_1 = require("./api-mapping");
const DEFAULT_STAGE_NAME = '$default';
/**
 * (experimental) Represents a stage where an instance of the API is deployed.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Stage
 */
class HttpStage extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id, {
            physicalName: props.stageName ? props.stageName : DEFAULT_STAGE_NAME,
        });
        new apigatewayv2_generated_1.CfnStage(this, 'Resource', {
            apiId: props.httpApi.httpApiId,
            stageName: this.physicalName,
            autoDeploy: props.autoDeploy,
        });
        this.stageName = this.physicalName;
        this.httpApi = props.httpApi;
        if (props.domainMapping) {
            new api_mapping_1.HttpApiMapping(this, `${props.domainMapping.domainName}${props.domainMapping.mappingKey}`, {
                api: props.httpApi,
                domainName: props.domainMapping.domainName,
                stage: this,
                apiMappingKey: props.domainMapping.mappingKey,
            });
            // ensure the dependency
            this.node.addDependency(props.domainMapping.domainName);
        }
    }
    /**
     * (experimental) Import an existing stage into this CDK app.
     *
     * @experimental
     */
    static fromStageName(scope, id, stageName) {
        class Import extends core_1.Resource {
            constructor() {
                super(...arguments);
                this.stageName = stageName;
            }
        }
        return new Import(scope, id);
    }
    /**
     * (experimental) The URL to this stage.
     *
     * @experimental
     */
    get url() {
        const s = core_1.Stack.of(this);
        const urlPath = this.stageName === DEFAULT_STAGE_NAME ? '' : this.stageName;
        return `https://${this.httpApi.httpApiId}.execute-api.${s.region}.${s.urlSuffix}/${urlPath}`;
    }
}
exports.HttpStage = HttpStage;
//# sourceMappingURL=data:application/json;base64,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