import { Resource } from "../../../core";
import { Construct } from 'constructs';
import { CommonStageOptions, IDomainName, IStage } from '../common';
import { IHttpApi } from './api';
/**
 * (experimental) Represents the HttpStage.
 *
 * @experimental
 */
export interface IHttpStage extends IStage {
}
/**
 * (experimental) Options to create a new stage for an HTTP API.
 *
 * @experimental
 */
export interface HttpStageOptions extends CommonStageOptions {
    /**
     * (experimental) The options for custom domain and api mapping.
     *
     * @default - no custom domain and api mapping configuration
     * @experimental
     */
    readonly domainMapping?: DomainMappingOptions;
}
/**
 * (experimental) Properties to initialize an instance of `HttpStage`.
 *
 * @experimental
 */
export interface HttpStageProps extends HttpStageOptions {
    /**
     * (experimental) The HTTP API to which this stage is associated.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
}
/**
 * (experimental) Options for defaultDomainMapping.
 *
 * @experimental
 */
export interface DefaultDomainMappingOptions {
    /**
     * (experimental) The domain name for the mapping.
     *
     * @experimental
     */
    readonly domainName: IDomainName;
    /**
     * (experimental) The API mapping key.
     *
     * Leave it undefined for the root path mapping.
     *
     * @default - empty key for the root path mapping
     * @experimental
     */
    readonly mappingKey?: string;
}
/**
 * (experimental) Options for DomainMapping.
 *
 * @experimental
 */
export interface DomainMappingOptions extends DefaultDomainMappingOptions {
    /**
     * (experimental) The API Stage.
     *
     * @default - the $default stage
     * @experimental
     */
    readonly stage?: IStage;
}
/**
 * (experimental) Represents a stage where an instance of the API is deployed.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Stage
 */
export declare class HttpStage extends Resource implements IStage {
    /**
     * (experimental) Import an existing stage into this CDK app.
     *
     * @experimental
     */
    static fromStageName(scope: Construct, id: string, stageName: string): IStage;
    /**
     * (experimental) The name of the stage;
     *
     * its primary identifier.
     *
     * @experimental
     */
    readonly stageName: string;
    private httpApi;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpStageProps);
    /**
     * (experimental) The URL to this stage.
     *
     * @experimental
     */
    get url(): string;
}
