import { Resource } from "../../../core";
import { Construct } from 'constructs';
import { IRoute } from '../common';
import { IHttpApi } from './api';
import { IHttpRouteIntegration } from './integration';
/**
 * (experimental) Represents a Route for an HTTP API.
 *
 * @experimental
 */
export interface IHttpRoute extends IRoute {
    /**
     * (experimental) The HTTP API associated with this route.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
    /**
     * (experimental) Returns the path component of this HTTP route, `undefined` if the path is the catch-all route.
     *
     * @experimental
     */
    readonly path?: string;
}
/**
 * (experimental) Supported HTTP methods.
 *
 * @experimental
 */
export declare enum HttpMethod {
    /**
     * (experimental) HTTP ANY.
     *
     * @experimental
     */
    ANY = "ANY",
    /**
     * (experimental) HTTP DELETE.
     *
     * @experimental
     */
    DELETE = "DELETE",
    /**
     * (experimental) HTTP GET.
     *
     * @experimental
     */
    GET = "GET",
    /**
     * (experimental) HTTP HEAD.
     *
     * @experimental
     */
    HEAD = "HEAD",
    /**
     * (experimental) HTTP OPTIONS.
     *
     * @experimental
     */
    OPTIONS = "OPTIONS",
    /**
     * (experimental) HTTP PATCH.
     *
     * @experimental
     */
    PATCH = "PATCH",
    /**
     * (experimental) HTTP POST.
     *
     * @experimental
     */
    POST = "POST",
    /**
     * (experimental) HTTP PUT.
     *
     * @experimental
     */
    PUT = "PUT"
}
/**
 * (experimental) HTTP route in APIGateway is a combination of the HTTP method and the path component.
 *
 * This class models that combination.
 *
 * @experimental
 */
export declare class HttpRouteKey {
    /**
     * (experimental) The catch-all route of the API, i.e., when no other routes match.
     *
     * @experimental
     */
    static readonly DEFAULT: HttpRouteKey;
    /**
     * (experimental) Create a route key with the combination of the path and the method.
     *
     * @param method default is 'ANY'.
     * @experimental
     */
    static with(path: string, method?: HttpMethod): HttpRouteKey;
    /**
     * (experimental) The key to the RouteKey as recognized by APIGateway.
     *
     * @experimental
     */
    readonly key: string;
    /**
     * (experimental) The path part of this RouteKey.
     *
     * Returns `undefined` when `RouteKey.DEFAULT` is used.
     *
     * @experimental
     */
    readonly path?: string;
    private constructor();
}
/**
 * (experimental) Options used when configuring multiple routes, at once.
 *
 * The options here are the ones that would be configured for all being set up.
 *
 * @experimental
 */
export interface BatchHttpRouteOptions {
    /**
     * (experimental) The integration to be configured on this route.
     *
     * @experimental
     */
    readonly integration: IHttpRouteIntegration;
}
/**
 * (experimental) Properties to initialize a new Route.
 *
 * @experimental
 */
export interface HttpRouteProps extends BatchHttpRouteOptions {
    /**
     * (experimental) the API the route is associated with.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
    /**
     * (experimental) The key to this route.
     *
     * This is a combination of an HTTP method and an HTTP path.
     *
     * @experimental
     */
    readonly routeKey: HttpRouteKey;
}
/**
 * (experimental) Route class that creates the Route for API Gateway HTTP API.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Route
 */
export declare class HttpRoute extends Resource implements IHttpRoute {
    /**
     * (experimental) Id of the Route.
     *
     * @experimental
     */
    readonly routeId: string;
    /**
     * (experimental) The HTTP API associated with this route.
     *
     * @experimental
     */
    readonly httpApi: IHttpApi;
    /**
     * (experimental) Returns the path component of this HTTP route, `undefined` if the path is the catch-all route.
     *
     * @experimental
     */
    readonly path?: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: HttpRouteProps);
}
