"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaProxyIntegration = void 0;
const aws_iam_1 = require("../../../../aws-iam"); // Automatically re-written from '@aws-cdk/aws-iam'
const core_1 = require("../../../../core"); // Automatically re-written from '@aws-cdk/core'
const integration_1 = require("../integration");
/**
 * (experimental) The Lambda Proxy integration resource for HTTP API.
 *
 * @experimental
 */
class LambdaProxyIntegration {
    /**
     * @experimental
     */
    constructor(props) {
        this.props = props;
    }
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options) {
        var _a, _b;
        const route = options.route;
        this.props.handler.addPermission(`${route.node.uniqueId}-Permission`, {
            scope: options.scope,
            principal: new aws_iam_1.ServicePrincipal('apigateway.amazonaws.com'),
            sourceArn: core_1.Stack.of(route).formatArn({
                service: 'execute-api',
                resource: route.httpApi.httpApiId,
                resourceName: `*/*${(_a = route.path) !== null && _a !== void 0 ? _a : ''}`,
            }),
        });
        return {
            type: integration_1.HttpIntegrationType.LAMBDA_PROXY,
            uri: this.props.handler.functionArn,
            payloadFormatVersion: (_b = this.props.payloadFormatVersion) !== null && _b !== void 0 ? _b : integration_1.PayloadFormatVersion.VERSION_2_0,
        };
    }
}
exports.LambdaProxyIntegration = LambdaProxyIntegration;
//# sourceMappingURL=data:application/json;base64,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