import { IFunction } from "../../../../aws-lambda";
import { HttpRouteIntegrationBindOptions, HttpRouteIntegrationConfig, IHttpRouteIntegration, PayloadFormatVersion } from '../integration';
/**
 * (experimental) Lambda Proxy integration properties.
 *
 * @experimental
 */
export interface LambdaProxyIntegrationProps {
    /**
     * (experimental) The handler for this integration.
     *
     * @experimental
     */
    readonly handler: IFunction;
    /**
     * (experimental) Version of the payload sent to the lambda handler.
     *
     * @default PayloadFormatVersion.VERSION_2_0
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-lambda.html
     * @experimental
     */
    readonly payloadFormatVersion?: PayloadFormatVersion;
}
/**
 * (experimental) The Lambda Proxy integration resource for HTTP API.
 *
 * @experimental
 */
export declare class LambdaProxyIntegration implements IHttpRouteIntegration {
    private readonly props;
    /**
     * @experimental
     */
    constructor(props: LambdaProxyIntegrationProps);
    /**
     * (experimental) Bind this integration to the route.
     *
     * @experimental
     */
    bind(options: HttpRouteIntegrationBindOptions): HttpRouteIntegrationConfig;
}
