import { Duration, IResource, Resource } from "../../../core";
import { Construct } from 'constructs';
import { DefaultDomainMappingOptions } from '../http/stage';
import { IHttpRouteIntegration } from './integration';
import { BatchHttpRouteOptions, HttpMethod, HttpRoute } from './route';
import { HttpStage, HttpStageOptions } from './stage';
/**
 * (experimental) Represents an HTTP API.
 *
 * @experimental
 */
export interface IHttpApi extends IResource {
    /**
     * (experimental) The identifier of this API Gateway HTTP API.
     *
     * @experimental
     * @attribute true
     */
    readonly httpApiId: string;
    /**
     * (experimental) The default stage.
     *
     * @experimental
     */
    readonly defaultStage?: HttpStage;
}
/**
 * (experimental) Properties to initialize an instance of `HttpApi`.
 *
 * @experimental
 */
export interface HttpApiProps {
    /**
     * (experimental) Name for the HTTP API resoruce.
     *
     * @default - id of the HttpApi construct.
     * @experimental
     */
    readonly apiName?: string;
    /**
     * (experimental) An integration that will be configured on the catch-all route ($default).
     *
     * @default - none
     * @experimental
     */
    readonly defaultIntegration?: IHttpRouteIntegration;
    /**
     * (experimental) Whether a default stage and deployment should be automatically created.
     *
     * @default true
     * @experimental
     */
    readonly createDefaultStage?: boolean;
    /**
     * (experimental) Specifies a CORS configuration for an API.
     *
     * @default - CORS disabled.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-cors.html
     * @experimental
     */
    readonly corsPreflight?: CorsPreflightOptions;
    /**
     * (experimental) Configure a custom domain with the API mapping resource to the HTTP API.
     *
     * @default - no default domain mapping configured. meaningless if `createDefaultStage` is `false`.
     * @experimental
     */
    readonly defaultDomainMapping?: DefaultDomainMappingOptions;
}
/**
 * (experimental) Options for the CORS Configuration.
 *
 * @experimental
 */
export interface CorsPreflightOptions {
    /**
     * (experimental) Specifies whether credentials are included in the CORS request.
     *
     * @default false
     * @experimental
     */
    readonly allowCredentials?: boolean;
    /**
     * (experimental) Represents a collection of allowed headers.
     *
     * @default - No Headers are allowed.
     * @experimental
     */
    readonly allowHeaders?: string[];
    /**
     * (experimental) Represents a collection of allowed HTTP methods.
     *
     * @default - No Methods are allowed.
     * @experimental
     */
    readonly allowMethods?: HttpMethod[];
    /**
     * (experimental) Represents a collection of allowed origins.
     *
     * @default - No Origins are allowed.
     * @experimental
     */
    readonly allowOrigins?: string[];
    /**
     * (experimental) Represents a collection of exposed headers.
     *
     * @default - No Expose Headers are allowed.
     * @experimental
     */
    readonly exposeHeaders?: string[];
    /**
     * (experimental) The duration that the browser should cache preflight request results.
     *
     * @default Duration.seconds(0)
     * @experimental
     */
    readonly maxAge?: Duration;
}
/**
 * (experimental) Options for the Route with Integration resoruce.
 *
 * @experimental
 */
export interface AddRoutesOptions extends BatchHttpRouteOptions {
    /**
     * (experimental) The path at which all of these routes are configured.
     *
     * @experimental
     */
    readonly path: string;
    /**
     * (experimental) The HTTP methods to be configured.
     *
     * @default HttpMethod.ANY
     * @experimental
     */
    readonly methods?: HttpMethod[];
}
/**
 * (experimental) Create a new API Gateway HTTP API endpoint.
 *
 * @experimental
 * @resource AWS::ApiGatewayV2::Api
 */
export declare class HttpApi extends Resource implements IHttpApi {
    /**
     * (experimental) Import an existing HTTP API into this CDK app.
     *
     * @experimental
     */
    static fromApiId(scope: Construct, id: string, httpApiId: string): IHttpApi;
    /**
     * (experimental) The identifier of this API Gateway HTTP API.
     *
     * @experimental
     */
    readonly httpApiId: string;
    /**
     * (experimental) default stage of the api resource.
     *
     * @experimental
     */
    readonly defaultStage: HttpStage | undefined;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: HttpApiProps);
    /**
     * (experimental) Get the URL to the default stage of this API.
     *
     * Returns `undefined` if `createDefaultStage` is unset.
     *
     * @experimental
     */
    get url(): string | undefined;
    /**
     * (experimental) Add a new stage.
     *
     * @experimental
     */
    addStage(id: string, options: HttpStageOptions): HttpStage;
    /**
     * (experimental) Add multiple routes that uses the same configuration.
     *
     * The routes all go to the same path, but for different
     * methods.
     *
     * @experimental
     */
    addRoutes(options: AddRoutesOptions): HttpRoute[];
}
