import * as elbv2 from "../../aws-elasticloadbalancingv2";
import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
/**
 * (experimental) Represents an API Gateway VpcLink.
 *
 * @experimental
 */
export interface IVpcLink extends IResource {
    /**
     * (experimental) Physical ID of the VpcLink resource.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcLinkId: string;
}
/**
 * (experimental) Properties for a VpcLink.
 *
 * @experimental
 */
export interface VpcLinkProps {
    /**
     * (experimental) The name used to label and identify the VPC link.
     *
     * @default - automatically generated name
     * @experimental
     */
    readonly vpcLinkName?: string;
    /**
     * (experimental) The description of the VPC link.
     *
     * @default no description
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The network load balancers of the VPC targeted by the VPC link.
     *
     * The network load balancers must be owned by the same AWS account of the API owner.
     *
     * @default - no targets. Use `addTargets` to add targets
     * @experimental
     */
    readonly targets?: elbv2.INetworkLoadBalancer[];
}
/**
 * (experimental) Define a new VPC Link Specifies an API Gateway VPC link for a RestApi to access resources in an Amazon Virtual Private Cloud (VPC).
 *
 * @experimental
 */
export declare class VpcLink extends Resource implements IVpcLink {
    /**
     * (experimental) Import a VPC Link by its Id.
     *
     * @experimental
     */
    static fromVpcLinkId(scope: Construct, id: string, vpcLinkId: string): IVpcLink;
    /**
     * (experimental) Physical ID of the VpcLink resource.
     *
     * @experimental
     * @attribute true
     */
    readonly vpcLinkId: string;
    private readonly targets;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: VpcLinkProps);
    /**
     * @experimental
     */
    addTargets(...targets: elbv2.INetworkLoadBalancer[]): void;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    private renderTargets;
}
