import { Duration, IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { AccessLogFormat, IAccessLogDestination } from './access-log';
import { Deployment } from './deployment';
import { IRestApi } from './restapi';
/**
 * (experimental) Represents an APIGateway Stage.
 *
 * @experimental
 */
export interface IStage extends IResource {
    /**
     * (experimental) Name of this stage.
     *
     * @experimental
     * @attribute true
     */
    readonly stageName: string;
    /**
     * (experimental) RestApi to which this stage is associated.
     *
     * @experimental
     */
    readonly restApi: IRestApi;
}
/**
 * @experimental
 */
export interface StageOptions extends MethodDeploymentOptions {
    /**
     * (experimental) The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
     *
     * @default - "prod"
     * @experimental
     */
    readonly stageName?: string;
    /**
     * (experimental) The CloudWatch Logs log group.
     *
     * @default - No destination
     * @experimental
     */
    readonly accessLogDestination?: IAccessLogDestination;
    /**
     * (experimental) A single line format of access logs of data, as specified by selected $content variables.
     *
     * The format must include at least `AccessLogFormat.contextRequestId()`.
     *
     * @default - Common Log Format
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html#context-variable-reference
     * @experimental
     */
    readonly accessLogFormat?: AccessLogFormat;
    /**
     * (experimental) Specifies whether Amazon X-Ray tracing is enabled for this method.
     *
     * @default false
     * @experimental
     */
    readonly tracingEnabled?: boolean;
    /**
     * (experimental) Indicates whether cache clustering is enabled for the stage.
     *
     * @default - Disabled for the stage.
     * @experimental
     */
    readonly cacheClusterEnabled?: boolean;
    /**
     * (experimental) The stage's cache cluster size.
     *
     * @default 0.5
     * @experimental
     */
    readonly cacheClusterSize?: string;
    /**
     * (experimental) The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
     *
     * @default - None.
     * @experimental
     */
    readonly clientCertificateId?: string;
    /**
     * (experimental) A description of the purpose of the stage.
     *
     * @default - No description.
     * @experimental
     */
    readonly description?: string;
    /**
     * (experimental) The version identifier of the API documentation snapshot.
     *
     * @default - No documentation version.
     * @experimental
     */
    readonly documentationVersion?: string;
    /**
     * (experimental) A map that defines the stage variables.
     *
     * Variable names must consist of
     * alphanumeric characters, and the values must match the following regular
     * expression: [A-Za-z0-9-._~:/?#&amp;=,]+.
     *
     * @default - No stage variables.
     * @experimental
     */
    readonly variables?: {
        [key: string]: string;
    };
    /**
     * (experimental) Method deployment options for specific resources/methods.
     *
     * These will
     * override common options defined in `StageOptions#methodOptions`.
     *
     * @default - Common options will be used.
     * @experimental
     */
    readonly methodOptions?: {
        [path: string]: MethodDeploymentOptions;
    };
}
/**
 * @experimental
 */
export interface StageProps extends StageOptions {
    /**
     * (experimental) The deployment that this stage points to [disable-awslint:ref-via-interface].
     *
     * @experimental
     */
    readonly deployment: Deployment;
}
/**
 * @experimental
 */
export declare enum MethodLoggingLevel {
    /**
     * @experimental
     */
    OFF = "OFF",
    /**
     * @experimental
     */
    ERROR = "ERROR",
    /**
     * @experimental
     */
    INFO = "INFO"
}
/**
 * @experimental
 */
export interface MethodDeploymentOptions {
    /**
     * (experimental) Specifies whether Amazon CloudWatch metrics are enabled for this method.
     *
     * @default false
     * @experimental
     */
    readonly metricsEnabled?: boolean;
    /**
     * (experimental) Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
     *
     * @default - Off
     * @experimental
     */
    readonly loggingLevel?: MethodLoggingLevel;
    /**
     * (experimental) Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
     *
     * @default false
     * @experimental
     */
    readonly dataTraceEnabled?: boolean;
    /**
     * (experimental) Specifies the throttling burst limit.
     *
     * The total rate of all requests in your AWS account is limited to 5,000 requests.
     *
     * @default - No additional restriction.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
     * @experimental
     */
    readonly throttlingBurstLimit?: number;
    /**
     * (experimental) Specifies the throttling rate limit.
     *
     * The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).
     *
     * @default - No additional restriction.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
     * @experimental
     */
    readonly throttlingRateLimit?: number;
    /**
     * (experimental) Specifies whether responses should be cached and returned for requests.
     *
     * A
     * cache cluster must be enabled on the stage for responses to be cached.
     *
     * @default - Caching is Disabled.
     * @experimental
     */
    readonly cachingEnabled?: boolean;
    /**
     * (experimental) Specifies the time to live (TTL), in seconds, for cached responses.
     *
     * The
     * higher the TTL, the longer the response will be cached.
     *
     * @default Duration.minutes(5)
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html
     * @experimental
     */
    readonly cacheTtl?: Duration;
    /**
     * (experimental) Indicates whether the cached responses are encrypted.
     *
     * @default false
     * @experimental
     */
    readonly cacheDataEncrypted?: boolean;
}
/**
 * @experimental
 */
export declare class Stage extends Resource implements IStage {
    /**
     * (experimental) Name of this stage.
     *
     * @experimental
     */
    readonly stageName: string;
    /**
     * (experimental) RestApi to which this stage is associated.
     *
     * @experimental
     */
    readonly restApi: IRestApi;
    private enableCacheCluster?;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: StageProps);
    /**
     * (experimental) Returns the invoke URL for a certain path.
     *
     * @param path The resource path.
     * @experimental
     */
    urlForPath(path?: string): string;
    private renderMethodSettings;
}
