import { Resource } from "../../core";
import { Construct } from 'constructs';
import { ApiKeyProps, IApiKey } from './api-key';
import { QuotaSettings, ThrottleSettings, UsagePlanPerApiStage } from './usage-plan';
/**
 * (experimental) RateLimitedApiKey properties.
 *
 * @experimental
 */
export interface RateLimitedApiKeyProps extends ApiKeyProps {
    /**
     * (experimental) API Stages to be associated with the RateLimitedApiKey.
     *
     * @default none
     * @experimental
     */
    readonly apiStages?: UsagePlanPerApiStage[];
    /**
     * (experimental) Number of requests clients can make in a given time period.
     *
     * @default none
     * @experimental
     */
    readonly quota?: QuotaSettings;
    /**
     * (experimental) Overall throttle settings for the API.
     *
     * @default none
     * @experimental
     */
    readonly throttle?: ThrottleSettings;
}
/**
 * (experimental) An API Gateway ApiKey, for which a rate limiting configuration can be specified.
 *
 * @experimental
 * @resource AWS::ApiGateway::ApiKey
 */
export declare class RateLimitedApiKey extends Resource implements IApiKey {
    /**
     * (experimental) The API key ID.
     *
     * @experimental
     */
    readonly keyId: string;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: RateLimitedApiKeyProps);
}
