"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.HttpIntegration = void 0;
const integration_1 = require("../integration");
/**
 * (experimental) You can integrate an API method with an HTTP endpoint using the HTTP proxy integration or the HTTP custom integration,.
 *
 * With the proxy integration, the setup is simple. You only need to set the
 * HTTP method and the HTTP endpoint URI, according to the backend requirements,
 * if you are not concerned with content encoding or caching.
 *
 * With the custom integration, the setup is more involved. In addition to the
 * proxy integration setup steps, you need to specify how the incoming request
 * data is mapped to the integration request and how the resulting integration
 * response data is mapped to the method response.
 *
 * @experimental
 */
class HttpIntegration extends integration_1.Integration {
    /**
     * @experimental
     */
    constructor(url, props = {}) {
        const proxy = props.proxy !== undefined ? props.proxy : true;
        const method = props.httpMethod || 'GET';
        super({
            type: proxy ? integration_1.IntegrationType.HTTP_PROXY : integration_1.IntegrationType.HTTP,
            integrationHttpMethod: method,
            uri: url,
            options: props.options,
        });
    }
}
exports.HttpIntegration = HttpIntegration;
//# sourceMappingURL=data:application/json;base64,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