"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ResponseType = exports.GatewayResponse = void 0;
const core_1 = require("../../core"); // Automatically re-written from '@aws-cdk/core'
const apigateway_generated_1 = require("./apigateway.generated");
/**
 * (experimental) Configure the response received by clients, produced from the API Gateway backend.
 *
 * @experimental
 * @resource AWS::ApiGateway::GatewayResponse
 */
class GatewayResponse extends core_1.Resource {
    /**
     * @experimental
     */
    constructor(scope, id, props) {
        super(scope, id);
        const resource = new apigateway_generated_1.CfnGatewayResponse(this, 'Resource', {
            restApiId: props.restApi.restApiId,
            responseType: props.type.responseType,
            responseParameters: this.buildResponseParameters(props.responseHeaders),
            responseTemplates: props.templates,
            statusCode: props.statusCode,
        });
        this.node.defaultChild = resource;
    }
    buildResponseParameters(responseHeaders) {
        if (!responseHeaders) {
            return undefined;
        }
        const responseParameters = {};
        for (const [header, value] of Object.entries(responseHeaders)) {
            responseParameters[`gatewayresponse.header.${header}`] = value;
        }
        return responseParameters;
    }
}
exports.GatewayResponse = GatewayResponse;
/**
 * (experimental) Supported types of gateway responses.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
 * @experimental
 */
class ResponseType {
    constructor(type) {
        this.responseType = type;
    }
    /**
     * (experimental) A custom response type to suppport future cases.
     *
     * @experimental
     */
    static of(type) {
        return new ResponseType(type.toUpperCase());
    }
}
exports.ResponseType = ResponseType;
/**
 * (experimental) The gateway response for authorization failure.
 *
 * @experimental
 */
ResponseType.ACCESS_DENIED = new ResponseType('ACCESS_DENIED');
/**
 * (experimental) The gateway response for an invalid API configuration.
 *
 * @experimental
 */
ResponseType.API_CONFIGURATION_ERROR = new ResponseType('API_CONFIGURATION_ERROR');
/**
 * (experimental) The gateway response when a custom or Amazon Cognito authorizer failed to authenticate the caller.
 *
 * @experimental
 */
ResponseType.AUTHORIZER_FAILURE = new ResponseType('AUTHORIZER_FAILURE');
/**
 * (experimental) The gateway response for failing to connect to a custom or Amazon Cognito authorizer.
 *
 * @experimental
 */
ResponseType.AUTHORIZER_CONFIGURATION_ERROR = new ResponseType('AUTHORIZER_CONFIGURATION_ERROR');
/**
 * (experimental) The gateway response when the request parameter cannot be validated according to an enabled request validator.
 *
 * @experimental
 */
ResponseType.BAD_REQUEST_PARAMETERS = new ResponseType('BAD_REQUEST_PARAMETERS');
/**
 * (experimental) The gateway response when the request body cannot be validated according to an enabled request validator.
 *
 * @experimental
 */
ResponseType.BAD_REQUEST_BODY = new ResponseType('BAD_REQUEST_BODY');
/**
 * (experimental) The default gateway response for an unspecified response type with the status code of 4XX.
 *
 * @experimental
 */
ResponseType.DEFAULT_4XX = new ResponseType('DEFAULT_4XX');
/**
 * (experimental) The default gateway response for an unspecified response type with a status code of 5XX.
 *
 * @experimental
 */
ResponseType.DEFAULT_5XX = new ResponseType('DEFAULT_5XX');
/**
 * (experimental) The gateway response for an AWS authentication token expired error.
 *
 * @experimental
 */
ResponseType.EXPIRED_TOKEN = new ResponseType('EXPIRED_TOKEN');
/**
 * (experimental) The gateway response for an invalid AWS signature error.
 *
 * @experimental
 */
ResponseType.INVALID_SIGNATURE = new ResponseType('INVALID_SIGNATURE');
/**
 * (experimental) The gateway response for an integration failed error.
 *
 * @experimental
 */
ResponseType.INTEGRATION_FAILURE = new ResponseType('INTEGRATION_FAILURE');
/**
 * (experimental) The gateway response for an integration timed out error.
 *
 * @experimental
 */
ResponseType.INTEGRATION_TIMEOUT = new ResponseType('INTEGRATION_TIMEOUT');
/**
 * (experimental) The gateway response for an invalid API key submitted for a method requiring an API key.
 *
 * @experimental
 */
ResponseType.INVALID_API_KEY = new ResponseType('INVALID_API_KEY');
/**
 * (experimental) The gateway response for a missing authentication token error, including the cases when the client attempts to invoke an unsupported API method or resource.
 *
 * @experimental
 */
ResponseType.MISSING_AUTHENTICATION_TOKEN = new ResponseType('MISSING_AUTHENTICATION_TOKEN');
/**
 * (experimental) The gateway response for the usage plan quota exceeded error.
 *
 * @experimental
 */
ResponseType.QUOTA_EXCEEDED = new ResponseType('QUOTA_EXCEEDED');
/**
 * (experimental) The gateway response for the request too large error.
 *
 * @experimental
 */
ResponseType.REQUEST_TOO_LARGE = new ResponseType('REQUEST_TOO_LARGE');
/**
 * (experimental) The gateway response when API Gateway cannot find the specified resource after an API request passes authentication and authorization.
 *
 * @experimental
 */
ResponseType.RESOURCE_NOT_FOUND = new ResponseType('RESOURCE_NOT_FOUND');
/**
 * (experimental) The gateway response when usage plan, method, stage, or account level throttling limits exceeded.
 *
 * @experimental
 */
ResponseType.THROTTLED = new ResponseType('THROTTLED');
/**
 * (experimental) The gateway response when the custom or Amazon Cognito authorizer failed to authenticate the caller.
 *
 * @experimental
 */
ResponseType.UNAUTHORIZED = new ResponseType('UNAUTHORIZED');
/**
 * (experimental) The gateway response when a payload is of an unsupported media type, if strict passthrough behavior is enabled.
 *
 * @experimental
 */
ResponseType.UNSUPPORTED_MEDIA_TYPE = new ResponseType('UNSUPPORTED_MEDIA_TYPE');
/**
 * (experimental) The gateway response when a request is blocked by AWS WAF.
 *
 * @experimental
 */
ResponseType.WAF_FILTERED = new ResponseType('WAF_FILTERED');
//# sourceMappingURL=data:application/json;base64,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