import { IResource, Resource } from "../../core";
import { Construct } from 'constructs';
import { IRestApi } from './restapi';
/**
 * (experimental) Represents gateway response resource.
 *
 * @experimental
 */
export interface IGatewayResponse extends IResource {
}
/**
 * (experimental) Properties for a new gateway response.
 *
 * @experimental
 */
export interface GatewayResponseProps extends GatewayResponseOptions {
    /**
     * (experimental) Rest api resource to target.
     *
     * @experimental
     */
    readonly restApi: IRestApi;
}
/**
 * (experimental) Options to add gateway response.
 *
 * @experimental
 */
export interface GatewayResponseOptions {
    /**
     * (experimental) Response type to associate with gateway response.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
     * @experimental
     */
    readonly type: ResponseType;
    /**
     * (experimental) Http status code for response.
     *
     * @default - standard http status code for the response type.
     * @experimental
     */
    readonly statusCode?: string;
    /**
     * (experimental) Custom headers parameters for response.
     *
     * @default - no headers
     * @experimental
     */
    readonly responseHeaders?: {
        [key: string]: string;
    };
    /**
     * (experimental) Custom templates to get mapped as response.
     *
     * @default - Response from api will be returned without applying any transformation.
     * @experimental
     */
    readonly templates?: {
        [key: string]: string;
    };
}
/**
 * (experimental) Configure the response received by clients, produced from the API Gateway backend.
 *
 * @experimental
 * @resource AWS::ApiGateway::GatewayResponse
 */
export declare class GatewayResponse extends Resource implements IGatewayResponse {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: GatewayResponseProps);
    private buildResponseParameters;
}
/**
 * (experimental) Supported types of gateway responses.
 *
 * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/supported-gateway-response-types.html
 * @experimental
 */
export declare class ResponseType {
    /**
     * (experimental) The gateway response for authorization failure.
     *
     * @experimental
     */
    static readonly ACCESS_DENIED: ResponseType;
    /**
     * (experimental) The gateway response for an invalid API configuration.
     *
     * @experimental
     */
    static readonly API_CONFIGURATION_ERROR: ResponseType;
    /**
     * (experimental) The gateway response when a custom or Amazon Cognito authorizer failed to authenticate the caller.
     *
     * @experimental
     */
    static readonly AUTHORIZER_FAILURE: ResponseType;
    /**
     * (experimental) The gateway response for failing to connect to a custom or Amazon Cognito authorizer.
     *
     * @experimental
     */
    static readonly AUTHORIZER_CONFIGURATION_ERROR: ResponseType;
    /**
     * (experimental) The gateway response when the request parameter cannot be validated according to an enabled request validator.
     *
     * @experimental
     */
    static readonly BAD_REQUEST_PARAMETERS: ResponseType;
    /**
     * (experimental) The gateway response when the request body cannot be validated according to an enabled request validator.
     *
     * @experimental
     */
    static readonly BAD_REQUEST_BODY: ResponseType;
    /**
     * (experimental) The default gateway response for an unspecified response type with the status code of 4XX.
     *
     * @experimental
     */
    static readonly DEFAULT_4XX: ResponseType;
    /**
     * (experimental) The default gateway response for an unspecified response type with a status code of 5XX.
     *
     * @experimental
     */
    static readonly DEFAULT_5XX: ResponseType;
    /**
     * (experimental) The gateway response for an AWS authentication token expired error.
     *
     * @experimental
     */
    static readonly EXPIRED_TOKEN: ResponseType;
    /**
     * (experimental) The gateway response for an invalid AWS signature error.
     *
     * @experimental
     */
    static readonly INVALID_SIGNATURE: ResponseType;
    /**
     * (experimental) The gateway response for an integration failed error.
     *
     * @experimental
     */
    static readonly INTEGRATION_FAILURE: ResponseType;
    /**
     * (experimental) The gateway response for an integration timed out error.
     *
     * @experimental
     */
    static readonly INTEGRATION_TIMEOUT: ResponseType;
    /**
     * (experimental) The gateway response for an invalid API key submitted for a method requiring an API key.
     *
     * @experimental
     */
    static readonly INVALID_API_KEY: ResponseType;
    /**
     * (experimental) The gateway response for a missing authentication token error, including the cases when the client attempts to invoke an unsupported API method or resource.
     *
     * @experimental
     */
    static readonly MISSING_AUTHENTICATION_TOKEN: ResponseType;
    /**
     * (experimental) The gateway response for the usage plan quota exceeded error.
     *
     * @experimental
     */
    static readonly QUOTA_EXCEEDED: ResponseType;
    /**
     * (experimental) The gateway response for the request too large error.
     *
     * @experimental
     */
    static readonly REQUEST_TOO_LARGE: ResponseType;
    /**
     * (experimental) The gateway response when API Gateway cannot find the specified resource after an API request passes authentication and authorization.
     *
     * @experimental
     */
    static readonly RESOURCE_NOT_FOUND: ResponseType;
    /**
     * (experimental) The gateway response when usage plan, method, stage, or account level throttling limits exceeded.
     *
     * @experimental
     */
    static readonly THROTTLED: ResponseType;
    /**
     * (experimental) The gateway response when the custom or Amazon Cognito authorizer failed to authenticate the caller.
     *
     * @experimental
     */
    static readonly UNAUTHORIZED: ResponseType;
    /**
     * (experimental) The gateway response when a payload is of an unsupported media type, if strict passthrough behavior is enabled.
     *
     * @experimental
     */
    static readonly UNSUPPORTED_MEDIA_TYPE: ResponseType;
    /**
     * (experimental) The gateway response when a request is blocked by AWS WAF.
     *
     * @experimental
     */
    static readonly WAF_FILTERED: ResponseType;
    /**
     * (experimental) A custom response type to suppport future cases.
     *
     * @experimental
     */
    static of(type: string): ResponseType;
    /**
     * (experimental) Valid value of response type.
     *
     * @experimental
     */
    readonly responseType: string;
    private constructor();
}
