import { Resource } from "../../core";
import { Construct } from 'constructs';
import { IDomainName } from './domain-name';
import { IRestApi } from './restapi';
import { Stage } from './stage';
/**
 * @experimental
 */
export interface BasePathMappingOptions {
    /**
     * (experimental) The base path name that callers of the API must provide in the URL after the domain name (e.g. `example.com/base-path`). If you specify this property, it can't be an empty string.
     *
     * @default - map requests from the domain root (e.g. `example.com`). If this
     * is undefined, no additional mappings will be allowed on this domain name.
     * @experimental
     */
    readonly basePath?: string;
    /**
     * (experimental) The Deployment stage of API [disable-awslint:ref-via-interface].
     *
     * @default - map to deploymentStage of restApi otherwise stage needs to pass in URL
     * @experimental
     */
    readonly stage?: Stage;
}
/**
 * @experimental
 */
export interface BasePathMappingProps extends BasePathMappingOptions {
    /**
     * (experimental) The DomainName to associate with this base path mapping.
     *
     * @experimental
     */
    readonly domainName: IDomainName;
    /**
     * (experimental) The RestApi resource to target.
     *
     * @experimental
     */
    readonly restApi: IRestApi;
}
/**
 * (experimental) This resource creates a base path that clients who call your API must use in the invocation URL.
 *
 * Unless you're importing a domain with `DomainName.fromDomainNameAttributes()`,
 * you can use `DomainName.addBasePathMapping()` to define mappings.
 *
 * @experimental
 */
export declare class BasePathMapping extends Resource {
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: BasePathMappingProps);
}
