import { Resource, ResourceProps } from "../../core";
import { Construct } from 'constructs';
import { AuthorizationType } from './method';
/**
 * (experimental) Base class for all custom authorizers.
 *
 * @experimental
 */
export declare abstract class Authorizer extends Resource implements IAuthorizer {
    /**
     * (experimental) Return whether the given object is an Authorizer.
     *
     * @experimental
     */
    static isAuthorizer(x: any): x is Authorizer;
    /**
     * (experimental) The authorizer ID.
     *
     * @experimental
     */
    abstract readonly authorizerId: string;
    /**
     * (experimental) The authorization type of this authorizer.
     *
     * @experimental
     */
    readonly authorizationType?: AuthorizationType;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props?: ResourceProps);
}
/**
 * (experimental) Represents an API Gateway authorizer.
 *
 * @experimental
 */
export interface IAuthorizer {
    /**
     * (experimental) The authorizer ID.
     *
     * @experimental
     * @attribute true
     */
    readonly authorizerId: string;
    /**
     * (experimental) The authorization type of this authorizer.
     *
     * @experimental
     */
    readonly authorizationType?: AuthorizationType;
}
