import * as s3 from "../../aws-s3";
import * as s3_assets from "../../aws-s3-assets";
import * as cdk from "../../core";
/**
 * (experimental) Represents an OpenAPI definition asset.
 *
 * @experimental
 */
export declare abstract class ApiDefinition {
    /**
     * (experimental) Creates an API definition from a specification file in an S3 bucket.
     *
     * @experimental
     */
    static fromBucket(bucket: s3.IBucket, key: string, objectVersion?: string): S3ApiDefinition;
    /**
     * (experimental) Create an API definition from an inline object.
     *
     * The inline object must follow the
     * schema of OpenAPI 2.0 or OpenAPI 3.0
     *
     * @experimental
     * @example
     *
     *   ApiDefinition.fromInline({
     *     openapi: '3.0.2',
     *     paths: {
     *       '/pets': {
     *         get: {
     *           'responses': {
     *             200: {
     *               content: {
     *                 'application/json': {
     *                   schema: {
     *                     $ref: '#/components/schemas/Empty',
     *                   },
     *                 },
     *               },
     *             },
     *           },
     *           'x-amazon-apigateway-integration': {
     *             responses: {
     *               default: {
     *                 statusCode: '200',
     *               },
     *             },
     *             requestTemplates: {
     *               'application/json': '{"statusCode": 200}',
     *             },
     *             passthroughBehavior: 'when_no_match',
     *             type: 'mock',
     *           },
     *         },
     *       },
     *     },
     *     components: {
     *       schemas: {
     *         Empty: {
     *           title: 'Empty Schema',
     *           type: 'object',
     *         },
     *       },
     *     },
     *   });
     */
    static fromInline(definition: any): InlineApiDefinition;
    /**
     * (experimental) Loads the API specification from a local disk asset.
     *
     * @experimental
     */
    static fromAsset(file: string, options?: s3_assets.AssetOptions): AssetApiDefinition;
    /**
     * (experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @param scope The binding scope.
     * @experimental
     */
    abstract bind(scope: cdk.Construct): ApiDefinitionConfig;
}
/**
 * (experimental) S3 location of the API definition file.
 *
 * @experimental
 */
export interface ApiDefinitionS3Location {
    /**
     * (experimental) The S3 bucket.
     *
     * @experimental
     */
    readonly bucket: string;
    /**
     * (experimental) The S3 key.
     *
     * @experimental
     */
    readonly key: string;
    /**
     * (experimental) An optional version.
     *
     * @default - latest version
     * @experimental
     */
    readonly version?: string;
}
/**
 * (experimental) Post-Binding Configuration for a CDK construct.
 *
 * @experimental
 */
export interface ApiDefinitionConfig {
    /**
     * (experimental) The location of the specification in S3 (mutually exclusive with `inlineDefinition`).
     *
     * @default - API definition is not an S3 location
     * @experimental
     */
    readonly s3Location?: ApiDefinitionS3Location;
    /**
     * (experimental) Inline specification (mutually exclusive with `s3Location`).
     *
     * @default - API definition is not defined inline
     * @experimental
     */
    readonly inlineDefinition?: any;
}
/**
 * (experimental) OpenAPI specification from an S3 archive.
 *
 * @experimental
 */
export declare class S3ApiDefinition extends ApiDefinition {
    private key;
    private objectVersion?;
    private bucketName;
    /**
     * @experimental
     */
    constructor(bucket: s3.IBucket, key: string, objectVersion?: string | undefined);
    /**
     * (experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(_scope: cdk.Construct): ApiDefinitionConfig;
}
/**
 * (experimental) OpenAPI specification from an inline JSON object.
 *
 * @experimental
 */
export declare class InlineApiDefinition extends ApiDefinition {
    private definition;
    /**
     * @experimental
     */
    constructor(definition: any);
    /**
     * (experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(_scope: cdk.Construct): ApiDefinitionConfig;
}
/**
 * (experimental) OpenAPI specification from a local file.
 *
 * @experimental
 */
export declare class AssetApiDefinition extends ApiDefinition {
    private readonly path;
    private readonly options;
    private asset?;
    /**
     * @experimental
     */
    constructor(path: string, options?: s3_assets.AssetOptions);
    /**
     * (experimental) Called when the specification is initialized to allow this object to bind to the stack, add resources and have fun.
     *
     * @experimental
     */
    bind(scope: cdk.Construct): ApiDefinitionConfig;
}
