"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AccessLogFormat = exports.AccessLogField = exports.LogGroupLogDestination = void 0;
/**
 * (experimental) Use CloudWatch Logs as a custom access log destination for API Gateway.
 *
 * @experimental
 */
class LogGroupLogDestination {
    /**
     * @experimental
     */
    constructor(logGroup) {
        this.logGroup = logGroup;
    }
    /**
     * (experimental) Binds this destination to the CloudWatch Logs.
     *
     * @experimental
     */
    bind(_stage) {
        return {
            destinationArn: this.logGroup.logGroupArn,
        };
    }
}
exports.LogGroupLogDestination = LogGroupLogDestination;
/**
 * (experimental) $context variables that can be used to customize access log pattern.
 *
 * @experimental
 */
class AccessLogField {
    /**
     * (experimental) The API owner's AWS account ID.
     *
     * @experimental
     */
    static contextAccountId() {
        return '$context.identity.accountId';
    }
    /**
     * (experimental) The identifier API Gateway assigns to your API.
     *
     * @experimental
     */
    static contextApiId() {
        return '$context.apiId';
    }
    /**
     * (experimental) A property of the claims returned from the Amazon Cognito user pool after the method caller is successfully authenticated.
     *
     * @param property A property key of the claims.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-integrate-with-cognito.html
     * @experimental
     */
    static contextAuthorizerClaims(property) {
        return `$context.authorizer.claims.${property}`;
    }
    /**
     * (experimental) The principal user identification associated with the token sent by the client and returned from an API Gateway Lambda authorizer (formerly known as a custom authorizer).
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
     * @experimental
     */
    static contextAuthorizerPrincipalId() {
        return '$context.authorizer.principalId';
    }
    /**
     * (experimental) The stringified value of the specified key-value pair of the `context` map returned from an API Gateway Lambda authorizer function.
     *
     * @param property key of the context map.
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-use-lambda-authorizer.html
     * @experimental
     */
    static contextAuthorizer(property) {
        return `$context.authorizer.${property}`;
    }
    /**
     * (experimental) The AWS endpoint's request ID.
     *
     * @experimental
     */
    static contextAwsEndpointRequestId() {
        return '$context.awsEndpointRequestId';
    }
    /**
     * (experimental) The full domain name used to invoke the API.
     *
     * This should be the same as the incoming `Host` header.
     *
     * @experimental
     */
    static contextDomainName() {
        return '$context.domainName';
    }
    /**
     * (experimental) The first label of the `$context.domainName`. This is often used as a caller/customer identifier.
     *
     * @experimental
     */
    static contextDomainPrefix() {
        return '$context.domainPrefix';
    }
    /**
     * (experimental) A string containing an API Gateway error message.
     *
     * @experimental
     */
    static contextErrorMessage() {
        return '$context.error.message';
    }
    /**
     * (experimental) The quoted value of $context.error.message, namely "$context.error.message".
     *
     * @experimental
     */
    static contextErrorMessageString() {
        return '$context.error.messageString';
    }
    /**
     * (experimental) A type of GatewayResponse.
     *
     * This variable can only be used for simple variable substitution in a GatewayResponse body-mapping template,
     * which is not processed by the Velocity Template Language engine, and in access logging.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html
     * @experimental
     */
    static contextErrorResponseType() {
        return '$context.error.responseType';
    }
    /**
     * (experimental) A string containing a detailed validation error message.
     *
     * @experimental
     */
    static contextErrorValidationErrorString() {
        return '$context.error.validationErrorString';
    }
    /**
     * (experimental) The extended ID that API Gateway assigns to the API request, which contains more useful information for debugging/troubleshooting.
     *
     * @experimental
     */
    static contextExtendedRequestId() {
        return '$context.extendedRequestId';
    }
    /**
     * (experimental) The HTTP method used.
     *
     * Valid values include: `DELETE`, `GET`, `HEAD`, `OPTIONS`, `PATCH`, `POST`, and `PUT`.
     *
     * @experimental
     */
    static contextHttpMethod() {
        return '$context.httpMethod';
    }
    /**
     * (experimental) The AWS account ID associated with the request.
     *
     * @experimental
     */
    static contextIdentityAccountId() {
        return '$context.identity.accountId';
    }
    /**
     * (experimental) For API methods that require an API key, this variable is the API key associated with the method request.
     *
     * For methods that don't require an API key, this variable is
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-api-usage-plans.html
     * @experimental
     */
    static contextIdentityApiKey() {
        return '$context.identity.apiKey';
    }
    /**
     * (experimental) The API key ID associated with an API request that requires an API key.
     *
     * @experimental
     */
    static contextIdentityApiKeyId() {
        return '$context.identity.apiKeyId';
    }
    /**
     * (experimental) The principal identifier of the caller making the request.
     *
     * @experimental
     */
    static contextIdentityCaller() {
        return '$context.identity.caller';
    }
    /**
     * (experimental) The Amazon Cognito authentication provider used by the caller making the request.
     *
     * Available only if the request was signed with Amazon Cognito credentials.
     *
     * @see https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-identity.html
     * @experimental
     */
    static contextIdentityCognitoAuthenticationProvider() {
        return '$context.identity.cognitoAuthenticationProvider';
    }
    /**
     * (experimental) The Amazon Cognito authentication type of the caller making the request.
     *
     * Available only if the request was signed with Amazon Cognito credentials.
     *
     * @experimental
     */
    static contextIdentityCognitoAuthenticationType() {
        return '$context.identity.cognitoAuthenticationType';
    }
    /**
     * (experimental) The Amazon Cognito identity ID of the caller making the request.
     *
     * Available only if the request was signed with Amazon Cognito credentials.
     *
     * @experimental
     */
    static contextIdentityCognitoIdentityId() {
        return '$context.identity.cognitoIdentityId';
    }
    /**
     * (experimental) The Amazon Cognito identity pool ID of the caller making the request.
     *
     * Available only if the request was signed with Amazon Cognito credentials.
     *
     * @experimental
     */
    static contextIdentityCognitoIdentityPoolId() {
        return '$context.identity.cognitoIdentityPoolId';
    }
    /**
     * (experimental) The AWS organization ID.
     *
     * @experimental
     */
    static contextIdentityPrincipalOrgId() {
        return '$context.identity.principalOrgId';
    }
    /**
     * (experimental) The source IP address of the TCP connection making the request to API Gateway.
     *
     * Warning: You should not trust this value if there is any chance that the `X-Forwarded-For` header could be forged.
     *
     * @experimental
     */
    static contextIdentitySourceIp() {
        return '$context.identity.sourceIp';
    }
    /**
     * (experimental) The principal identifier of the user making the request.
     *
     * Used in Lambda authorizers.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html
     * @experimental
     */
    static contextIdentityUser() {
        return '$context.identity.user';
    }
    /**
     * (experimental) The User-Agent header of the API caller.
     *
     * @experimental
     */
    static contextIdentityUserAgent() {
        return '$context.identity.userAgent';
    }
    /**
     * (experimental) The Amazon Resource Name (ARN) of the effective user identified after authentication.
     *
     * @see https://docs.aws.amazon.com/IAM/latest/UserGuide/id_users.html
     * @experimental
     */
    static contextIdentityUserArn() {
        return '$context.identity.userArn';
    }
    /**
     * (experimental) The request path.
     *
     * For example, for a non-proxy request URL of https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child,
     * this value is /{stage}/root/child.
     *
     * @experimental
     */
    static contextPath() {
        return '$context.path';
    }
    /**
     * (experimental) The request protocol, for example, HTTP/1.1.
     *
     * @experimental
     */
    static contextProtocol() {
        return '$context.protocol';
    }
    /**
     * (experimental) The ID that API Gateway assigns to the API request.
     *
     * @experimental
     */
    static contextRequestId() {
        return '$context.requestId';
    }
    /**
     * (experimental) The request header override.
     *
     * If this parameter is defined, it contains the headers to be used instead of the HTTP Headers that are defined in the Integration Request pane.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     * @experimental
     */
    static contextRequestOverrideHeader(headerName) {
        return `$context.requestOverride.header.${headerName}`;
    }
    /**
     * (experimental) The request path override.
     *
     * If this parameter is defined,
     * it contains the request path to be used instead of the URL Path Parameters that are defined in the Integration Request pane.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     * @experimental
     */
    static contextRequestOverridePath(pathName) {
        return `$context.requestOverride.path.${pathName}`;
    }
    /**
     * (experimental) The request query string override.
     *
     * If this parameter is defined, it contains the request query strings to be used instead
     * of the URL Query String Parameters that are defined in the Integration Request pane.
     *
     * @experimental
     */
    static contextRequestOverrideQuerystring(querystringName) {
        return `$context.requestOverride.querystring.${querystringName}`;
    }
    /**
     * (experimental) The response header override.
     *
     * If this parameter is defined, it contains the header to be returned instead of the Response header
     * that is defined as the Default mapping in the Integration Response pane.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     * @experimental
     */
    static contextResponseOverrideHeader(headerName) {
        return `$context.responseOverride.header.${headerName}`;
    }
    /**
     * (experimental) The response status code override.
     *
     * If this parameter is defined, it contains the status code to be returned instead of the Method response status
     * that is defined as the Default mapping in the Integration Response pane.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-override-request-response-parameters.html
     * @experimental
     */
    static contextResponseOverrideStatus() {
        return '$context.responseOverride.status';
    }
    /**
     * (experimental) The CLF-formatted request time (dd/MMM/yyyy:HH:mm:ss +-hhmm).
     *
     * @experimental
     */
    static contextRequestTime() {
        return '$context.requestTime';
    }
    /**
     * (experimental) The Epoch-formatted request time.
     *
     * @experimental
     */
    static contextRequestTimeEpoch() {
        return '$context.requestTimeEpoch';
    }
    /**
     * (experimental) The identifier that API Gateway assigns to your resource.
     *
     * @experimental
     */
    static contextResourceId() {
        return '$context.resourceId';
    }
    /**
     * (experimental) The path to your resource.
     *
     * For example, for the non-proxy request URI of `https://{rest-api-id.execute-api.{region}.amazonaws.com/{stage}/root/child`,
     * The $context.resourcePath value is `/root/child`.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-create-api-step-by-step.html
     * @experimental
     */
    static contextResourcePath() {
        return '$context.resourcePath';
    }
    /**
     * (experimental) The deployment stage of the API request (for example, `Beta` or `Prod`).
     *
     * @experimental
     */
    static contextStage() {
        return '$context.stage';
    }
    /**
     * (experimental) The response received from AWS WAF: `WAF_ALLOW` or `WAF_BLOCK`.
     *
     * Will not be set if the stage is not associated with a web ACL.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
     * @experimental
     */
    static contextWafResponseCode() {
        return '$context.wafResponseCode';
    }
    /**
     * (experimental) The complete ARN of the web ACL that is used to decide whether to allow or block the request.
     *
     * Will not be set if the stage is not associated with a web ACL.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-control-access-aws-waf.html
     * @experimental
     */
    static contextWebaclArn() {
        return '$context.webaclArn';
    }
    /**
     * (experimental) The trace ID for the X-Ray trace.
     *
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-enabling-xray.html
     * @experimental
     */
    static contextXrayTraceId() {
        return '$context.xrayTraceId';
    }
    /**
     * (experimental) The authorizer latency in ms.
     *
     * @experimental
     */
    static contextAuthorizerIntegrationLatency() {
        return '$context.authorizer.integrationLatency';
    }
    /**
     * (experimental) The integration latency in ms.
     *
     * @experimental
     */
    static contextIntegrationLatency() {
        return '$context.integrationLatency';
    }
    /**
     * (experimental) For Lambda proxy integration, this parameter represents the status code returned from AWS Lambda, not from the backend Lambda function.
     *
     * @experimental
     */
    static contextIntegrationStatus() {
        return '$context.integrationStatus.';
    }
    /**
     * (experimental) The response latency in ms.
     *
     * @experimental
     */
    static contextResponseLatency() {
        return '$context.responseLatency';
    }
    /**
     * (experimental) The response payload length.
     *
     * @experimental
     */
    static contextResponseLength() {
        return '$context.responseLength';
    }
    /**
     * (experimental) The method response status.
     *
     * @experimental
     */
    static contextStatus() {
        return '$context.status';
    }
}
exports.AccessLogField = AccessLogField;
/**
 * (experimental) factory methods for access log format.
 *
 * @experimental
 */
class AccessLogFormat {
    constructor(format) {
        this.format = format;
    }
    /**
     * (experimental) Custom log format.
     *
     * You can create any log format string. You can easily get the $ context variable by using the methods of AccessLogField.
     *
     * @experimental
     * @example
     *
     * custom(JSON.stringify({
     * requestId: AccessLogField.contextRequestId(),
     * sourceIp: AccessLogField.contextIdentitySourceIp(),
     * method: AccessLogFiled.contextHttpMethod(),
     * userContext: {
     * sub: AccessLogField.contextAuthorizerClaims('sub'),
     * email: AccessLogField.contextAuthorizerClaims('email')
     * }
     * }))
     */
    static custom(format) {
        return new AccessLogFormat(format);
    }
    /**
     * (experimental) Generate Common Log Format.
     *
     * @experimental
     */
    static clf() {
        const requester = [AccessLogField.contextIdentitySourceIp(), AccessLogField.contextIdentityCaller(), AccessLogField.contextIdentityUser()].join(' ');
        const requestTime = AccessLogField.contextRequestTime();
        const request = [AccessLogField.contextHttpMethod(), AccessLogField.contextResourcePath(), AccessLogField.contextProtocol()].join(' ');
        const status = [AccessLogField.contextStatus(), AccessLogField.contextResponseLength(), AccessLogField.contextRequestId()].join(' ');
        return new AccessLogFormat(`${requester} [${requestTime}] "${request}" ${status}`);
    }
    /**
     * (experimental) Access log will be produced in the JSON format with a set of fields most useful in the access log.
     *
     * All fields are turned on by default with the
     * option to turn off specific fields.
     *
     * @experimental
     */
    static jsonWithStandardFields(fields = {
        ip: true,
        user: true,
        caller: true,
        requestTime: true,
        httpMethod: true,
        resourcePath: true,
        status: true,
        protocol: true,
        responseLength: true,
    }) {
        return this.custom(JSON.stringify({
            requestId: AccessLogField.contextRequestId(),
            ip: fields.ip ? AccessLogField.contextIdentitySourceIp() : undefined,
            user: fields.user ? AccessLogField.contextIdentityUser() : undefined,
            caller: fields.caller ? AccessLogField.contextIdentityCaller() : undefined,
            requestTime: fields.requestTime ? AccessLogField.contextRequestTime() : undefined,
            httpMethod: fields.httpMethod ? AccessLogField.contextHttpMethod() : undefined,
            resourcePath: fields.resourcePath ? AccessLogField.contextResourcePath() : undefined,
            status: fields.status ? AccessLogField.contextStatus() : undefined,
            protocol: fields.protocol ? AccessLogField.contextProtocol() : undefined,
            responseLength: fields.responseLength ? AccessLogField.contextResponseLength() : undefined,
        }));
    }
    /**
     * (experimental) Output a format string to be used with CloudFormation.
     *
     * @experimental
     */
    toString() {
        return this.format;
    }
}
exports.AccessLogFormat = AccessLogFormat;
//# sourceMappingURL=data:application/json;base64,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