import { Resource, IResolvable } from "../../core";
import { Construct } from 'constructs';
import { IApp } from './app';
import { IBranch } from './branch';
/**
 * (experimental) Options to add a domain to an application.
 *
 * @experimental
 */
export interface DomainOptions {
    /**
     * (experimental) The name of the domain.
     *
     * @default - the construct's id
     * @experimental
     */
    readonly domainName?: string;
    /**
     * (experimental) Subdomains.
     *
     * @default - use `addSubDomain()` to add subdomains
     * @experimental
     */
    readonly subDomains?: SubDomain[];
}
/**
 * (experimental) Properties for a Domain.
 *
 * @experimental
 */
export interface DomainProps extends DomainOptions {
    /**
     * (experimental) The application to which the domain must be connected.
     *
     * @experimental
     */
    readonly app: IApp;
}
/**
 * (experimental) An Amplify Console domain.
 *
 * @experimental
 */
export declare class Domain extends Resource {
    /**
     * (experimental) The ARN of the domain.
     *
     * @experimental
     * @attribute true
     */
    readonly arn: string;
    /**
     * (experimental) The DNS Record for certificate verification.
     *
     * @experimental
     * @attribute true
     */
    readonly certificateRecord: string;
    /**
     * (experimental) The name of the domain.
     *
     * @experimental
     * @attribute true
     */
    readonly domainName: string;
    /**
     * (experimental) The status of the domain association.
     *
     * @experimental
     * @attribute true
     */
    readonly domainStatus: string;
    /**
     * (experimental) The reason for the current status of the domain.
     *
     * @experimental
     * @attribute true
     */
    readonly statusReason: string;
    /**
     * (experimental) Branch patterns for the automatically created subdomain.
     *
     * @experimental
     * @attribute true
     */
    readonly domainAutoSubDomainCreationPatterns: string[];
    /**
     * (experimental) The IAM service role for the subdomain.
     *
     * @experimental
     * @attribute true
     */
    readonly domainAutoSubDomainIamRole: string;
    /**
     * (experimental) Specifies whether the automated creation of subdomains for branches is enabled.
     *
     * @experimental
     * @attribute true
     */
    readonly domainEnableAutoSubDomain: IResolvable;
    private readonly subDomains;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: DomainProps);
    /**
     * (experimental) Maps a branch to a sub domain.
     *
     * @param branch The branch.
     * @param prefix The prefix.
     * @experimental
     */
    mapSubDomain(branch: IBranch, prefix?: string): this;
    /**
     * (experimental) Maps a branch to the domain root.
     *
     * @experimental
     */
    mapRoot(branch: IBranch): this;
    /**
     * (experimental) Validate the current construct.
     *
     * This method can be implemented by derived constructs in order to perform
     * validation logic. It is called on all constructs before synthesis.
     *
     * @experimental
     */
    protected validate(): string[];
    private renderSubDomainSettings;
}
/**
 * (experimental) Sub domain settings.
 *
 * @experimental
 */
export interface SubDomain {
    /**
     * (experimental) The branch.
     *
     * @experimental
     */
    readonly branch: IBranch;
    /**
     * (experimental) The prefix.
     *
     * Use '' to map to the root of the domain
     *
     * @default - the branch name
     * @experimental
     */
    readonly prefix?: string;
}
