import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::Amplify::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 * @external
 */
export interface CfnAppProps {
    /**
     * `AWS::Amplify::App.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name
     * @external
     */
    readonly name: string;
    /**
     * `AWS::Amplify::App.AccessToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken
     * @external
     */
    readonly accessToken?: string;
    /**
     * `AWS::Amplify::App.AutoBranchCreationConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig
     * @external
     */
    readonly autoBranchCreationConfig?: CfnApp.AutoBranchCreationConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.BasicAuthConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig
     * @external
     */
    readonly basicAuthConfig?: CfnApp.BasicAuthConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.BuildSpec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec
     * @external
     */
    readonly buildSpec?: string;
    /**
     * `AWS::Amplify::App.CustomRules`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules
     * @external
     */
    readonly customRules?: Array<CfnApp.CustomRuleProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Amplify::App.EnableBranchAutoDeletion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion
     * @external
     */
    readonly enableBranchAutoDeletion?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.EnvironmentVariables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables
     * @external
     */
    readonly environmentVariables?: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::App.IAMServiceRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole
     * @external
     */
    readonly iamServiceRole?: string;
    /**
     * `AWS::Amplify::App.OauthToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken
     * @external
     */
    readonly oauthToken?: string;
    /**
     * `AWS::Amplify::App.Repository`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository
     * @external
     */
    readonly repository?: string;
    /**
     * `AWS::Amplify::App.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 * @external
 * @cloudformationResource AWS::Amplify::App
 */
export declare class CfnApp extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::App";
    /**
     * @external
     * @cloudformationAttribute AppId
     */
    readonly attrAppId: string;
    /**
     * @external
     * @cloudformationAttribute AppName
     */
    readonly attrAppName: string;
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute DefaultDomain
     */
    readonly attrDefaultDomain: string;
    /**
     * `AWS::Amplify::App.Name`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-name
     * @external
     */
    name: string;
    /**
     * `AWS::Amplify::App.AccessToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-accesstoken
     * @external
     */
    accessToken: string | undefined;
    /**
     * `AWS::Amplify::App.AutoBranchCreationConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-autobranchcreationconfig
     * @external
     */
    autoBranchCreationConfig: CfnApp.AutoBranchCreationConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.BasicAuthConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-basicauthconfig
     * @external
     */
    basicAuthConfig: CfnApp.BasicAuthConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.BuildSpec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-buildspec
     * @external
     */
    buildSpec: string | undefined;
    /**
     * `AWS::Amplify::App.CustomRules`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-customrules
     * @external
     */
    customRules: Array<CfnApp.CustomRuleProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Amplify::App.EnableBranchAutoDeletion`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-enablebranchautodeletion
     * @external
     */
    enableBranchAutoDeletion: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.EnvironmentVariables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-environmentvariables
     * @external
     */
    environmentVariables: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::App.IAMServiceRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-iamservicerole
     * @external
     */
    iamServiceRole: string | undefined;
    /**
     * `AWS::Amplify::App.OauthToken`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-oauthtoken
     * @external
     */
    oauthToken: string | undefined;
    /**
     * `AWS::Amplify::App.Repository`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-repository
     * @external
     */
    repository: string | undefined;
    /**
     * `AWS::Amplify::App.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html#cfn-amplify-app-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Amplify::App`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnAppProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 * @external
 * @cloudformationResource AWS::Amplify::App
 */
export declare namespace CfnApp {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html
     * @external
     */
    interface AutoBranchCreationConfigProperty {
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.AutoBranchCreationPatterns`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-autobranchcreationpatterns
         * @external
         */
        readonly autoBranchCreationPatterns?: string[];
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.BasicAuthConfig`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-basicauthconfig
         * @external
         */
        readonly basicAuthConfig?: CfnApp.BasicAuthConfigProperty | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.BuildSpec`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-buildspec
         * @external
         */
        readonly buildSpec?: string;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnableAutoBranchCreation`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobranchcreation
         * @external
         */
        readonly enableAutoBranchCreation?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnableAutoBuild`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableautobuild
         * @external
         */
        readonly enableAutoBuild?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnablePerformanceMode`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enableperformancemode
         * @external
         */
        readonly enablePerformanceMode?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnablePullRequestPreview`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-enablepullrequestpreview
         * @external
         */
        readonly enablePullRequestPreview?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.EnvironmentVariables`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-environmentvariables
         * @external
         */
        readonly environmentVariables?: Array<CfnApp.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.PullRequestEnvironmentName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-pullrequestenvironmentname
         * @external
         */
        readonly pullRequestEnvironmentName?: string;
        /**
         * `CfnApp.AutoBranchCreationConfigProperty.Stage`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-autobranchcreationconfig.html#cfn-amplify-app-autobranchcreationconfig-stage
         * @external
         */
        readonly stage?: string;
    }
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 * @external
 * @cloudformationResource AWS::Amplify::App
 */
export declare namespace CfnApp {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html
     * @external
     */
    interface BasicAuthConfigProperty {
        /**
         * `CfnApp.BasicAuthConfigProperty.EnableBasicAuth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-enablebasicauth
         * @external
         */
        readonly enableBasicAuth?: boolean | cdk.IResolvable;
        /**
         * `CfnApp.BasicAuthConfigProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-password
         * @external
         */
        readonly password?: string;
        /**
         * `CfnApp.BasicAuthConfigProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-basicauthconfig.html#cfn-amplify-app-basicauthconfig-username
         * @external
         */
        readonly username?: string;
    }
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 * @external
 * @cloudformationResource AWS::Amplify::App
 */
export declare namespace CfnApp {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html
     * @external
     */
    interface CustomRuleProperty {
        /**
         * `CfnApp.CustomRuleProperty.Condition`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-condition
         * @external
         */
        readonly condition?: string;
        /**
         * `CfnApp.CustomRuleProperty.Source`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-source
         * @external
         */
        readonly source: string;
        /**
         * `CfnApp.CustomRuleProperty.Status`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-status
         * @external
         */
        readonly status?: string;
        /**
         * `CfnApp.CustomRuleProperty.Target`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-customrule.html#cfn-amplify-app-customrule-target
         * @external
         */
        readonly target: string;
    }
}
/**
 * A CloudFormation `AWS::Amplify::App`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-app.html
 * @external
 * @cloudformationResource AWS::Amplify::App
 */
export declare namespace CfnApp {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html
     * @external
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnApp.EnvironmentVariableProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnApp.EnvironmentVariableProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-app-environmentvariable.html#cfn-amplify-app-environmentvariable-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Amplify::Branch`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 * @external
 */
export interface CfnBranchProps {
    /**
     * `AWS::Amplify::Branch.AppId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-appid
     * @external
     */
    readonly appId: string;
    /**
     * `AWS::Amplify::Branch.BranchName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-branchname
     * @external
     */
    readonly branchName: string;
    /**
     * `AWS::Amplify::Branch.BasicAuthConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-basicauthconfig
     * @external
     */
    readonly basicAuthConfig?: CfnBranch.BasicAuthConfigProperty | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.BuildSpec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-buildspec
     * @external
     */
    readonly buildSpec?: string;
    /**
     * `AWS::Amplify::Branch.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-description
     * @external
     */
    readonly description?: string;
    /**
     * `AWS::Amplify::Branch.EnableAutoBuild`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableautobuild
     * @external
     */
    readonly enableAutoBuild?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.EnablePerformanceMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableperformancemode
     * @external
     */
    readonly enablePerformanceMode?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.EnablePullRequestPreview`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enablepullrequestpreview
     * @external
     */
    readonly enablePullRequestPreview?: boolean | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.EnvironmentVariables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-environmentvariables
     * @external
     */
    readonly environmentVariables?: Array<CfnBranch.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Branch.PullRequestEnvironmentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-pullrequestenvironmentname
     * @external
     */
    readonly pullRequestEnvironmentName?: string;
    /**
     * `AWS::Amplify::Branch.Stage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-stage
     * @external
     */
    readonly stage?: string;
    /**
     * `AWS::Amplify::Branch.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::Amplify::Branch`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 * @external
 * @cloudformationResource AWS::Amplify::Branch
 */
export declare class CfnBranch extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::Branch";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute BranchName
     */
    readonly attrBranchName: string;
    /**
     * `AWS::Amplify::Branch.AppId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-appid
     * @external
     */
    appId: string;
    /**
     * `AWS::Amplify::Branch.BranchName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-branchname
     * @external
     */
    branchName: string;
    /**
     * `AWS::Amplify::Branch.BasicAuthConfig`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-basicauthconfig
     * @external
     */
    basicAuthConfig: CfnBranch.BasicAuthConfigProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.BuildSpec`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-buildspec
     * @external
     */
    buildSpec: string | undefined;
    /**
     * `AWS::Amplify::Branch.Description`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-description
     * @external
     */
    description: string | undefined;
    /**
     * `AWS::Amplify::Branch.EnableAutoBuild`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableautobuild
     * @external
     */
    enableAutoBuild: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.EnablePerformanceMode`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enableperformancemode
     * @external
     */
    enablePerformanceMode: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.EnablePullRequestPreview`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-enablepullrequestpreview
     * @external
     */
    enablePullRequestPreview: boolean | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.EnvironmentVariables`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-environmentvariables
     * @external
     */
    environmentVariables: Array<CfnBranch.EnvironmentVariableProperty | cdk.IResolvable> | cdk.IResolvable | undefined;
    /**
     * `AWS::Amplify::Branch.PullRequestEnvironmentName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-pullrequestenvironmentname
     * @external
     */
    pullRequestEnvironmentName: string | undefined;
    /**
     * `AWS::Amplify::Branch.Stage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-stage
     * @external
     */
    stage: string | undefined;
    /**
     * `AWS::Amplify::Branch.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html#cfn-amplify-branch-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::Amplify::Branch`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnBranchProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Amplify::Branch`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 * @external
 * @cloudformationResource AWS::Amplify::Branch
 */
export declare namespace CfnBranch {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html
     * @external
     */
    interface BasicAuthConfigProperty {
        /**
         * `CfnBranch.BasicAuthConfigProperty.EnableBasicAuth`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-enablebasicauth
         * @external
         */
        readonly enableBasicAuth?: boolean | cdk.IResolvable;
        /**
         * `CfnBranch.BasicAuthConfigProperty.Password`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-password
         * @external
         */
        readonly password: string;
        /**
         * `CfnBranch.BasicAuthConfigProperty.Username`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-basicauthconfig.html#cfn-amplify-branch-basicauthconfig-username
         * @external
         */
        readonly username: string;
    }
}
/**
 * A CloudFormation `AWS::Amplify::Branch`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-branch.html
 * @external
 * @cloudformationResource AWS::Amplify::Branch
 */
export declare namespace CfnBranch {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html
     * @external
     */
    interface EnvironmentVariableProperty {
        /**
         * `CfnBranch.EnvironmentVariableProperty.Name`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html#cfn-amplify-branch-environmentvariable-name
         * @external
         */
        readonly name: string;
        /**
         * `CfnBranch.EnvironmentVariableProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-branch-environmentvariable.html#cfn-amplify-branch-environmentvariable-value
         * @external
         */
        readonly value: string;
    }
}
/**
 * Properties for defining a `AWS::Amplify::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html
 * @external
 */
export interface CfnDomainProps {
    /**
     * `AWS::Amplify::Domain.AppId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid
     * @external
     */
    readonly appId: string;
    /**
     * `AWS::Amplify::Domain.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname
     * @external
     */
    readonly domainName: string;
    /**
     * `AWS::Amplify::Domain.SubDomainSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings
     * @external
     */
    readonly subDomainSettings: Array<CfnDomain.SubDomainSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainCreationPatterns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns
     * @external
     */
    readonly autoSubDomainCreationPatterns?: string[];
    /**
     * `AWS::Amplify::Domain.AutoSubDomainIAMRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole
     * @external
     */
    readonly autoSubDomainIamRole?: string;
    /**
     * `AWS::Amplify::Domain.EnableAutoSubDomain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain
     * @external
     */
    readonly enableAutoSubDomain?: boolean | cdk.IResolvable;
}
/**
 * A CloudFormation `AWS::Amplify::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html
 * @external
 * @cloudformationResource AWS::Amplify::Domain
 */
export declare class CfnDomain extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::Amplify::Domain";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute AutoSubDomainCreationPatterns
     */
    readonly attrAutoSubDomainCreationPatterns: string[];
    /**
     * @external
     * @cloudformationAttribute AutoSubDomainIAMRole
     */
    readonly attrAutoSubDomainIamRole: string;
    /**
     * @external
     * @cloudformationAttribute CertificateRecord
     */
    readonly attrCertificateRecord: string;
    /**
     * @external
     * @cloudformationAttribute DomainName
     */
    readonly attrDomainName: string;
    /**
     * @external
     * @cloudformationAttribute DomainStatus
     */
    readonly attrDomainStatus: string;
    /**
     * @external
     * @cloudformationAttribute EnableAutoSubDomain
     */
    readonly attrEnableAutoSubDomain: cdk.IResolvable;
    /**
     * @external
     * @cloudformationAttribute StatusReason
     */
    readonly attrStatusReason: string;
    /**
     * `AWS::Amplify::Domain.AppId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid
     * @external
     */
    appId: string;
    /**
     * `AWS::Amplify::Domain.DomainName`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname
     * @external
     */
    domainName: string;
    /**
     * `AWS::Amplify::Domain.SubDomainSettings`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings
     * @external
     */
    subDomainSettings: Array<CfnDomain.SubDomainSettingProperty | cdk.IResolvable> | cdk.IResolvable;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainCreationPatterns`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns
     * @external
     */
    autoSubDomainCreationPatterns: string[] | undefined;
    /**
     * `AWS::Amplify::Domain.AutoSubDomainIAMRole`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole
     * @external
     */
    autoSubDomainIamRole: string | undefined;
    /**
     * `AWS::Amplify::Domain.EnableAutoSubDomain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain
     * @external
     */
    enableAutoSubDomain: boolean | cdk.IResolvable | undefined;
    /**
     * Create a new `AWS::Amplify::Domain`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnDomainProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::Amplify::Domain`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html
 * @external
 * @cloudformationResource AWS::Amplify::Domain
 */
export declare namespace CfnDomain {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html
     * @external
     */
    interface SubDomainSettingProperty {
        /**
         * `CfnDomain.SubDomainSettingProperty.BranchName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-branchname
         * @external
         */
        readonly branchName: string;
        /**
         * `CfnDomain.SubDomainSettingProperty.Prefix`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-amplify-domain-subdomainsetting.html#cfn-amplify-domain-subdomainsetting-prefix
         * @external
         */
        readonly prefix: string;
    }
}
