import * as cdk from "../../core";
/**
 * Properties for defining a `AWS::ACMPCA::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 * @external
 */
export interface CfnCertificateProps {
    /**
     * `AWS::ACMPCA::Certificate.CertificateAuthorityArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificateauthorityarn
     * @external
     */
    readonly certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateSigningRequest`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificatesigningrequest
     * @external
     */
    readonly certificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::Certificate.SigningAlgorithm`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-signingalgorithm
     * @external
     */
    readonly signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::Certificate.Validity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-validity
     * @external
     */
    readonly validity: CfnCertificate.ValidityProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::Certificate.TemplateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-templatearn
     * @external
     */
    readonly templateArn?: string;
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 */
export declare class CfnCertificate extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::Certificate";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute Certificate
     */
    readonly attrCertificate: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateAuthorityArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificateauthorityarn
     * @external
     */
    certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::Certificate.CertificateSigningRequest`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-certificatesigningrequest
     * @external
     */
    certificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::Certificate.SigningAlgorithm`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-signingalgorithm
     * @external
     */
    signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::Certificate.Validity`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-validity
     * @external
     */
    validity: CfnCertificate.ValidityProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::Certificate.TemplateArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html#cfn-acmpca-certificate-templatearn
     * @external
     */
    templateArn: string | undefined;
    /**
     * Create a new `AWS::ACMPCA::Certificate`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ACMPCA::Certificate`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificate.html
 * @external
 * @cloudformationResource AWS::ACMPCA::Certificate
 */
export declare namespace CfnCertificate {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html
     * @external
     */
    interface ValidityProperty {
        /**
         * `CfnCertificate.ValidityProperty.Type`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html#cfn-acmpca-certificate-validity-type
         * @external
         */
        readonly type: string;
        /**
         * `CfnCertificate.ValidityProperty.Value`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificate-validity.html#cfn-acmpca-certificate-validity-value
         * @external
         */
        readonly value: number;
    }
}
/**
 * Properties for defining a `AWS::ACMPCA::CertificateAuthority`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 * @external
 */
export interface CfnCertificateAuthorityProps {
    /**
     * `AWS::ACMPCA::CertificateAuthority.KeyAlgorithm`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keyalgorithm
     * @external
     */
    readonly keyAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.SigningAlgorithm`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-signingalgorithm
     * @external
     */
    readonly signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Subject`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-subject
     * @external
     */
    readonly subject: CfnCertificateAuthority.SubjectProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-type
     * @external
     */
    readonly type: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.RevocationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-revocationconfiguration
     * @external
     */
    readonly revocationConfiguration?: CfnCertificateAuthority.RevocationConfigurationProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-tags
     * @external
     */
    readonly tags?: cdk.CfnTag[];
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 */
export declare class CfnCertificateAuthority extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::CertificateAuthority";
    /**
     * @external
     * @cloudformationAttribute Arn
     */
    readonly attrArn: string;
    /**
     * @external
     * @cloudformationAttribute CertificateSigningRequest
     */
    readonly attrCertificateSigningRequest: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.KeyAlgorithm`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-keyalgorithm
     * @external
     */
    keyAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.SigningAlgorithm`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-signingalgorithm
     * @external
     */
    signingAlgorithm: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Subject`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-subject
     * @external
     */
    subject: CfnCertificateAuthority.SubjectProperty | cdk.IResolvable;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Type`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-type
     * @external
     */
    type: string;
    /**
     * `AWS::ACMPCA::CertificateAuthority.RevocationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-revocationconfiguration
     * @external
     */
    revocationConfiguration: CfnCertificateAuthority.RevocationConfigurationProperty | cdk.IResolvable | undefined;
    /**
     * `AWS::ACMPCA::CertificateAuthority.Tags`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html#cfn-acmpca-certificateauthority-tags
     * @external
     */
    readonly tags: cdk.TagManager;
    /**
     * Create a new `AWS::ACMPCA::CertificateAuthority`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateAuthorityProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html
     * @external
     */
    interface CrlConfigurationProperty {
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.CustomCname`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-customcname
         * @external
         */
        readonly customCname?: string;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.Enabled`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-enabled
         * @external
         */
        readonly enabled?: boolean | cdk.IResolvable;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.ExpirationInDays`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-expirationindays
         * @external
         */
        readonly expirationInDays?: number;
        /**
         * `CfnCertificateAuthority.CrlConfigurationProperty.S3BucketName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-crlconfiguration.html#cfn-acmpca-certificateauthority-crlconfiguration-s3bucketname
         * @external
         */
        readonly s3BucketName?: string;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-revocationconfiguration.html
     * @external
     */
    interface RevocationConfigurationProperty {
        /**
         * `CfnCertificateAuthority.RevocationConfigurationProperty.CrlConfiguration`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-revocationconfiguration.html#cfn-acmpca-certificateauthority-revocationconfiguration-crlconfiguration
         * @external
         */
        readonly crlConfiguration?: CfnCertificateAuthority.CrlConfigurationProperty | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthority`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthority.html
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthority
 */
export declare namespace CfnCertificateAuthority {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html
     * @external
     */
    interface SubjectProperty {
        /**
         * `CfnCertificateAuthority.SubjectProperty.CommonName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-commonname
         * @external
         */
        readonly commonName?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Country`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-country
         * @external
         */
        readonly country?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.DistinguishedNameQualifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-distinguishednamequalifier
         * @external
         */
        readonly distinguishedNameQualifier?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.GenerationQualifier`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-generationqualifier
         * @external
         */
        readonly generationQualifier?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.GivenName`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-givenname
         * @external
         */
        readonly givenName?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Initials`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-initials
         * @external
         */
        readonly initials?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Locality`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-locality
         * @external
         */
        readonly locality?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Organization`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-organization
         * @external
         */
        readonly organization?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.OrganizationalUnit`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-organizationalunit
         * @external
         */
        readonly organizationalUnit?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Pseudonym`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-pseudonym
         * @external
         */
        readonly pseudonym?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.SerialNumber`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-serialnumber
         * @external
         */
        readonly serialNumber?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.State`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-state
         * @external
         */
        readonly state?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Surname`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-surname
         * @external
         */
        readonly surname?: string;
        /**
         * `CfnCertificateAuthority.SubjectProperty.Title`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-acmpca-certificateauthority-subject.html#cfn-acmpca-certificateauthority-subject-title
         * @external
         */
        readonly title?: string;
    }
}
/**
 * Properties for defining a `AWS::ACMPCA::CertificateAuthorityActivation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html
 * @external
 */
export interface CfnCertificateAuthorityActivationProps {
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificate
     * @external
     */
    readonly certificate: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateAuthorityArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificateauthorityarn
     * @external
     */
    readonly certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateChain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificatechain
     * @external
     */
    readonly certificateChain?: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-status
     * @external
     */
    readonly status?: string;
}
/**
 * A CloudFormation `AWS::ACMPCA::CertificateAuthorityActivation`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html
 * @external
 * @cloudformationResource AWS::ACMPCA::CertificateAuthorityActivation
 */
export declare class CfnCertificateAuthorityActivation extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "AWS::ACMPCA::CertificateAuthorityActivation";
    /**
     * @external
     * @cloudformationAttribute CompleteCertificateChain
     */
    readonly attrCompleteCertificateChain: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Certificate`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificate
     * @external
     */
    certificate: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateAuthorityArn`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificateauthorityarn
     * @external
     */
    certificateAuthorityArn: string;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.CertificateChain`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-certificatechain
     * @external
     */
    certificateChain: string | undefined;
    /**
     * `AWS::ACMPCA::CertificateAuthorityActivation.Status`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-acmpca-certificateauthorityactivation.html#cfn-acmpca-certificateauthorityactivation-status
     * @external
     */
    status: string | undefined;
    /**
     * Create a new `AWS::ACMPCA::CertificateAuthorityActivation`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnCertificateAuthorityActivationProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
