import * as cfn from "../../aws-cloudformation";
import * as codepipeline from "../../aws-codepipeline";
import * as events from "../../aws-events";
import * as iam from "../../aws-iam";
import * as cdk from "../../core";
/**
 * @experimental
 */
export interface PipelineDeployStackActionProps {
    /**
     * (experimental) The CDK stack to be deployed.
     *
     * @experimental
     */
    readonly stack: cdk.Stack;
    /**
     * (experimental) The CodePipeline artifact that holds the synthesized app, which is the contents of the ``<directory>`` when running ``cdk synth -o <directory>``.
     *
     * @experimental
     */
    readonly input: codepipeline.Artifact;
    /**
     * (experimental) The name to use when creating a ChangeSet for the stack.
     *
     * @default CDK-CodePipeline-ChangeSet
     * @experimental
     */
    readonly changeSetName?: string;
    /**
     * (experimental) The runOrder for the CodePipeline action creating the ChangeSet.
     *
     * @default 1
     * @experimental
     */
    readonly createChangeSetRunOrder?: number;
    /**
     * (experimental) The name of the CodePipeline action creating the ChangeSet.
     *
     * @default 'ChangeSet'
     * @experimental
     */
    readonly createChangeSetActionName?: string;
    /**
     * (experimental) The runOrder for the CodePipeline action executing the ChangeSet.
     *
     * @default ``createChangeSetRunOrder + 1``
     * @experimental
     */
    readonly executeChangeSetRunOrder?: number;
    /**
     * (experimental) The name of the CodePipeline action creating the ChangeSet.
     *
     * @default 'Execute'
     * @experimental
     */
    readonly executeChangeSetActionName?: string;
    /**
     * (experimental) IAM role to assume when deploying changes.
     *
     * If not specified, a fresh role is created. The role is created with zero
     * permissions unless `adminPermissions` is true, in which case the role will have
     * admin permissions.
     *
     * @default A fresh role with admin or no permissions (depending on the value of `adminPermissions`).
     * @experimental
     */
    readonly role?: iam.IRole;
    /**
     * (experimental) Acknowledge certain changes made as part of deployment.
     *
     * For stacks that contain certain resources, explicit acknowledgement that AWS CloudFormation
     * might create or update those resources. For example, you must specify AnonymousIAM if your
     * stack template contains AWS Identity and Access Management (IAM) resources. For more
     * information
     *
     * @default [AnonymousIAM, AutoExpand], unless `adminPermissions` is true
     * @see https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-iam-template.html#using-iam-capabilities
     * @experimental
     */
    readonly capabilities?: cfn.CloudFormationCapabilities[];
    /**
     * (experimental) Whether to grant admin permissions to CloudFormation while deploying this template.
     *
     * Setting this to `true` affects the defaults for `role` and `capabilities`, if you
     * don't specify any alternatives.
     *
     * The default role that will be created for you will have admin (i.e., `*`)
     * permissions on all resources, and the deployment will have named IAM
     * capabilities (i.e., able to create all IAM resources).
     *
     * This is a shorthand that you can use if you fully trust the templates that
     * are deployed in this pipeline. If you want more fine-grained permissions,
     * use `addToRolePolicy` and `capabilities` to control what the CloudFormation
     * deployment is allowed to do.
     *
     * @experimental
     */
    readonly adminPermissions: boolean;
}
/**
 * (experimental) A class to deploy a stack that is part of a CDK App, using CodePipeline.
 *
 * This composite Action takes care of preparing and executing a CloudFormation ChangeSet.
 *
 * It currently does *not* support stacks that make use of ``Asset``s, and
 * requires the deployed stack is in the same account and region where the
 * CodePipeline is hosted.
 *
 * @experimental
 */
export declare class PipelineDeployStackAction implements codepipeline.IAction {
    /**
     * The role used by CloudFormation for the deploy action
     */
    private _deploymentRole?;
    private readonly stack;
    private readonly prepareChangeSetAction;
    private readonly executeChangeSetAction;
    /**
     * @experimental
     */
    constructor(props: PipelineDeployStackActionProps);
    /**
     * @experimental
     */
    bind(scope: cdk.Construct, stage: codepipeline.IStage, options: codepipeline.ActionBindOptions): codepipeline.ActionConfig;
    /**
     * @experimental
     */
    get deploymentRole(): iam.IRole;
    /**
     * (experimental) Add policy statements to the role deploying the stack.
     *
     * This role is passed to CloudFormation and must have the IAM permissions
     * necessary to deploy the stack or you can grant this role `adminPermissions`
     * by using that option during creation. If you do not grant
     * `adminPermissions` you need to identify the proper statements to add to
     * this role based on the CloudFormation Resources in your stack.
     *
     * @experimental
     */
    addToDeploymentRolePolicy(statement: iam.PolicyStatement): void;
    /**
     * @experimental
     */
    onStateChange(name: string, target?: events.IRuleTarget, options?: events.RuleProps): events.Rule;
    /**
     * @experimental
     */
    get actionProperties(): codepipeline.ActionProperties;
}
