import * as cdk from "../../core";
/**
 * Properties for defining a `Alexa::ASK::Skill`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html
 * @external
 */
export interface CfnSkillProps {
    /**
     * `Alexa::ASK::Skill.AuthenticationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-authenticationconfiguration
     * @external
     */
    readonly authenticationConfiguration: CfnSkill.AuthenticationConfigurationProperty | cdk.IResolvable;
    /**
     * `Alexa::ASK::Skill.SkillPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-skillpackage
     * @external
     */
    readonly skillPackage: CfnSkill.SkillPackageProperty | cdk.IResolvable;
    /**
     * `Alexa::ASK::Skill.VendorId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-vendorid
     * @external
     */
    readonly vendorId: string;
}
/**
 * A CloudFormation `Alexa::ASK::Skill`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html
 * @external
 * @cloudformationResource Alexa::ASK::Skill
 */
export declare class CfnSkill extends cdk.CfnResource implements cdk.IInspectable {
    /**
     * The CloudFormation resource type name for this resource class.
     *
     * @external
     */
    static readonly CFN_RESOURCE_TYPE_NAME = "Alexa::ASK::Skill";
    /**
     * `Alexa::ASK::Skill.AuthenticationConfiguration`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-authenticationconfiguration
     * @external
     */
    authenticationConfiguration: CfnSkill.AuthenticationConfigurationProperty | cdk.IResolvable;
    /**
     * `Alexa::ASK::Skill.SkillPackage`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-skillpackage
     * @external
     */
    skillPackage: CfnSkill.SkillPackageProperty | cdk.IResolvable;
    /**
     * `Alexa::ASK::Skill.VendorId`.
     *
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html#cfn-ask-skill-vendorid
     * @external
     */
    vendorId: string;
    /**
     * Create a new `Alexa::ASK::Skill`.
     *
     * @param scope - scope in which this resource is defined.
     * @param id - scoped id of the resource.
     * @param props - resource properties.
     * @external
     */
    constructor(scope: cdk.Construct, id: string, props: CfnSkillProps);
    /**
     * (experimental) Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes.
     * @experimental
     */
    inspect(inspector: cdk.TreeInspector): void;
    /**
     * @external
     */
    protected get cfnProperties(): {
        [key: string]: any;
    };
    /**
     * @external
     */
    protected renderProperties(props: {
        [key: string]: any;
    }): {
        [key: string]: any;
    };
}
/**
 * A CloudFormation `Alexa::ASK::Skill`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html
 * @external
 * @cloudformationResource Alexa::ASK::Skill
 */
export declare namespace CfnSkill {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-authenticationconfiguration.html
     * @external
     */
    interface AuthenticationConfigurationProperty {
        /**
         * `CfnSkill.AuthenticationConfigurationProperty.ClientId`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-authenticationconfiguration.html#cfn-ask-skill-authenticationconfiguration-clientid
         * @external
         */
        readonly clientId: string;
        /**
         * `CfnSkill.AuthenticationConfigurationProperty.ClientSecret`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-authenticationconfiguration.html#cfn-ask-skill-authenticationconfiguration-clientsecret
         * @external
         */
        readonly clientSecret: string;
        /**
         * `CfnSkill.AuthenticationConfigurationProperty.RefreshToken`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-authenticationconfiguration.html#cfn-ask-skill-authenticationconfiguration-refreshtoken
         * @external
         */
        readonly refreshToken: string;
    }
}
/**
 * A CloudFormation `Alexa::ASK::Skill`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html
 * @external
 * @cloudformationResource Alexa::ASK::Skill
 */
export declare namespace CfnSkill {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-overrides.html
     * @external
     */
    interface OverridesProperty {
        /**
         * `CfnSkill.OverridesProperty.Manifest`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-overrides.html#cfn-ask-skill-overrides-manifest
         * @external
         */
        readonly manifest?: any | cdk.IResolvable;
    }
}
/**
 * A CloudFormation `Alexa::ASK::Skill`.
 *
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ask-skill.html
 * @external
 * @cloudformationResource Alexa::ASK::Skill
 */
export declare namespace CfnSkill {
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html
     * @external
     */
    interface SkillPackageProperty {
        /**
         * `CfnSkill.SkillPackageProperty.Overrides`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-overrides
         * @external
         */
        readonly overrides?: CfnSkill.OverridesProperty | cdk.IResolvable;
        /**
         * `CfnSkill.SkillPackageProperty.S3Bucket`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-s3bucket
         * @external
         */
        readonly s3Bucket: string;
        /**
         * `CfnSkill.SkillPackageProperty.S3BucketRole`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-s3bucketrole
         * @external
         */
        readonly s3BucketRole?: string;
        /**
         * `CfnSkill.SkillPackageProperty.S3Key`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-s3key
         * @external
         */
        readonly s3Key: string;
        /**
         * `CfnSkill.SkillPackageProperty.S3ObjectVersion`.
         *
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ask-skill-skillpackage.html#cfn-ask-skill-skillpackage-s3objectversion
         * @external
         */
        readonly s3ObjectVersion?: string;
    }
}
