/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.linalg;

import com.github.fommil.netlib.LAPACK;
import org.apache.spark.ml.optim.SingularMatrixException;
import org.netlib.util.intW;

public final class CholeskyDecomposition$ {
    public static CholeskyDecomposition$ MODULE$;

    static {
        new CholeskyDecomposition$();
    }

    public double[] solve(double[] A, double[] bx) {
        int k = bx.length;
        intW info = new intW(0);
        LAPACK.getInstance().dppsv("U", k, 1, A, bx, k, info);
        this.checkReturnValue(info, "dppsv");
        return bx;
    }

    public double[] inverse(double[] UAi, int k) {
        intW info = new intW(0);
        LAPACK.getInstance().dpptri("U", k, UAi, info);
        this.checkReturnValue(info, "dpptri");
        return UAi;
    }

    private void checkReturnValue(intW info, String method) {
        int n = info.val;
        switch (n) {
            default: 
        }
        if (n < 0) {
            throw new IllegalStateException(new StringBuilder(34).append("LAPACK.").append(method).append(" returned ").append(n).append("; arg ").append(-n).append(" is illegal").toString());
        }
        if (n > 0) {
            throw new SingularMatrixException(new StringBuilder(121).append("LAPACK.").append(method).append(" returned ").append(n).append(" because A is not positive definite. Is A derived from ").append("a singular matrix (e.g. collinear column values)?").toString());
        }
    }

    private CholeskyDecomposition$() {
        MODULE$ = this;
    }
}

