/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.IOUtils;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockFetcherIterator;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A\u0001G\r\u0005E!I1\u0006\u0001BC\u0002\u0013\u0005\u0011\u0004\f\u0005\t[\u0001\u0011\t\u0011)A\u0005G!Aa\u0006\u0001BC\u0002\u0013%q\u0006\u0003\u00055\u0001\t\u0005\t\u0015!\u00031\u0011!)\u0004A!b\u0001\n\u00131\u0004\u0002\u0003\u001e\u0001\u0005\u0003\u0005\u000b\u0011B\u001c\t\u0011m\u0002!Q1A\u0005\nqB\u0001b\u0011\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\t\u0002\u0011)\u0019!C\u0005\u000b\"A\u0011\n\u0001B\u0001B\u0003%a\t\u0003\u0005K\u0001\t\u0015\r\u0011\"\u0003L\u0011!y\u0005A!A!\u0002\u0013a\u0005\"\u0002)\u0001\t\u0003\t\u0006BB-\u0001A\u0003&A\nC\u0003[\u0001\u0011\u00053\fC\u0003]\u0001\u0011\u0005S\fC\u0003b\u0001\u0011\u00053\fC\u0003c\u0001\u0011\u00053\rC\u0003g\u0001\u0011\u0005s\rC\u0003n\u0001\u0011\u0005c\u000eC\u0003[\u0001\u0011\u0005s\u000eC\u0003[\u0001\u0011\u0005\u0003\u0010C\u0003\u007f\u0001\u0011\u0005SL\u0001\u000eCk\u001a4WM\u001d*fY\u0016\f7/\u001b8h\u0013:\u0004X\u000f^*ue\u0016\fWN\u0003\u0002\u001b7\u000591\u000f^8sC\u001e,'B\u0001\u000f\u001e\u0003\u0015\u0019\b/\u0019:l\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0011\u0001a\t\t\u0003I%j\u0011!\n\u0006\u0003M\u001d\n!![8\u000b\u0003!\nAA[1wC&\u0011!&\n\u0002\f\u0013:\u0004X\u000f^*ue\u0016\fW.\u0001\u0005eK2,w-\u0019;f+\u0005\u0019\u0013!\u00033fY\u0016<\u0017\r^3!\u0003!IG/\u001a:bi>\u0014X#\u0001\u0019\u0011\u0005E\u0012T\"A\r\n\u0005MJ\"aG*ik\u001a4G.\u001a\"m_\u000e\\g)\u001a;dQ\u0016\u0014\u0018\n^3sCR|'/A\u0005ji\u0016\u0014\u0018\r^8sA\u00059!\r\\8dW&#W#A\u001c\u0011\u0005EB\u0014BA\u001d\u001a\u0005\u001d\u0011En\\2l\u0013\u0012\f\u0001B\u00197pG.LE\rI\u0001\t[\u0006\u0004\u0018J\u001c3fqV\tQ\b\u0005\u0002?\u00036\tqHC\u0001A\u0003\u0015\u00198-\u00197b\u0013\t\u0011uHA\u0002J]R\f\u0011\"\\1q\u0013:$W\r\u001f\u0011\u0002\u000f\u0005$GM]3tgV\ta\t\u0005\u00022\u000f&\u0011\u0001*\u0007\u0002\u000f\u00052|7m['b]\u0006<WM]%e\u0003!\tG\r\u001a:fgN\u0004\u0013\u0001\u00053fi\u0016\u001cGoQ8seV\u0004H/[8o+\u0005a\u0005C\u0001 N\u0013\tquHA\u0004C_>dW-\u00198\u0002#\u0011,G/Z2u\u0007>\u0014(/\u001e9uS>t\u0007%\u0001\u0004=S:LGO\u0010\u000b\b%N#VKV,Y!\t\t\u0004\u0001C\u0003,\u001b\u0001\u00071\u0005C\u0003/\u001b\u0001\u0007\u0001\u0007C\u00036\u001b\u0001\u0007q\u0007C\u0003<\u001b\u0001\u0007Q\bC\u0003E\u001b\u0001\u0007a\tC\u0003K\u001b\u0001\u0007A*\u0001\u0004dY>\u001cX\rZ\u0001\u0005e\u0016\fG\rF\u0001>\u0003\u0015\u0019Gn\\:f)\u0005q\u0006C\u0001 `\u0013\t\u0001wH\u0001\u0003V]&$\u0018!C1wC&d\u0017M\u00197f\u0003\u0011i\u0017M]6\u0015\u0005y#\u0007\"B3\u0013\u0001\u0004i\u0014!\u0003:fC\u0012d\u0017.\\5u\u0003\u0011\u00198.\u001b9\u0015\u0005!\\\u0007C\u0001 j\u0013\tQwH\u0001\u0003M_:<\u0007\"\u00027\u0014\u0001\u0004A\u0017!\u00018\u0002\u001b5\f'o[*vaB|'\u000f^3e)\u0005aECA\u001fq\u0011\u0015\tX\u00031\u0001s\u0003\u0005\u0011\u0007c\u0001 tk&\u0011Ao\u0010\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003}YL!a^ \u0003\t\tKH/\u001a\u000b\u0005{eTH\u0010C\u0003r-\u0001\u0007!\u000fC\u0003|-\u0001\u0007Q(A\u0002pM\u001aDQ! \fA\u0002u\n1\u0001\\3o\u0003\u0015\u0011Xm]3u\u0001")
public class BufferReleasingInputStream
extends InputStream {
    private final InputStream delegate;
    private final ShuffleBlockFetcherIterator iterator;
    private final BlockId blockId;
    private final int mapIndex;
    private final BlockManagerId address;
    private final boolean detectCorruption;
    private boolean closed;

    public InputStream delegate() {
        return this.delegate;
    }

    private ShuffleBlockFetcherIterator iterator() {
        return this.iterator;
    }

    private BlockId blockId() {
        return this.blockId;
    }

    private int mapIndex() {
        return this.mapIndex;
    }

    private BlockManagerId address() {
        return this.address;
    }

    private boolean detectCorruption() {
        return this.detectCorruption;
    }

    @Override
    public int read() {
        int n;
        try {
            n = this.delegate().read();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                if (this.detectCorruption()) {
                    IOUtils.closeQuietly((InputStream)this);
                    throw this.iterator().throwFetchFailedException(this.blockId(), this.mapIndex(), this.address(), iOException);
                }
            }
            throw throwable;
        }
        return n;
    }

    @Override
    public void close() {
        block0: {
            if (this.closed) break block0;
            this.delegate().close();
            this.iterator().releaseCurrentResultBuffer();
            this.closed = true;
        }
    }

    @Override
    public int available() {
        return this.delegate().available();
    }

    @Override
    public void mark(int readlimit) {
        this.delegate().mark(readlimit);
    }

    @Override
    public long skip(long n) {
        long l;
        try {
            l = this.delegate().skip(n);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                if (this.detectCorruption()) {
                    IOUtils.closeQuietly((InputStream)this);
                    throw this.iterator().throwFetchFailedException(this.blockId(), this.mapIndex(), this.address(), iOException);
                }
            }
            throw throwable;
        }
        return l;
    }

    @Override
    public boolean markSupported() {
        return this.delegate().markSupported();
    }

    @Override
    public int read(byte[] b) {
        int n;
        try {
            n = this.delegate().read(b);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                if (this.detectCorruption()) {
                    IOUtils.closeQuietly((InputStream)this);
                    throw this.iterator().throwFetchFailedException(this.blockId(), this.mapIndex(), this.address(), iOException);
                }
            }
            throw throwable;
        }
        return n;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        int n;
        try {
            n = this.delegate().read(b, off, len);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof IOException) {
                IOException iOException = (IOException)throwable2;
                if (this.detectCorruption()) {
                    IOUtils.closeQuietly((InputStream)this);
                    throw this.iterator().throwFetchFailedException(this.blockId(), this.mapIndex(), this.address(), iOException);
                }
            }
            throw throwable;
        }
        return n;
    }

    @Override
    public void reset() {
        this.delegate().reset();
    }

    public BufferReleasingInputStream(InputStream delegate, ShuffleBlockFetcherIterator iterator, BlockId blockId, int mapIndex, BlockManagerId address, boolean detectCorruption) {
        this.delegate = delegate;
        this.iterator = iterator;
        this.blockId = blockId;
        this.mapIndex = mapIndex;
        this.address = address;
        this.detectCorruption = detectCorruption;
        this.closed = false;
    }
}

