/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.deploy;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.UUID;
import org.apache.ivy.Ivy;
import org.apache.ivy.core.module.descriptor.Artifact;
import org.apache.ivy.core.module.descriptor.DefaultDependencyDescriptor;
import org.apache.ivy.core.module.descriptor.DefaultExcludeRule;
import org.apache.ivy.core.module.descriptor.DefaultModuleDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.ExcludeRule;
import org.apache.ivy.core.module.descriptor.ModuleDescriptor;
import org.apache.ivy.core.module.id.ArtifactId;
import org.apache.ivy.core.module.id.ModuleId;
import org.apache.ivy.core.module.id.ModuleRevisionId;
import org.apache.ivy.core.report.ResolveReport;
import org.apache.ivy.core.resolve.ResolveOptions;
import org.apache.ivy.core.retrieve.RetrieveOptions;
import org.apache.ivy.core.settings.IvySettings;
import org.apache.ivy.plugins.matcher.GlobPatternMatcher;
import org.apache.ivy.plugins.matcher.PatternMatcher;
import org.apache.ivy.plugins.repository.Repository;
import org.apache.ivy.plugins.repository.file.FileRepository;
import org.apache.ivy.plugins.resolver.ChainResolver;
import org.apache.ivy.plugins.resolver.DependencyResolver;
import org.apache.ivy.plugins.resolver.FileSystemResolver;
import org.apache.ivy.plugins.resolver.IBiblioResolver;
import org.apache.spark.SparkException;
import org.apache.spark.deploy.SparkSubmit$;
import org.apache.spark.deploy.SparkSubmitOperation;
import org.apache.spark.deploy.SparkSubmitUtils;
import org.apache.spark.util.Utils$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;

public final class SparkSubmitUtils$ {
    public static SparkSubmitUtils$ MODULE$;
    private PrintStream printStream;
    private final Seq<String> IVY_DEFAULT_EXCLUDES;

    static {
        new SparkSubmitUtils$();
    }

    public PrintStream printStream() {
        return this.printStream;
    }

    public void printStream_$eq(PrintStream x$1) {
        this.printStream = x$1;
    }

    public Seq<String> IVY_DEFAULT_EXCLUDES() {
        return this.IVY_DEFAULT_EXCLUDES;
    }

    public Seq<SparkSubmitUtils.MavenCoordinate> extractMavenCoordinates(String coordinates) {
        return (Seq)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])coordinates.split(","))).map((Function1 & Serializable & scala.Serializable)p -> {
            String[] splits = p.replace("/", ":").split(":");
            Predef$.MODULE$.require(splits.length == 3, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(105).append("Provided Maven Coordinates must be in the form ").append("'groupId:artifactId:version'. The coordinate provided is: ").append((String)p).toString());
            Predef$.MODULE$.require(splits[0] != null && new StringOps(Predef$.MODULE$.augmentString(splits[0].trim())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("The groupId cannot be null or ").append("be whitespace. The groupId provided is: ").append(splits[0]).toString());
            Predef$.MODULE$.require(splits[1] != null && new StringOps(Predef$.MODULE$.augmentString(splits[1].trim())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(76).append("The artifactId cannot be null or ").append("be whitespace. The artifactId provided is: ").append(splits[1]).toString());
            Predef$.MODULE$.require(splits[2] != null && new StringOps(Predef$.MODULE$.augmentString(splits[2].trim())).nonEmpty(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(70).append("The version cannot be null or ").append("be whitespace. The version provided is: ").append(splits[2]).toString());
            return new SparkSubmitUtils.MavenCoordinate(splits[0], splits[1], splits[2]);
        }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
    }

    public File m2Path() {
        return Utils$.MODULE$.isTesting() ? new File("dummy", new StringBuilder(13).append(".m2").append(File.separator).append("repository").toString()) : new File(System.getProperty("user.home"), new StringBuilder(13).append(".m2").append(File.separator).append("repository").toString());
    }

    /*
     * WARNING - void declaration
     */
    public ChainResolver createRepoResolvers(File defaultIvyUserDir) {
        void var2_2;
        ChainResolver cr = new ChainResolver();
        cr.setName("spark-list");
        IBiblioResolver localM2 = new IBiblioResolver();
        localM2.setM2compatible(true);
        localM2.setRoot(this.m2Path().toURI().toString());
        localM2.setUsepoms(true);
        localM2.setName("local-m2-cache");
        cr.add((DependencyResolver)localM2);
        FileSystemResolver localIvy = new FileSystemResolver();
        File localIvyRoot = new File(defaultIvyUserDir, "local");
        localIvy.setLocal(true);
        localIvy.setRepository((Repository)new FileRepository(localIvyRoot));
        String ivyPattern = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{localIvyRoot.getAbsolutePath(), "[organisation]", "[module]", "[revision]", "ivys", "ivy.xml"}))).mkString(File.separator);
        localIvy.addIvyPattern(ivyPattern);
        String artifactPattern = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{localIvyRoot.getAbsolutePath(), "[organisation]", "[module]", "[revision]", "[type]s", "[artifact](-[classifier]).[ext]"}))).mkString(File.separator);
        localIvy.addArtifactPattern(artifactPattern);
        localIvy.setName("local-ivy-cache");
        cr.add((DependencyResolver)localIvy);
        IBiblioResolver br = new IBiblioResolver();
        br.setM2compatible(true);
        br.setUsepoms(true);
        Option defaultInternalRepo = package$.MODULE$.env().get((Object)"DEFAULT_ARTIFACT_REPOSITORY");
        br.setRoot((String)defaultInternalRepo.getOrElse((Function0 & Serializable & scala.Serializable)() -> "https://repo1.maven.org/maven2/"));
        br.setName("central");
        cr.add((DependencyResolver)br);
        IBiblioResolver sp2 = new IBiblioResolver();
        sp2.setM2compatible(true);
        sp2.setUsepoms(true);
        sp2.setRoot((String)package$.MODULE$.env().getOrElse((Object)"DEFAULT_ARTIFACT_REPOSITORY", (Function0 & Serializable & scala.Serializable)() -> "https://dl.bintray.com/spark-packages/maven"));
        sp2.setName("spark-packages");
        cr.add((DependencyResolver)sp2);
        return var2_2;
    }

    public String resolveDependencyPaths(Object[] artifacts, File cacheDirectory) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps(artifacts)).map((Function1 & Serializable & scala.Serializable)artifactInfo -> {
            ModuleRevisionId artifact = ((Artifact)artifactInfo).getModuleRevisionId();
            Map extraAttrs = ((Artifact)artifactInfo).getExtraAttributes();
            String classifier = extraAttrs.containsKey("classifier") ? new StringBuilder(1).append("-").append(extraAttrs.get("classifier")).toString() : "";
            return new StringBuilder(6).append(cacheDirectory.getAbsolutePath()).append(File.separator).append(artifact.getOrganisation()).append("_").append(artifact.getName()).append("-").append(artifact.getRevision()).append(classifier).append(".jar").toString();
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class))))).mkString(",");
    }

    public void addDependenciesToIvy(DefaultModuleDescriptor md, Seq<SparkSubmitUtils.MavenCoordinate> artifacts, String ivyConfName) {
        artifacts.foreach((Function1 & Serializable & scala.Serializable)mvn -> {
            SparkSubmitUtils$.$anonfun$addDependenciesToIvy$1(ivyConfName, md, mvn);
            return BoxedUnit.UNIT;
        });
    }

    public void addExclusionRules(IvySettings ivySettings, String ivyConfName, DefaultModuleDescriptor md) {
        md.addExcludeRule(this.createExclusion("*:scala-library:*", ivySettings, ivyConfName));
        this.IVY_DEFAULT_EXCLUDES().foreach((Function1 & Serializable & scala.Serializable)comp -> {
            md.addExcludeRule(SparkSubmitUtils$.MODULE$.createExclusion(new StringBuilder(26).append("org.apache.spark:spark-").append(comp).append("*:*").toString(), ivySettings, ivyConfName));
            return BoxedUnit.UNIT;
        });
    }

    /*
     * WARNING - void declaration
     */
    public IvySettings buildIvySettings(Option<String> remoteRepos, Option<String> ivyPath) {
        void var3_3;
        IvySettings ivySettings = new IvySettings();
        this.processIvyPathArg(ivySettings, ivyPath);
        ivySettings.addMatcher((PatternMatcher)new GlobPatternMatcher());
        ChainResolver repoResolver = this.createRepoResolvers(ivySettings.getDefaultIvyUserDir());
        ivySettings.addResolver((DependencyResolver)repoResolver);
        ivySettings.setDefaultResolver(repoResolver.getName());
        this.processRemoteRepoArg(ivySettings, remoteRepos);
        return var3_3;
    }

    public IvySettings loadIvySettings(String settingsFile, Option<String> remoteRepos, Option<String> ivyPath) {
        File file = new File(settingsFile);
        Predef$.MODULE$.require(file.exists(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(33).append("Ivy settings file ").append(file).append(" does not exist").toString());
        Predef$.MODULE$.require(file.isFile(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Ivy settings file ").append(file).append(" is not a normal file").toString());
        IvySettings ivySettings = new IvySettings();
        try {
            ivySettings.load(file);
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            boolean bl = throwable2 instanceof IOException ? true : throwable2 instanceof ParseException;
            if (bl) {
                throw new SparkException(new StringBuilder(38).append("Failed when loading Ivy settings from ").append(settingsFile).toString(), throwable2);
            }
            throw throwable;
        }
        this.processIvyPathArg(ivySettings, ivyPath);
        this.processRemoteRepoArg(ivySettings, remoteRepos);
        return ivySettings;
    }

    private void processIvyPathArg(IvySettings ivySettings, Option<String> ivyPath) {
        ivyPath.filterNot((Function1 & Serializable & scala.Serializable)x$20 -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitUtils$.$anonfun$processIvyPathArg$1(x$20))).foreach((Function1 & Serializable & scala.Serializable)alternateIvyDir -> {
            SparkSubmitUtils$.$anonfun$processIvyPathArg$2(ivySettings, alternateIvyDir);
            return BoxedUnit.UNIT;
        });
    }

    private void processRemoteRepoArg(IvySettings ivySettings, Option<String> remoteRepos) {
        remoteRepos.filterNot((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitUtils$.$anonfun$processRemoteRepoArg$1(x$21))).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.split(",")).foreach((Function1 & Serializable & scala.Serializable)repositoryList -> {
            SparkSubmitUtils$.$anonfun$processRemoteRepoArg$3(ivySettings, repositoryList);
            return BoxedUnit.UNIT;
        });
    }

    public DefaultModuleDescriptor getModuleDescriptor() {
        return DefaultModuleDescriptor.newDefaultInstance((ModuleRevisionId)ModuleRevisionId.newInstance((String)"org.apache.spark", (String)new StringBuilder(20).append("spark-submit-parent-").append(UUID.randomUUID().toString()).toString(), (String)"1.0"));
    }

    private void clearIvyResolutionFiles(ModuleRevisionId mdId, IvySettings ivySettings, String ivyConfName) {
        Seq currentResolutionFiles = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{new StringBuilder(6).append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(ivyConfName).append(".xml").toString(), new StringBuilder(15).append("resolved-").append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(mdId.getRevision()).append(".xml").toString(), new StringBuilder(22).append("resolved-").append(mdId.getOrganisation()).append("-").append(mdId.getName()).append("-").append(mdId.getRevision()).append(".properties").toString()}));
        currentResolutionFiles.foreach((Function1 & Serializable & scala.Serializable)filename -> BoxesRunTime.boxToBoolean((boolean)SparkSubmitUtils$.$anonfun$clearIvyResolutionFiles$1(ivySettings, filename)));
    }

    public String resolveMavenCoordinates(String coordinates, IvySettings ivySettings, Seq<String> exclusions, boolean isTest) {
        String string;
        if (coordinates == null || coordinates.trim().isEmpty()) {
            string = "";
        } else {
            PrintStream sysOut = System.out;
            String ivyConfName = "default";
            DefaultModuleDescriptor md = this.getModuleDescriptor();
            md.setDefaultConf(ivyConfName);
            try {
                ResolveOptions resolveOptions;
                System.setOut(this.printStream());
                Seq<SparkSubmitUtils.MavenCoordinate> artifacts = this.extractMavenCoordinates(coordinates);
                File packagesDirectory = new File(ivySettings.getDefaultIvyUserDir(), "jars");
                this.printStream().println(new StringBuilder(26).append("Ivy Default Cache set to: ").append(ivySettings.getDefaultCache().getAbsolutePath()).toString());
                this.printStream().println(new StringBuilder(37).append("The jars for the packages stored in: ").append(packagesDirectory).toString());
                Ivy ivy = Ivy.newInstance((IvySettings)ivySettings);
                ResolveOptions resolveOptions2 = new ResolveOptions();
                resolveOptions2.setTransitive(true);
                RetrieveOptions retrieveOptions = new RetrieveOptions();
                if (isTest) {
                    resolveOptions2.setDownload(false);
                    resolveOptions2.setLog("quiet");
                    resolveOptions = retrieveOptions.setLog("quiet");
                } else {
                    resolveOptions = resolveOptions2.setDownload(true);
                }
                this.addExclusionRules(ivySettings, ivyConfName, md);
                this.addDependenciesToIvy(md, artifacts, ivyConfName);
                exclusions.foreach((Function1 & Serializable & scala.Serializable)e -> {
                    md.addExcludeRule(SparkSubmitUtils$.MODULE$.createExclusion(new StringBuilder(2).append(e).append(":*").toString(), ivySettings, ivyConfName));
                    return BoxedUnit.UNIT;
                });
                ResolveReport rr = ivy.resolve((ModuleDescriptor)md, resolveOptions2);
                if (rr.hasError()) {
                    throw new RuntimeException(rr.getAllProblemMessages().toString());
                }
                ivy.retrieve(rr.getModuleDescriptor().getModuleRevisionId(), new StringBuilder(57).append(packagesDirectory.getAbsolutePath()).append(File.separator).append("[organization]_[artifact]-[revision](-[classifier]).[ext]").toString(), retrieveOptions.setConfs((String[])((Object[])new String[]{ivyConfName})));
                string = this.resolveDependencyPaths(rr.getArtifacts().toArray(), packagesDirectory);
            }
            finally {
                System.setOut(sysOut);
                this.clearIvyResolutionFiles(md.getModuleRevisionId(), ivySettings, ivyConfName);
            }
        }
        return string;
    }

    public Seq<String> resolveMavenCoordinates$default$3() {
        return Nil$.MODULE$;
    }

    public boolean resolveMavenCoordinates$default$4() {
        return false;
    }

    public ExcludeRule createExclusion(String coords, IvySettings ivySettings, String ivyConfName) {
        SparkSubmitUtils.MavenCoordinate c = (SparkSubmitUtils.MavenCoordinate)this.extractMavenCoordinates(coords).apply(0);
        ArtifactId id = new ArtifactId(new ModuleId(c.groupId(), c.artifactId()), "*", "*", "*");
        DefaultExcludeRule rule = new DefaultExcludeRule(id, ivySettings.getMatcher("glob"), null);
        rule.addConfiguration(ivyConfName);
        return rule;
    }

    public Tuple2<String, String> parseSparkConfProperty(String pair) {
        Seq seq = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])pair.split("=", 2))).toSeq();
        Some some = Seq$.MODULE$.unapplySeq(seq);
        if (some.isEmpty() || some.get() == null || ((SeqLike)some.get()).lengthCompare(2) != 0) {
            throw new SparkException(new StringBuilder(26).append("Spark config without '=': ").append(pair).toString());
        }
        String k = (String)((SeqLike)some.get()).apply(0);
        String v = (String)((SeqLike)some.get()).apply(1);
        Tuple2 tuple2 = new Tuple2((Object)k, (Object)v);
        return tuple2;
    }

    public SparkSubmitOperation getSubmitOperations(String master) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(SparkSubmitOperation.class, loader)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$23 -> BoxesRunTime.boxToBoolean((boolean)x$23.supports(master)));
        int n = serviceLoaders.size();
        if (n > 1) {
            throw new SparkException(new StringBuilder(77).append("Multiple(").append(n).append(") external SparkSubmitOperations ").append("clients registered for master url ").append(master).append(".").toString());
        }
        if (1 != n) {
            throw new IllegalArgumentException(new StringBuilder(66).append("No external SparkSubmitOperations ").append("clients found for master url: '").append(master).append("'").toString());
        }
        SparkSubmitOperation sparkSubmitOperation = (SparkSubmitOperation)serviceLoaders.headOption().get();
        return sparkSubmitOperation;
    }

    public static final /* synthetic */ void $anonfun$addDependenciesToIvy$1(String ivyConfName$1, DefaultModuleDescriptor md$1, SparkSubmitUtils.MavenCoordinate mvn) {
        ModuleRevisionId ri = ModuleRevisionId.newInstance((String)mvn.groupId(), (String)mvn.artifactId(), (String)mvn.version());
        DefaultDependencyDescriptor dd = new DefaultDependencyDescriptor(ri, false, false);
        dd.addDependencyConfiguration(ivyConfName$1, new StringBuilder(9).append(ivyConfName$1).append("(runtime)").toString());
        MODULE$.printStream().println(new StringBuilder(22).append(dd.getDependencyId()).append(" added as a dependency").toString());
        md$1.addDependency((DependencyDescriptor)dd);
    }

    public static final /* synthetic */ boolean $anonfun$processIvyPathArg$1(String x$20) {
        return x$20.trim().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$processIvyPathArg$2(IvySettings ivySettings$2, String alternateIvyDir) {
        ivySettings$2.setDefaultIvyUserDir(new File(alternateIvyDir));
        ivySettings$2.setDefaultCache(new File(alternateIvyDir, "cache"));
    }

    public static final /* synthetic */ boolean $anonfun$processRemoteRepoArg$1(String x$21) {
        return x$21.trim().isEmpty();
    }

    public static final /* synthetic */ void $anonfun$processRemoteRepoArg$5(ChainResolver cr$1, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String repo = (String)tuple2._1();
        int i = tuple2._2$mcI$sp();
        IBiblioResolver brr = new IBiblioResolver();
        brr.setM2compatible(true);
        brr.setUsepoms(true);
        brr.setRoot(repo);
        brr.setName(new StringBuilder(5).append("repo-").append(i + 1).toString());
        cr$1.add((DependencyResolver)brr);
        MODULE$.printStream().println(new StringBuilder(45).append(repo).append(" added as a remote repository with the name: ").append(brr.getName()).toString());
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$processRemoteRepoArg$3(IvySettings ivySettings$3, String[] repositoryList) {
        ChainResolver cr = new ChainResolver();
        cr.setName("user-list");
        Option$.MODULE$.apply((Object)ivySettings$3.getDefaultResolver()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            cr.add(x$1);
            return BoxedUnit.UNIT;
        });
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])repositoryList)).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
            SparkSubmitUtils$.$anonfun$processRemoteRepoArg$5(cr, x0$1);
            return BoxedUnit.UNIT;
        });
        ivySettings$3.addResolver((DependencyResolver)cr);
        ivySettings$3.setDefaultResolver(cr.getName());
    }

    public static final /* synthetic */ boolean $anonfun$clearIvyResolutionFiles$1(IvySettings ivySettings$4, String filename) {
        return new File(ivySettings$4.getDefaultCache(), filename).delete();
    }

    private SparkSubmitUtils$() {
        MODULE$ = this;
        this.printStream = SparkSubmit$.MODULE$.printStream();
        this.IVY_DEFAULT_EXCLUDES = (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"catalyst_", "core_", "graphx_", "kvstore_", "launcher_", "mllib_", "mllib-local_", "network-common_", "network-shuffle_", "repl_", "sketch_", "sql_", "streaming_", "tags_", "unsafe_"}));
    }
}

