/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.spark.GetMapOutputStatuses;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.KeyLock;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001y4Qa\u0003\u0007\u0001\u0019IA\u0001b\u0006\u0001\u0003\u0002\u0003\u0006I!\u0007\u0005\u00069\u0001!\t!\b\u0005\bA\u0001\u0011\r\u0011\"\u0001\"\u0011\u0019I\u0004\u0001)A\u0005E!9!\b\u0001b\u0001\n\u0013Y\u0004B\u0002\"\u0001A\u0003%A\bC\u0003D\u0001\u0011\u0005C\tC\u0003q\u0001\u0011%\u0011\u000fC\u0003u\u0001\u0011\u0005Q\u000fC\u0003{\u0001\u0011\u00051P\u0001\fNCB|U\u000f\u001e9viR\u0013\u0018mY6fe^{'o[3s\u0015\tia\"A\u0003ta\u0006\u00148N\u0003\u0002\u0010!\u00051\u0011\r]1dQ\u0016T\u0011!E\u0001\u0004_J<7C\u0001\u0001\u0014!\t!R#D\u0001\r\u0013\t1BB\u0001\tNCB|U\u000f\u001e9viR\u0013\u0018mY6fe\u0006!1m\u001c8g\u0007\u0001\u0001\"\u0001\u0006\u000e\n\u0005ma!!C*qCJ\\7i\u001c8g\u0003\u0019a\u0014N\\5u}Q\u0011ad\b\t\u0003)\u0001AQa\u0006\u0002A\u0002e\t1\"\\1q'R\fG/^:fgV\t!\u0005\u0005\u0003$U1\u0002T\"\u0001\u0013\u000b\u0005\u00152\u0013aB7vi\u0006\u0014G.\u001a\u0006\u0003O!\n!bY8mY\u0016\u001cG/[8o\u0015\u0005I\u0013!B:dC2\f\u0017BA\u0016%\u0005\ri\u0015\r\u001d\t\u0003[9j\u0011\u0001K\u0005\u0003_!\u00121!\u00138u!\ri\u0013gM\u0005\u0003e!\u0012Q!\u0011:sCf\u0004\"\u0001N\u001c\u000e\u0003UR!A\u000e\u0007\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018B\u0001\u001d6\u0005%i\u0015\r]*uCR,8/\u0001\u0007nCB\u001cF/\u0019;vg\u0016\u001c\b%\u0001\u0007gKR\u001c\u0007.\u001b8h\u0019>\u001c7.F\u0001=!\ri\u0004\tL\u0007\u0002})\u0011q\bD\u0001\u0005kRLG.\u0003\u0002B}\t91*Z=M_\u000e\\\u0017!\u00044fi\u000eD\u0017N\\4M_\u000e\\\u0007%A\fhKRl\u0015\r]*ju\u0016\u001c()_#yK\u000e,Ho\u001c:JIR1QI\u001a5kY:\u00042A\u0012(R\u001d\t9EJ\u0004\u0002I\u00176\t\u0011J\u0003\u0002K1\u00051AH]8pizJ\u0011!K\u0005\u0003\u001b\"\nq\u0001]1dW\u0006<W-\u0003\u0002P!\nA\u0011\n^3sCR|'O\u0003\u0002NQA!QF\u0015+[\u0013\t\u0019\u0006F\u0001\u0004UkBdWM\r\t\u0003+bk\u0011A\u0016\u0006\u0003/2\tqa\u001d;pe\u0006<W-\u0003\u0002Z-\nq!\t\\8dW6\u000bg.Y4fe&#\u0007c\u0001$\\;&\u0011A\f\u0015\u0002\u0004'\u0016\f\b#B\u0017_A\u000ed\u0013BA0)\u0005\u0019!V\u000f\u001d7fgA\u0011Q+Y\u0005\u0003EZ\u0013qA\u00117pG.LE\r\u0005\u0002.I&\u0011Q\r\u000b\u0002\u0005\u0019>tw\rC\u0003h\u000f\u0001\u0007A&A\u0005tQV4g\r\\3JI\")\u0011n\u0002a\u0001Y\u0005i1\u000f^1si6\u000b\u0007/\u00138eKbDQa[\u0004A\u00021\n1\"\u001a8e\u001b\u0006\u0004\u0018J\u001c3fq\")Qn\u0002a\u0001Y\u0005q1\u000f^1siB\u000b'\u000f^5uS>t\u0007\"B8\b\u0001\u0004a\u0013\u0001D3oIB\u000b'\u000f^5uS>t\u0017aC4fiN#\u0018\r^;tKN$2\u0001\r:t\u0011\u00159\u0007\u00021\u0001-\u0011\u00159\u0002\u00021\u0001\u001a\u0003E)hN]3hSN$XM]*ik\u001a4G.\u001a\u000b\u0003mf\u0004\"!L<\n\u0005aD#\u0001B+oSRDQaZ\u0005A\u00021\n1\"\u001e9eCR,W\t]8dQR\u0011a\u000f \u0005\u0006{*\u0001\raY\u0001\t]\u0016<X\t]8dQ\u0002")
public class MapOutputTrackerWorker
extends MapOutputTracker {
    private final SparkConf conf;
    private final Map<Object, MapStatus[]> mapStatuses;
    private final KeyLock<Object> fetchingLock;

    public Map<Object, MapStatus[]> mapStatuses() {
        return this.mapStatuses;
    }

    private KeyLock<Object> fetchingLock() {
        return this.fetchingLock;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesByExecutorId(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Fetching outputs for shuffle ").append(shuffleId).toString());
        MapStatus[] statuses = this.getStatuses(shuffleId, this.conf);
        try {
            int actualEndMapIndex = endMapIndex == Integer.MAX_VALUE ? statuses.length : endMapIndex;
            this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(58).append("Convert map statuses for shuffle ").append(shuffleId).append(", ").append("mappers ").append(startMapIndex).append("-").append(actualEndMapIndex).append(", partitions ").append(startPartition).append("-").append(endPartition).toString());
            iterator = MapOutputTracker$.MODULE$.convertMapStatuses(shuffleId, startPartition, endPartition, statuses, startMapIndex, actualEndMapIndex);
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            throw e;
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    private MapStatus[] getStatuses(int shuffleId, SparkConf conf) {
        MapStatus[] mapStatusArray;
        MapStatus[] statuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
        if (statuses == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Don't have map outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
            long startTimeNs = System.nanoTime();
            mapStatusArray = (MapStatus[])this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                MapStatus[] fetchedStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                if (fetchedStatuses == null) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
                    byte[] fetchedBytes = (byte[])this.askTracker(new GetMapOutputStatuses(shuffleId), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                    fetchedStatuses = MapOutputTracker$.MODULE$.deserializeMapStatuses(fetchedBytes, conf);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the output locations");
                    boxedUnit = this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedStatuses);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Fetching map output statuses for shuffle ").append(shuffleId).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString());
                return fetchedStatuses;
            });
        } else {
            void var3_3;
            mapStatusArray = var3_3;
        }
        return mapStatusArray;
    }

    @Override
    public void unregisterShuffle(int shuffleId) {
        this.mapStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public void updateEpoch(long newEpoch) {
        Object object = this.epochLock();
        synchronized (object) {
            if (newEpoch > this.epoch()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Updating epoch to ").append(newEpoch).append(" and clearing cache").toString());
                this.epoch_$eq(newEpoch);
                this.mapStatuses().clear();
            }
        }
    }

    public MapOutputTrackerWorker(SparkConf conf) {
        this.conf = conf;
        super(conf);
        this.mapStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.fetchingLock = new KeyLock();
    }
}

