/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.ByteArrayInputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.spark.SparkConf;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.broadcast.BroadcastManager;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.io.CompressionCodec;
import org.apache.spark.io.CompressionCodec$;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.ShuffleBlockId;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class MapOutputTracker$
implements Logging {
    public static MapOutputTracker$ MODULE$;
    private final String ENDPOINT_NAME;
    private final int DIRECT;
    private final int BROADCAST;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new MapOutputTracker$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String ENDPOINT_NAME() {
        return this.ENDPOINT_NAME;
    }

    private int DIRECT() {
        return this.DIRECT;
    }

    private int BROADCAST() {
        return this.BROADCAST;
    }

    public Tuple2<byte[], Broadcast<byte[]>> serializeMapStatuses(MapStatus[] statuses, BroadcastManager broadcastManager, boolean isLocal, int minBroadcastSize, SparkConf conf) {
        Tuple2 tuple2;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        out.write(this.DIRECT());
        CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(conf, conf.get(package$.MODULE$.MAP_STATUS_COMPRESSION_CODEC()));
        ObjectOutputStream objOut = new ObjectOutputStream(codec.compressedOutputStream((OutputStream)out));
        Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            MapStatus[] mapStatusArray = statuses;
            synchronized (statuses) {
                objOut.writeObject(statuses);
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> objOut.close());
        byte[] arr = out.toByteArray();
        if (arr.length >= minBroadcastSize) {
            Broadcast<byte[]> bcast = broadcastManager.newBroadcast(arr, isLocal, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
            out.reset();
            out.write(this.BROADCAST());
            ObjectOutputStream oos = new ObjectOutputStream(codec.compressedOutputStream((OutputStream)out));
            Utils$.MODULE$.tryWithSafeFinally((JFunction0.mcV.sp & Serializable & scala.Serializable)() -> oos.writeObject(bcast), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> oos.close());
            byte[] outArr = out.toByteArray();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broadcast mapstatuses size = ").append(outArr.length).append(", actual size = ").append(arr.length).toString());
            tuple2 = new Tuple2((Object)outArr, bcast);
        } else {
            tuple2 = new Tuple2((Object)arr, null);
        }
        return tuple2;
    }

    public MapStatus[] deserializeMapStatuses(byte[] bytes, SparkConf conf) {
        MapStatus[] mapStatusArray;
        Predef$.MODULE$.assert(bytes.length > 0);
        byte by = bytes[0];
        if (this.DIRECT() == by) {
            mapStatusArray = (MapStatus[])MapOutputTracker$.deserializeObject$1(bytes, 1, bytes.length - 1, conf);
        } else if (this.BROADCAST() == by) {
            Broadcast bcast = (Broadcast)MapOutputTracker$.deserializeObject$1(bytes, 1, bytes.length - 1, conf);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(45).append("Broadcast mapstatuses size = ").append(bytes.length).append(", actual size = ").append(((byte[])bcast.value()).length).toString());
            mapStatusArray = (MapStatus[])MapOutputTracker$.deserializeObject$1((byte[])bcast.value(), 1, ((byte[])bcast.value()).length - 1, conf);
        } else {
            throw new IllegalArgumentException(new StringBuilder(22).append("Unexpected byte tag = ").append(bytes[0]).toString());
        }
        return mapStatusArray;
    }

    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> convertMapStatuses(int shuffleId, int startPartition, int endPartition, MapStatus[] statuses, int startMapIndex, int endMapIndex) {
        Predef$.MODULE$.assert(statuses != null);
        HashMap splitsByAddress = new HashMap();
        Iterator iter = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])statuses)).iterator().zipWithIndex();
        iter.slice(startMapIndex, endMapIndex).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)MapOutputTracker$.$anonfun$convertMapStatuses$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$11 -> {
            MapOutputTracker$.$anonfun$convertMapStatuses$2(shuffleId, startPartition, endPartition, splitsByAddress, x$11);
            return BoxedUnit.UNIT;
        });
        return splitsByAddress.mapValues((Function1 & Serializable & scala.Serializable)x$12 -> x$12.toSeq()).iterator();
    }

    private static final Object deserializeObject$1(byte[] arr, int off, int len, SparkConf conf$3) {
        CompressionCodec codec = CompressionCodec$.MODULE$.createCodec(conf$3, conf$3.get(package$.MODULE$.MAP_STATUS_COMPRESSION_CODEC()));
        ObjectInputStream objIn = new ObjectInputStream(codec.compressedInputStream(new ByteArrayInputStream(arr, off, len)));
        return Utils$.MODULE$.tryWithSafeFinally((Function0 & Serializable & scala.Serializable)() -> objIn.readObject(), (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> objIn.close());
    }

    public static final /* synthetic */ boolean $anonfun$convertMapStatuses$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ Object $anonfun$convertMapStatuses$4(MapStatus status$2, HashMap splitsByAddress$1, int shuffleId$6, int mapIndex$3, int part) {
        long size = status$2.getSizeForBlock(part);
        return size != 0L ? ((ListBuffer)splitsByAddress$1.getOrElseUpdate((Object)status$2.location(), (Function0 & Serializable & scala.Serializable)() -> (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$))).$plus$eq((Object)new Tuple3((Object)new ShuffleBlockId(shuffleId$6, status$2.mapId(), part), (Object)BoxesRunTime.boxToLong((long)size), (Object)BoxesRunTime.boxToInteger((int)mapIndex$3))) : BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$convertMapStatuses$2(int shuffleId$6, int startPartition$3, int endPartition$3, HashMap splitsByAddress$1, Tuple2 x$11) {
        int mapIndex;
        MapStatus status;
        Tuple2 tuple2 = x$11;
        if (tuple2 != null) {
            status = (MapStatus)tuple2._1();
            mapIndex = tuple2._2$mcI$sp();
            if (status == null) {
                String errorMessage = new StringBuilder(39).append("Missing an output location for shuffle ").append(shuffleId$6).toString();
                MODULE$.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> errorMessage);
                throw new MetadataFetchFailedException(shuffleId$6, startPartition$3, errorMessage);
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(startPartition$3), endPartition$3).foreach((Function1 & Serializable & scala.Serializable)part -> MapOutputTracker$.$anonfun$convertMapStatuses$4(status, splitsByAddress$1, shuffleId$6, mapIndex, BoxesRunTime.unboxToInt((Object)part)));
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private MapOutputTracker$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.ENDPOINT_NAME = "MapOutputTracker";
        this.DIRECT = 0;
        this.BROADCAST = 1;
    }
}

