/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.joins;

import java.io.Serializable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkEnv;
import org.apache.spark.SparkEnv$;
import org.apache.spark.internal.config.ConfigEntry;
import org.apache.spark.internal.config.package$;
import org.apache.spark.memory.SparkOutOfMemoryError;
import org.apache.spark.memory.TaskMemoryManager;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection$;
import org.apache.spark.sql.catalyst.expressions.UnsafeRow;
import org.apache.spark.sql.execution.joins.HashedRelation;
import org.apache.spark.sql.execution.joins.HashedRelationWithAllNullKeys$;
import org.apache.spark.sql.execution.joins.UnsafeHashedRelation;
import org.apache.spark.unsafe.map.BytesToBytesMap;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class UnsafeHashedRelation$
implements scala.Serializable {
    public static UnsafeHashedRelation$ MODULE$;

    static {
        new UnsafeHashedRelation$();
    }

    public HashedRelation apply(Iterator<InternalRow> input, Seq<Expression> key, int sizeEstimate, TaskMemoryManager taskMemoryManager, boolean isNullAware, boolean allowsNullKey) {
        Predef$.MODULE$.require(!isNullAware || !allowsNullKey, (Function0 & Serializable & scala.Serializable)() -> "isNullAware and allowsNullKey cannot be enabled at same time");
        long pageSizeBytes = BoxesRunTime.unboxToLong((Object)Option$.MODULE$.apply((Object)SparkEnv$.MODULE$.get()).map((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToLong((long)UnsafeHashedRelation$.$anonfun$apply$3(x$2))).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToLong((Object)((Option)new SparkConf().get((ConfigEntry)package$.MODULE$.BUFFER_PAGESIZE())).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0x1000000L))));
        BytesToBytesMap binaryMap = new BytesToBytesMap(taskMemoryManager, (int)((double)sizeEstimate * 1.5 + 1.0), pageSizeBytes);
        UnsafeProjection keyGenerator = UnsafeProjection$.MODULE$.create(key);
        int numFields = 0;
        while (input.hasNext()) {
            UnsafeRow row = (UnsafeRow)input.next();
            numFields = row.numFields();
            UnsafeRow key2 = keyGenerator.apply((InternalRow)row);
            if (!key2.anyNull() || allowsNullKey) {
                BytesToBytesMap.Location loc = binaryMap.lookup(key2.getBaseObject(), key2.getBaseOffset(), key2.getSizeInBytes());
                boolean success = loc.append(key2.getBaseObject(), key2.getBaseOffset(), key2.getSizeInBytes(), row.getBaseObject(), row.getBaseOffset(), row.getSizeInBytes());
                if (success) continue;
                binaryMap.free();
                throw new SparkOutOfMemoryError("There is not enough memory to build hash map");
            }
            if (!isNullAware) continue;
            return HashedRelationWithAllNullKeys$.MODULE$;
        }
        return new UnsafeHashedRelation(key.size(), numFields, binaryMap);
    }

    public boolean apply$default$5() {
        return false;
    }

    public boolean apply$default$6() {
        return false;
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ long $anonfun$apply$3(SparkEnv x$2) {
        return x$2.memoryManager().pageSizeBytes();
    }

    private UnsafeHashedRelation$() {
        MODULE$ = this;
    }
}

