/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.GroupingSet;
import org.apache.spark.sql.catalyst.expressions.Rollup$;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.Serializable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ExpressionDescription(usage="\n    _FUNC_([col1[, col2 ..]]) - create a multi-dimensional rollup using the specified columns\n      so that we can run aggregation on them.\n  ", examples="\n    Examples:\n      > SELECT name, age, count(*) FROM VALUES (2, 'Alice'), (5, 'Bob') people(age, name) GROUP BY _FUNC_(name, age);\n        Bob\t5\t1\n        Alice\t2\t1\n        Alice\tNULL\t1\n        NULL\tNULL\t2\n        Bob\tNULL\t1\n  ", since="2.0.0")
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dc\u0001B\n\u0015\u0001\u0006B\u0001B\r\u0001\u0003\u0016\u0004%\ta\r\u0005\t\u0001\u0002\u0011\t\u0012)A\u0005i!)\u0011\t\u0001C\u0001\u0005\"9Q\tAA\u0001\n\u00031\u0005b\u0002%\u0001#\u0003%\t!\u0013\u0005\b)\u0002\t\t\u0011\"\u0011V\u0011\u001dq\u0006!!A\u0005\u0002}Cqa\u0019\u0001\u0002\u0002\u0013\u0005A\rC\u0004k\u0001\u0005\u0005I\u0011I6\t\u000fI\u0004\u0011\u0011!C\u0001g\"9\u0001\u0010AA\u0001\n\u0003Jx!CA\t)\u0005\u0005\t\u0012AA\n\r!\u0019B#!A\t\u0002\u0005U\u0001BB!\u000e\t\u0003\t\u0019\u0003C\u0005\u0002&5\t\t\u0011\"\u0012\u0002(!I\u0011\u0011F\u0007\u0002\u0002\u0013\u0005\u00151\u0006\u0005\n\u0003_i\u0011\u0011!CA\u0003cA\u0011\"!\u0010\u000e\u0003\u0003%I!a\u0010\u0003\rI{G\u000e\\;q\u0015\t)b#A\u0006fqB\u0014Xm]:j_:\u001c(BA\f\u0019\u0003!\u0019\u0017\r^1msN$(BA\r\u001b\u0003\r\u0019\u0018\u000f\u001c\u0006\u00037q\tQa\u001d9be.T!!\b\u0010\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005y\u0012aA8sO\u000e\u00011#\u0002\u0001#M%z\u0003CA\u0012%\u001b\u0005!\u0012BA\u0013\u0015\u0005))\u0005\u0010\u001d:fgNLwN\u001c\t\u0003G\u001dJ!\u0001\u000b\u000b\u0003\u0017\u001d\u0013x.\u001e9j]\u001e\u001cV\r\u001e\t\u0003U5j\u0011a\u000b\u0006\u0002Y\u0005)1oY1mC&\u0011af\u000b\u0002\b!J|G-^2u!\tQ\u0003'\u0003\u00022W\ta1+\u001a:jC2L'0\u00192mK\u0006aqM]8va\nKX\t\u001f9sgV\tA\u0007E\u00026{\tr!AN\u001e\u000f\u0005]RT\"\u0001\u001d\u000b\u0005e\u0002\u0013A\u0002\u001fs_>$h(C\u0001-\u0013\ta4&A\u0004qC\u000e\\\u0017mZ3\n\u0005yz$aA*fc*\u0011AhK\u0001\u000eOJ|W\u000f\u001d\"z\u000bb\u0004(o\u001d\u0011\u0002\rqJg.\u001b;?)\t\u0019E\t\u0005\u0002$\u0001!)!g\u0001a\u0001i\u0005!1m\u001c9z)\t\u0019u\tC\u00043\tA\u0005\t\u0019\u0001\u001b\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\t!J\u000b\u00025\u0017.\nA\n\u0005\u0002N%6\taJ\u0003\u0002P!\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003#.\n!\"\u00198o_R\fG/[8o\u0013\t\u0019fJA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DX#\u0001,\u0011\u0005]cV\"\u0001-\u000b\u0005eS\u0016\u0001\u00027b]\u001eT\u0011aW\u0001\u0005U\u00064\u0018-\u0003\u0002^1\n11\u000b\u001e:j]\u001e\fA\u0002\u001d:pIV\u001cG/\u0011:jif,\u0012\u0001\u0019\t\u0003U\u0005L!AY\u0016\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0005\u0015D\u0007C\u0001\u0016g\u0013\t97FA\u0002B]fDq!\u001b\u0005\u0002\u0002\u0003\u0007\u0001-A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0002YB\u0019Q\u000e]3\u000e\u00039T!a\\\u0016\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002r]\nA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\t!x\u000f\u0005\u0002+k&\u0011ao\u000b\u0002\b\u0005>|G.Z1o\u0011\u001dI'\"!AA\u0002\u0015\fa!Z9vC2\u001cHC\u0001;{\u0011\u001dI7\"!AA\u0002\u0015DS\u0002\u0001?\u0000\u0003\u0003\t)!a\u0002\u0002\f\u00055\u0001CA\u0012~\u0013\tqHCA\u000bFqB\u0014Xm]:j_:$Um]2sSB$\u0018n\u001c8\u0002\u000bU\u001c\u0018mZ3\"\u0005\u0005\r\u0011!a\b\u000bA\u0001\u0002\u0003e\u0018$V\u001d\u000e{\u0006fW2pYFZF\u0006I2pYJ\u0002cFL/^S\u0001j\u0003e\u0019:fCR,\u0007%\u0019\u0011nk2$\u0018.\f3j[\u0016t7/[8oC2\u0004#o\u001c7mkB\u0004So]5oO\u0002\"\b.\u001a\u0011ta\u0016\u001c\u0017NZ5fI\u0002\u001aw\u000e\\;n]NT\u0001\u0005\t\u0011!A\u0001\u001ax\u000e\t;iCR\u0004s/\u001a\u0011dC:\u0004#/\u001e8!C\u001e<'/Z4bi&|g\u000eI8oAQDW-\u001c\u0018\u000bA\u0001\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003\u0013\t\u00111\u001a\u0006!A\u0001\u0002S\t_1na2,7O\u000f\u0006!A\u0001\u0002\u0003\u0005\t !'\u0016cUi\u0011+!]\u0006lW\r\f\u0011bO\u0016d\u0003eY8v]RD#&\u000b\u0011G%>k\u0005EV!M+\u0016\u001b\u0006\u0005\u000b\u001a-A\u001d\nE.[2fO%b\u0003\u0005K\u001b-A\u001d\u0012uNY\u0014*AA,w\u000e\u001d7fQ\u0005<W\r\f\u0011oC6,\u0017\u0006I$S\u001fV\u0003\u0006EQ-!?\u001a+fjQ0)]\u0006lW\r\f\u0011bO\u0016L3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u0011C_\nLQ'C\u0019\u000bA\u0001\u0002\u0003\u0005\t\u0011!A\u0005c\u0017nY3\ne%\t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005I!mS\u000e,\u0017BT+M\u0019&\t$\u0002\t\u0011!A\u0001\u0002\u0003\u0005\t(V\u00192Ka*\u0016'M\u0013IR\u0001\u0005\t\u0011!A\u0001\u0002\u0003EQ8c\u00139+F\nT\u00052\u0015\u0001\u0002\u0013!B:j]\u000e,\u0017EAA\b\u0003\u0015\u0011d\u0006\r\u00181\u0003\u0019\u0011v\u000e\u001c7vaB\u00111%D\n\u0005\u001b\u0005]q\u0006\u0005\u0004\u0002\u001a\u0005}AgQ\u0007\u0003\u00037Q1!!\b,\u0003\u001d\u0011XO\u001c;j[\u0016LA!!\t\u0002\u001c\t\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0015\u0005\u0005M\u0011\u0001\u0003;p'R\u0014\u0018N\\4\u0015\u0003Y\u000bQ!\u00199qYf$2aQA\u0017\u0011\u0015\u0011\u0004\u00031\u00015\u0003\u001d)h.\u00199qYf$B!a\r\u0002:A!!&!\u000e5\u0013\r\t9d\u000b\u0002\u0007\u001fB$\u0018n\u001c8\t\u0011\u0005m\u0012#!AA\u0002\r\u000b1\u0001\u001f\u00131\u0003-\u0011X-\u00193SKN|GN^3\u0015\u0005\u0005\u0005\u0003cA,\u0002D%\u0019\u0011Q\t-\u0003\r=\u0013'.Z2u\u0001")
public class Rollup
extends Expression
implements GroupingSet,
Serializable {
    private final Seq<Expression> groupByExprs;
    private boolean resolved;
    private volatile boolean bitmap$0;

    public static Option<Seq<Expression>> unapply(Rollup rollup) {
        return Rollup$.MODULE$.unapply(rollup);
    }

    public static <A> Function1<Seq<Expression>, A> andThen(Function1<Rollup, A> function1) {
        return Rollup$.MODULE$.andThen(function1);
    }

    public static <A> Function1<A, Rollup> compose(Function1<A, Seq<Expression>> function1) {
        return Rollup$.MODULE$.compose(function1);
    }

    @Override
    public Seq<Expression> children() {
        return GroupingSet.children$(this);
    }

    @Override
    public DataType dataType() {
        return GroupingSet.dataType$(this);
    }

    @Override
    public boolean foldable() {
        return GroupingSet.foldable$(this);
    }

    @Override
    public boolean nullable() {
        return GroupingSet.nullable$(this);
    }

    @Override
    public Object eval(InternalRow input) {
        return GroupingSet.eval$(this, input);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    private boolean resolved$lzycompute() {
        Rollup rollup = this;
        synchronized (rollup) {
            if (!this.bitmap$0) {
                this.resolved = GroupingSet.resolved$(this);
                this.bitmap$0 = true;
            }
        }
        return this.resolved;
    }

    @Override
    public boolean resolved() {
        return !this.bitmap$0 ? this.resolved$lzycompute() : this.resolved;
    }

    @Override
    public Seq<Expression> groupByExprs() {
        return this.groupByExprs;
    }

    public Rollup copy(Seq<Expression> groupByExprs) {
        return new Rollup(groupByExprs);
    }

    public Seq<Expression> copy$default$1() {
        return this.groupByExprs();
    }

    @Override
    public String productPrefix() {
        return "Rollup";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger((int)x$1)).toString());
            }
        }
        return this.groupByExprs();
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Rollup;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Rollup)) return false;
        boolean bl = true;
        if (!bl) return false;
        Rollup rollup = (Rollup)x$1;
        Seq<Expression> seq = this.groupByExprs();
        Seq<Expression> seq2 = rollup.groupByExprs();
        if (seq == null) {
            if (seq2 != null) {
                return false;
            }
        } else if (!seq.equals(seq2)) return false;
        if (!rollup.canEqual(this)) return false;
        return true;
    }

    public Rollup(Seq<Expression> groupByExprs) {
        this.groupByExprs = groupByExprs;
        CodegenFallback.$init$(this);
        GroupingSet.$init$(this);
    }
}

