/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.shuffle.protocol;

import io.netty.buffer.ByteBuf;
import org.apache.spark.network.protocol.Encoders;
import org.apache.spark.network.shuffle.protocol.BlockTransferMessage;
import org.sparkproject.guava.base.Objects;

public class FinalizeShuffleMerge
extends BlockTransferMessage {
    public final String appId;
    public final int shuffleId;

    public FinalizeShuffleMerge(String appId, int shuffleId) {
        this.appId = appId;
        this.shuffleId = shuffleId;
    }

    @Override
    protected BlockTransferMessage.Type type() {
        return BlockTransferMessage.Type.FINALIZE_SHUFFLE_MERGE;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.appId, this.shuffleId});
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("appId", (Object)this.appId).add("shuffleId", this.shuffleId).toString();
    }

    public boolean equals(Object other) {
        if (other != null && other instanceof FinalizeShuffleMerge) {
            FinalizeShuffleMerge o = (FinalizeShuffleMerge)other;
            return Objects.equal((Object)this.appId, (Object)o.appId) && this.shuffleId == o.shuffleId;
        }
        return false;
    }

    public int encodedLength() {
        return Encoders.Strings.encodedLength((String)this.appId) + 4;
    }

    public void encode(ByteBuf buf) {
        Encoders.Strings.encode((ByteBuf)buf, (String)this.appId);
        buf.writeInt(this.shuffleId);
    }

    public static FinalizeShuffleMerge decode(ByteBuf buf) {
        String appId = Encoders.Strings.decode((ByteBuf)buf);
        int shuffleId = buf.readInt();
        return new FinalizeShuffleMerge(appId, shuffleId);
    }
}

