/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import org.apache.hadoop.hive.ql.exec.JoinUtil;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastHashMultiSet;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.fast.VectorMapJoinFastLongHashTable;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinHashMultiSetResult;
import org.apache.hadoop.hive.ql.exec.vector.mapjoin.hashtable.VectorMapJoinLongHashMultiSet;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.VectorMapJoinDesc;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hive.common.util.HashCodeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VectorMapJoinFastLongHashMultiSet
extends VectorMapJoinFastLongHashTable
implements VectorMapJoinLongHashMultiSet {
    public static final Logger LOG = LoggerFactory.getLogger(VectorMapJoinFastLongHashMultiSet.class);

    @Override
    public VectorMapJoinHashMultiSetResult createHashMultiSetResult() {
        return new VectorMapJoinFastHashMultiSet.HashMultiSetResult();
    }

    @VisibleForTesting
    public void testPutRow(long currentKey) throws HiveException, IOException {
        this.add(currentKey, null);
    }

    @Override
    public void assignSlot(int slot, long key, boolean isNewKey, BytesWritable currentValue) {
        int pairIndex = 2 * slot;
        if (isNewKey) {
            this.slotPairs[pairIndex] = 1L;
            this.slotPairs[pairIndex + 1] = key;
        } else {
            int n = pairIndex;
            this.slotPairs[n] = this.slotPairs[n] + 1L;
        }
    }

    @Override
    public JoinUtil.JoinResult contains(long key, VectorMapJoinHashMultiSetResult hashMultiSetResult) {
        JoinUtil.JoinResult joinResult;
        VectorMapJoinFastHashMultiSet.HashMultiSetResult optimizedHashMultiSetResult = (VectorMapJoinFastHashMultiSet.HashMultiSetResult)hashMultiSetResult;
        optimizedHashMultiSetResult.forget();
        long hashCode = HashCodeUtil.calculateLongHashCode((long)key);
        long count = this.findReadSlot(key, hashCode);
        if (count == -1L) {
            joinResult = JoinUtil.JoinResult.NOMATCH;
        } else {
            optimizedHashMultiSetResult.set(count);
            joinResult = JoinUtil.JoinResult.MATCH;
        }
        optimizedHashMultiSetResult.setJoinResult(joinResult);
        return joinResult;
    }

    public VectorMapJoinFastLongHashMultiSet(boolean minMaxEnabled, boolean isOuterJoin, VectorMapJoinDesc.HashTableKeyType hashTableKeyType, int initialCapacity, float loadFactor, int writeBuffersSize, long estimatedKeyCount) {
        super(minMaxEnabled, isOuterJoin, hashTableKeyType, initialCapacity, loadFactor, writeBuffersSize, estimatedKeyCount);
    }
}

