# mypy-boto3-ssm

[![PyPI - mypy-boto3-ssm](https://img.shields.io/pypi/v/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-ssm.svg?color=blue)](https://pypi.org/project/mypy-boto3-ssm)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.SSM 1.12.21](https://boto3.amazonaws.com/v1/documentation/api/1.12.21/reference/services/ssm.html#SSM) service
compatible with [mypy](https://github.com/python/mypy), [VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/) and other tools.

Generated by [mypy-boto3-buider 1.0.5](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-ssm](#mypy-boto3-ssm)
  - [How to use](#how-to-use)
    - [Type checking](#type-checking)
  - [How it works](#how-it-works)

## How to use

### Type checking

Make sure you have [mypy](https://github.com/python/mypy) installed and activated in your IDE.

Install `boto3-stubs` for `SSM` service.

```bash
python -m pip install boto3-stubs[mypy-boto3-ssm]
```

Use `boto3` with `mypy_boto3` in your project and enjoy type checking and auto-complete.

```python
import boto3

from mypy_boto3 import ssm
# alternative import if you do not want to install mypy_boto3 package
# import mypy_boto3_ssm as ssm

# Use this client as usual, now mypy can check if your code is valid.
# Check if your IDE supports function overloads,
# you probably do not need explicit type annotations
# client = boto3.client("ssm")
client: ssm.SSMClient = boto3.client("ssm")

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: ssm.SSMClient = session.client("ssm")


# Paginators need type annotation on creation
describe_activations_paginator: ssm.DescribeActivationsPaginator = client.get_paginator("describe_activations")
describe_association_execution_targets_paginator: ssm.DescribeAssociationExecutionTargetsPaginator = client.get_paginator("describe_association_execution_targets")
describe_association_executions_paginator: ssm.DescribeAssociationExecutionsPaginator = client.get_paginator("describe_association_executions")
describe_automation_executions_paginator: ssm.DescribeAutomationExecutionsPaginator = client.get_paginator("describe_automation_executions")
describe_automation_step_executions_paginator: ssm.DescribeAutomationStepExecutionsPaginator = client.get_paginator("describe_automation_step_executions")
describe_available_patches_paginator: ssm.DescribeAvailablePatchesPaginator = client.get_paginator("describe_available_patches")
describe_effective_instance_associations_paginator: ssm.DescribeEffectiveInstanceAssociationsPaginator = client.get_paginator("describe_effective_instance_associations")
describe_effective_patches_for_patch_baseline_paginator: ssm.DescribeEffectivePatchesForPatchBaselinePaginator = client.get_paginator("describe_effective_patches_for_patch_baseline")
describe_instance_associations_status_paginator: ssm.DescribeInstanceAssociationsStatusPaginator = client.get_paginator("describe_instance_associations_status")
describe_instance_information_paginator: ssm.DescribeInstanceInformationPaginator = client.get_paginator("describe_instance_information")
describe_instance_patch_states_paginator: ssm.DescribeInstancePatchStatesPaginator = client.get_paginator("describe_instance_patch_states")
describe_instance_patch_states_for_patch_group_paginator: ssm.DescribeInstancePatchStatesForPatchGroupPaginator = client.get_paginator("describe_instance_patch_states_for_patch_group")
describe_instance_patches_paginator: ssm.DescribeInstancePatchesPaginator = client.get_paginator("describe_instance_patches")
describe_inventory_deletions_paginator: ssm.DescribeInventoryDeletionsPaginator = client.get_paginator("describe_inventory_deletions")
describe_maintenance_window_execution_task_invocations_paginator: ssm.DescribeMaintenanceWindowExecutionTaskInvocationsPaginator = client.get_paginator("describe_maintenance_window_execution_task_invocations")
describe_maintenance_window_execution_tasks_paginator: ssm.DescribeMaintenanceWindowExecutionTasksPaginator = client.get_paginator("describe_maintenance_window_execution_tasks")
describe_maintenance_window_executions_paginator: ssm.DescribeMaintenanceWindowExecutionsPaginator = client.get_paginator("describe_maintenance_window_executions")
describe_maintenance_window_schedule_paginator: ssm.DescribeMaintenanceWindowSchedulePaginator = client.get_paginator("describe_maintenance_window_schedule")
describe_maintenance_window_targets_paginator: ssm.DescribeMaintenanceWindowTargetsPaginator = client.get_paginator("describe_maintenance_window_targets")
describe_maintenance_window_tasks_paginator: ssm.DescribeMaintenanceWindowTasksPaginator = client.get_paginator("describe_maintenance_window_tasks")
describe_maintenance_windows_paginator: ssm.DescribeMaintenanceWindowsPaginator = client.get_paginator("describe_maintenance_windows")
describe_maintenance_windows_for_target_paginator: ssm.DescribeMaintenanceWindowsForTargetPaginator = client.get_paginator("describe_maintenance_windows_for_target")
describe_parameters_paginator: ssm.DescribeParametersPaginator = client.get_paginator("describe_parameters")
describe_patch_baselines_paginator: ssm.DescribePatchBaselinesPaginator = client.get_paginator("describe_patch_baselines")
describe_patch_groups_paginator: ssm.DescribePatchGroupsPaginator = client.get_paginator("describe_patch_groups")
describe_sessions_paginator: ssm.DescribeSessionsPaginator = client.get_paginator("describe_sessions")
get_inventory_paginator: ssm.GetInventoryPaginator = client.get_paginator("get_inventory")
get_inventory_schema_paginator: ssm.GetInventorySchemaPaginator = client.get_paginator("get_inventory_schema")
get_parameter_history_paginator: ssm.GetParameterHistoryPaginator = client.get_paginator("get_parameter_history")
get_parameters_by_path_paginator: ssm.GetParametersByPathPaginator = client.get_paginator("get_parameters_by_path")
list_association_versions_paginator: ssm.ListAssociationVersionsPaginator = client.get_paginator("list_association_versions")
list_associations_paginator: ssm.ListAssociationsPaginator = client.get_paginator("list_associations")
list_command_invocations_paginator: ssm.ListCommandInvocationsPaginator = client.get_paginator("list_command_invocations")
list_commands_paginator: ssm.ListCommandsPaginator = client.get_paginator("list_commands")
list_compliance_items_paginator: ssm.ListComplianceItemsPaginator = client.get_paginator("list_compliance_items")
list_compliance_summaries_paginator: ssm.ListComplianceSummariesPaginator = client.get_paginator("list_compliance_summaries")
list_document_versions_paginator: ssm.ListDocumentVersionsPaginator = client.get_paginator("list_document_versions")
list_documents_paginator: ssm.ListDocumentsPaginator = client.get_paginator("list_documents")
list_resource_compliance_summaries_paginator: ssm.ListResourceComplianceSummariesPaginator = client.get_paginator("list_resource_compliance_summaries")
list_resource_data_sync_paginator: ssm.ListResourceDataSyncPaginator = client.get_paginator("list_resource_data_sync")
```

## How it works

Fully automated [builder](https://github.com/vemel/mypy_boto3_builder) carefully generates
type annotations for each service, patiently waiting for `boto3` updates. It delivers
a drop-in type annotations for you and makes sure that:

- All available `boto3` services are covered.
- Each public class and method of every `boto3` service gets valid type annotations
  extracted from the documentation (blame `botocore` docs if types are incorrect).
- Type annotations include up-to-date documentation.
- Link to documentation is provided for every method.
- Code is processed by [black](https://github.com/psf/black) for readability.