# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class WritableDialerContact(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        WritableDialerContact - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'contact_list_id': 'str',
            'data': 'dict(str, object)',
            'latest_sms_evaluations': 'dict(str, MessageEvaluation)',
            'callable': 'bool',
            'phone_number_status': 'dict(str, PhoneNumberStatus)'
        }

        self.attribute_map = {
            'id': 'id',
            'contact_list_id': 'contactListId',
            'data': 'data',
            'latest_sms_evaluations': 'latestSmsEvaluations',
            'callable': 'callable',
            'phone_number_status': 'phoneNumberStatus'
        }

        self._id = None
        self._contact_list_id = None
        self._data = None
        self._latest_sms_evaluations = None
        self._callable = None
        self._phone_number_status = None

    @property
    def id(self):
        """
        Gets the id of this WritableDialerContact.
        The globally unique identifier for the object.

        :return: The id of this WritableDialerContact.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this WritableDialerContact.
        The globally unique identifier for the object.

        :param id: The id of this WritableDialerContact.
        :type: str
        """
        
        self._id = id

    @property
    def contact_list_id(self):
        """
        Gets the contact_list_id of this WritableDialerContact.
        The identifier of the contact list containing this contact.

        :return: The contact_list_id of this WritableDialerContact.
        :rtype: str
        """
        return self._contact_list_id

    @contact_list_id.setter
    def contact_list_id(self, contact_list_id):
        """
        Sets the contact_list_id of this WritableDialerContact.
        The identifier of the contact list containing this contact.

        :param contact_list_id: The contact_list_id of this WritableDialerContact.
        :type: str
        """
        
        self._contact_list_id = contact_list_id

    @property
    def data(self):
        """
        Gets the data of this WritableDialerContact.
        An ordered map of the contact's columns and corresponding values.

        :return: The data of this WritableDialerContact.
        :rtype: dict(str, object)
        """
        return self._data

    @data.setter
    def data(self, data):
        """
        Sets the data of this WritableDialerContact.
        An ordered map of the contact's columns and corresponding values.

        :param data: The data of this WritableDialerContact.
        :type: dict(str, object)
        """
        
        self._data = data

    @property
    def latest_sms_evaluations(self):
        """
        Gets the latest_sms_evaluations of this WritableDialerContact.
        A map of SMS records for the contact phone columns.

        :return: The latest_sms_evaluations of this WritableDialerContact.
        :rtype: dict(str, MessageEvaluation)
        """
        return self._latest_sms_evaluations

    @latest_sms_evaluations.setter
    def latest_sms_evaluations(self, latest_sms_evaluations):
        """
        Sets the latest_sms_evaluations of this WritableDialerContact.
        A map of SMS records for the contact phone columns.

        :param latest_sms_evaluations: The latest_sms_evaluations of this WritableDialerContact.
        :type: dict(str, MessageEvaluation)
        """
        
        self._latest_sms_evaluations = latest_sms_evaluations

    @property
    def callable(self):
        """
        Gets the callable of this WritableDialerContact.
        Indicates whether or not the contact can be called.

        :return: The callable of this WritableDialerContact.
        :rtype: bool
        """
        return self._callable

    @callable.setter
    def callable(self, callable):
        """
        Sets the callable of this WritableDialerContact.
        Indicates whether or not the contact can be called.

        :param callable: The callable of this WritableDialerContact.
        :type: bool
        """
        
        self._callable = callable

    @property
    def phone_number_status(self):
        """
        Gets the phone_number_status of this WritableDialerContact.
        A map of phone number columns to PhoneNumberStatuses, which indicate if the phone number is callable or not.

        :return: The phone_number_status of this WritableDialerContact.
        :rtype: dict(str, PhoneNumberStatus)
        """
        return self._phone_number_status

    @phone_number_status.setter
    def phone_number_status(self, phone_number_status):
        """
        Sets the phone_number_status of this WritableDialerContact.
        A map of phone number columns to PhoneNumberStatuses, which indicate if the phone number is callable or not.

        :param phone_number_status: The phone_number_status of this WritableDialerContact.
        :type: dict(str, PhoneNumberStatus)
        """
        
        self._phone_number_status = phone_number_status

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

